/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.AbstractTest;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadByteCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractSizesTest<AFU extends AbstractFileUpload<R, I, F>, R, I extends FileItem<I>, F extends FileItemFactory<I>>
extends AbstractTest<AFU, R, I, F> {
    @Test
    public void testFileSizeLimit() throws IOException {
        String content = "This is the content of the file\n";
        int contentSize = "This is the content of the file\n".getBytes().length;
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        Object upload = this.newFileUpload();
        upload.setFileSizeMax(-1L);
        Object req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        List fileItems = upload.parseRequest(req);
        Assertions.assertEquals((int)1, (int)fileItems.size());
        FileItem item = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"This is the content of the file\n", (Object)new String(item.get()));
        upload = this.newFileUpload();
        upload.setFileSizeMax(40L);
        req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        fileItems = upload.parseRequest(req);
        Assertions.assertEquals((int)1, (int)fileItems.size());
        item = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"This is the content of the file\n", (Object)new String(item.get()));
        upload = this.newFileUpload();
        upload.setFileSizeMax((long)contentSize);
        req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        fileItems = upload.parseRequest(req);
        Assertions.assertEquals((int)1, (int)fileItems.size());
        item = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"This is the content of the file\n", (Object)new String(item.get()));
        upload = this.newFileUpload();
        upload.setFileSizeMax((long)(contentSize - 1));
        req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        try {
            upload.parseRequest(req);
            Assertions.fail((String)"Expected exception.");
        }
        catch (FileUploadByteCountLimitException e) {
            Assertions.assertEquals((long)(contentSize - 1), (long)e.getPermitted());
        }
        upload = this.newFileUpload();
        upload.setFileSizeMax(30L);
        req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        try {
            upload.parseRequest(req);
            Assertions.fail((String)"Expected exception.");
        }
        catch (FileUploadByteCountLimitException e) {
            Assertions.assertEquals((long)30L, (long)e.getPermitted());
        }
    }

    @Test
    public void testFileSizeLimitWithFakedContentLength() throws IOException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        Object upload = this.newFileUpload();
        upload.setFileSizeMax(-1L);
        Object req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        List fileItems = upload.parseRequest(req);
        Assertions.assertEquals((int)1, (int)fileItems.size());
        FileItem item = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"This is the content of the file\n", (Object)new String(item.get()));
        upload = this.newFileUpload();
        upload.setFileSizeMax(40L);
        req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        fileItems = upload.parseRequest(req);
        Assertions.assertEquals((int)1, (int)fileItems.size());
        item = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"This is the content of the file\n", (Object)new String(item.get()));
        upload = this.newFileUpload();
        upload.setFileSizeMax(5L);
        req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        try {
            upload.parseRequest(req);
            Assertions.fail((String)"Expected exception.");
        }
        catch (FileUploadByteCountLimitException e) {
            Assertions.assertEquals((long)5L, (long)e.getPermitted());
        }
        upload = this.newFileUpload();
        upload.setFileSizeMax(15L);
        req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        try {
            upload.parseRequest(req);
            Assertions.fail((String)"Expected exception.");
        }
        catch (FileUploadByteCountLimitException e) {
            Assertions.assertEquals((long)15L, (long)e.getPermitted());
        }
    }

    @Test
    public void testMaxSizeLimit() throws IOException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        Object upload = this.newFileUpload();
        upload.setFileSizeMax(-1L);
        upload.setSizeMax(200L);
        Object req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", null, null);
        try {
            upload.parseRequest(req);
            Assertions.fail((String)"Expected exception.");
        }
        catch (FileUploadSizeException e) {
            Assertions.assertEquals((long)200L, (long)e.getPermitted());
        }
    }

    @Test
    public void testMaxSizeLimitUnknownContentLength() throws IOException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        Object upload = this.newFileUpload();
        upload.setFileSizeMax(-1L);
        upload.setSizeMax(300L);
        Object req = this.newMockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n", -1L, 10);
        FileItemInputIterator it = upload.getItemIterator(req);
        Assertions.assertTrue((boolean)it.hasNext());
        FileItemInput item = it.next();
        Assertions.assertFalse((boolean)item.isFormField());
        Assertions.assertEquals((Object)"file1", (Object)item.getFieldName());
        Assertions.assertEquals((Object)"foo1.tab", (Object)item.getName());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             InputStream stream = item.getInputStream();){
            IOUtils.copy((InputStream)stream, (OutputStream)baos);
        }
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertThrows(FileUploadException.class, () -> {
            FileItemInput item2 = it.next();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 InputStream stream = item2.getInputStream();){
                IOUtils.copy((InputStream)stream, (OutputStream)baos);
            }
        });
    }
}

