/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.util.Map;
import org.apache.commons.fileupload2.core.ParameterParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParameterParserTest {
    @Test
    public void testContentTypeParsing() {
        String s = "text/plain; Charset=UTF-8";
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse("text/plain; Charset=UTF-8", ';');
        Assertions.assertEquals((Object)"UTF-8", params.get("charset"));
    }

    @Test
    public void testFileUpload139() {
        ParameterParser parser = new ParameterParser();
        String s = "Content-type: multipart/form-data , boundary=AaB03x";
        Map params = parser.parse(s, new char[]{',', ';'});
        Assertions.assertEquals((Object)"AaB03x", params.get("boundary"));
        s = "Content-type: multipart/form-data, boundary=AaB03x";
        params = parser.parse(s, new char[]{';', ','});
        Assertions.assertEquals((Object)"AaB03x", params.get("boundary"));
        s = "Content-type: multipart/mixed, boundary=BbC04y";
        params = parser.parse(s, new char[]{',', ';'});
        Assertions.assertEquals((Object)"BbC04y", params.get("boundary"));
    }

    @Test
    public void testFileUpload199() {
        ParameterParser parser = new ParameterParser();
        String s = "Content-Disposition: form-data; name=\"file\"; filename=\"=?ISO-8859-1?B?SWYgeW91IGNhbiByZWFkIHRoaXMgeW8=?= =?ISO-8859-2?B?dSB1bmRlcnN0YW5kIHRoZSBleGFtcGxlLg==?=\"\r\n";
        Map params = parser.parse("Content-Disposition: form-data; name=\"file\"; filename=\"=?ISO-8859-1?B?SWYgeW91IGNhbiByZWFkIHRoaXMgeW8=?= =?ISO-8859-2?B?dSB1bmRlcnN0YW5kIHRoZSBleGFtcGxlLg==?=\"\r\n", new char[]{',', ';'});
        Assertions.assertEquals((Object)"If you can read this you understand the example.", params.get("filename"));
    }

    @Test
    public void testFileUpload274() {
        ParameterParser parser = new ParameterParser();
        String s = "Content-Disposition: form-data; name=\"file\"; filename*=UTF-8''%E3%81%93%E3%82%93%E3%81%AB%E3%81%A1%E3%81%AF\r\n";
        Map params = parser.parse(s, new char[]{',', ';'});
        Assertions.assertEquals((Object)"\u3053\u3093\u306b\u3061\u306f", params.get("filename"));
        s = "Content-Disposition: form-data; name=\"file\"; filename*=UTF-8''%70%C3%A2%74%C3%A9\r\n";
        params = parser.parse(s, new char[]{',', ';'});
        Assertions.assertEquals((Object)"p\u00e2t\u00e9", params.get("filename"));
        s = "Content-Disposition: form-data; name=\"file\"; file*name=UTF-8''%61%62%63\r\n";
        params = parser.parse(s, new char[]{',', ';'});
        Assertions.assertEquals((Object)"UTF-8''%61%62%63", params.get("file*name"));
        s = "Content-Disposition: form-data; name=\"file\"; filename*=a'bc\r\n";
        params = parser.parse(s, new char[]{',', ';'});
        Assertions.assertEquals((Object)"a'bc", params.get("filename"));
        s = "Content-Disposition: form-data; name=\"file\"; filename=a'b'c\r\n";
        params = parser.parse(s, new char[]{',', ';'});
        Assertions.assertEquals((Object)"a'b'c", params.get("filename"));
    }

    @Test
    public void testParsing() {
        String s = "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=\"stuff";
        ParameterParser parser = new ParameterParser();
        Map params = parser.parse(s, ';');
        Assertions.assertNull(params.get("test"));
        Assertions.assertEquals((Object)"stuff", params.get("test1"));
        Assertions.assertEquals((Object)"stuff; stuff", params.get("test2"));
        Assertions.assertEquals((Object)"\"stuff", params.get("test3"));
        params = parser.parse(s, new char[]{',', ';'});
        Assertions.assertNull(params.get("test"));
        Assertions.assertEquals((Object)"stuff", params.get("test1"));
        Assertions.assertEquals((Object)"stuff; stuff", params.get("test2"));
        Assertions.assertEquals((Object)"\"stuff", params.get("test3"));
        s = "  test  , test1=stuff   ,  , test2=, test3, ";
        params = parser.parse(s, ',');
        Assertions.assertNull(params.get("test"));
        Assertions.assertEquals((Object)"stuff", params.get("test1"));
        Assertions.assertNull(params.get("test2"));
        Assertions.assertNull(params.get("test3"));
        s = "  test";
        params = parser.parse(s, ';');
        Assertions.assertNull(params.get("test"));
        s = "  ";
        params = parser.parse(s, ';');
        Assertions.assertEquals((int)0, (int)params.size());
        s = " = stuff ";
        params = parser.parse(s, ';');
        Assertions.assertEquals((int)0, (int)params.size());
    }

    @Test
    public void testParsingEscapedChars() {
        String s = "param = \"stuff\\\"; more stuff\"";
        ParameterParser parser = new ParameterParser();
        Map params = parser.parse(s, ';');
        Assertions.assertEquals((int)1, (int)params.size());
        Assertions.assertEquals((Object)"stuff\\\"; more stuff", params.get("param"));
        s = "param = \"stuff\\\\\"; anotherparam";
        params = parser.parse(s, ';');
        Assertions.assertEquals((int)2, (int)params.size());
        Assertions.assertEquals((Object)"stuff\\\\", params.get("param"));
        Assertions.assertNull(params.get("anotherparam"));
    }
}

