/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class Util {
    public static List<FileItem> parseUpload(FileUpload upload, byte[] bytes) throws FileUploadException {
        return Util.parseUpload(upload, bytes, "multipart/form-data; boundary=---1234");
    }

    public static List<FileItem> parseUpload(FileUpload upload, byte[] bytes, String contentType) throws FileUploadException {
        MockHttpServletRequest request = new MockHttpServletRequest(bytes, contentType);
        List fileItems = upload.parseRequest((RequestContext)new ServletRequestContext((HttpServletRequest)request));
        return fileItems;
    }

    public static List<FileItem> parseUpload(FileUpload upload, String content) throws UnsupportedEncodingException, FileUploadException {
        byte[] bytes = content.getBytes("US-ASCII");
        return Util.parseUpload(upload, bytes, "multipart/form-data; boundary=---1234");
    }

    public static List<FileUpload> fileUploadImplementations() {
        return Arrays.asList(new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()), new PortletFileUpload((FileItemFactory)new DiskFileItemFactory()));
    }
}

