/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.fileupload.DefaultFileItem;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFileItemTest {
    private static final String textContentType = "text/plain";
    private static final String fileContentType = "application/octet-stream";
    private static final int threshold = 16;
    static final String CHARSET_ISO88591 = "ISO-8859-1";
    static final String CHARSET_ASCII = "US-ASCII";
    static final String CHARSET_UTF8 = "UTF-8";
    static final String CHARSET_KOI8_R = "KOI8_R";
    static final String CHARSET_WIN1251 = "Cp1251";
    static final int[] SWISS_GERMAN_STUFF_UNICODE = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] SWISS_GERMAN_STUFF_ISO8859_1 = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] SWISS_GERMAN_STUFF_UTF8 = new int[]{71, 114, 195, 188, 101, 122, 105, 95, 122, 195, 164, 109, 195, 164};
    static final int[] RUSSIAN_STUFF_UNICODE = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};
    static final int[] RUSSIAN_STUFF_UTF8 = new int[]{208, 146, 209, 129, 208, 181, 208, 188, 95, 208, 191, 209, 128, 208, 184, 208, 178, 208, 181, 209, 130};
    static final int[] RUSSIAN_STUFF_KOI8R = new int[]{247, 211, 197, 205, 95, 208, 210, 201, 215, 197, 212};
    static final int[] RUSSIAN_STUFF_WIN1251 = new int[]{194, 241, 229, 236, 95, 239, 240, 232, 226, 229, 242};

    @Test
    public void testTextFieldConstruction() {
        FileItemFactory factory = this.createFactory(null);
        String textFieldName = "textField";
        FileItem item = factory.createItem(textFieldName, textContentType, true, null);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)item.getFieldName(), (Object)textFieldName);
        Assert.assertEquals((Object)item.getContentType(), (Object)textContentType);
        Assert.assertTrue((boolean)item.isFormField());
        Assert.assertNull((Object)item.getName());
    }

    @Test
    public void testFileFieldConstruction() {
        FileItemFactory factory = this.createFactory(null);
        String fileFieldName = "fileField";
        String fileName = "originalFileName";
        FileItem item = factory.createItem(fileFieldName, fileContentType, false, fileName);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)item.getFieldName(), (Object)fileFieldName);
        Assert.assertEquals((Object)item.getContentType(), (Object)fileContentType);
        Assert.assertFalse((boolean)item.isFormField());
        Assert.assertEquals((Object)item.getName(), (Object)fileName);
    }

    @Test
    public void testBelowThreshold() {
        FileItemFactory factory = this.createFactory(null);
        String textFieldName = "textField";
        String textFieldValue = "0123456789";
        byte[] testFieldValueBytes = textFieldValue.getBytes();
        FileItem item = factory.createItem(textFieldName, textContentType, true, null);
        Assert.assertNotNull((Object)item);
        try {
            OutputStream os = item.getOutputStream();
            os.write(testFieldValueBytes);
            os.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
        Assert.assertTrue((boolean)item.isInMemory());
        Assert.assertEquals((long)item.getSize(), (long)testFieldValueBytes.length);
        Assert.assertTrue((boolean)Arrays.equals(item.get(), testFieldValueBytes));
        Assert.assertEquals((Object)item.getString(), (Object)textFieldValue);
    }

    @Test
    public void testAboveThresholdDefaultRepository() {
        this.doTestAboveThreshold(null);
    }

    @Test
    public void testAboveThresholdSpecifiedRepository() throws IOException {
        String tempPath = System.getProperty("java.io.tmpdir");
        String tempDirName = "testAboveThresholdSpecifiedRepository";
        File tempDir = new File(tempPath, tempDirName);
        FileUtils.forceMkdir((File)tempDir);
        this.doTestAboveThreshold(tempDir);
        Assert.assertTrue((boolean)tempDir.delete());
    }

    public void doTestAboveThreshold(File repository) {
        FileItemFactory factory = this.createFactory(repository);
        String textFieldName = "textField";
        String textFieldValue = "01234567890123456789";
        byte[] testFieldValueBytes = textFieldValue.getBytes();
        FileItem item = factory.createItem(textFieldName, textContentType, true, null);
        Assert.assertNotNull((Object)item);
        try {
            OutputStream os = item.getOutputStream();
            os.write(testFieldValueBytes);
            os.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
        Assert.assertFalse((boolean)item.isInMemory());
        Assert.assertEquals((long)item.getSize(), (long)testFieldValueBytes.length);
        Assert.assertTrue((boolean)Arrays.equals(item.get(), testFieldValueBytes));
        Assert.assertEquals((Object)item.getString(), (Object)textFieldValue);
        Assert.assertTrue((boolean)(item instanceof DefaultFileItem));
        DefaultFileItem dfi = (DefaultFileItem)item;
        File storeLocation = dfi.getStoreLocation();
        Assert.assertNotNull((Object)storeLocation);
        Assert.assertTrue((boolean)storeLocation.exists());
        Assert.assertEquals((long)storeLocation.length(), (long)testFieldValueBytes.length);
        if (repository != null) {
            Assert.assertEquals((Object)storeLocation.getParentFile(), (Object)repository);
        }
        item.delete();
    }

    protected FileItemFactory createFactory(File repository) {
        return new DefaultFileItemFactory(16, repository);
    }

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    public void testContentCharSet() throws Exception {
        FileItemFactory factory = this.createFactory(null);
        String teststr = DefaultFileItemTest.constructString(SWISS_GERMAN_STUFF_UNICODE);
        FileItem item = factory.createItem("doesnotmatter", "text/plain; charset=ISO-8859-1", true, null);
        OutputStream outstream = item.getOutputStream();
        for (int element : SWISS_GERMAN_STUFF_ISO8859_1) {
            outstream.write(element);
        }
        outstream.close();
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
        item = factory.createItem("doesnotmatter", "text/plain; charset=UTF-8", true, null);
        outstream = item.getOutputStream();
        for (int element : SWISS_GERMAN_STUFF_UTF8) {
            outstream.write(element);
        }
        outstream.close();
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
        teststr = DefaultFileItemTest.constructString(RUSSIAN_STUFF_UNICODE);
        item = factory.createItem("doesnotmatter", "text/plain; charset=KOI8_R", true, null);
        outstream = item.getOutputStream();
        for (int element : RUSSIAN_STUFF_KOI8R) {
            outstream.write(element);
        }
        outstream.close();
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
        item = factory.createItem("doesnotmatter", "text/plain; charset=Cp1251", true, null);
        outstream = item.getOutputStream();
        for (int element : RUSSIAN_STUFF_WIN1251) {
            outstream.write(element);
        }
        outstream.close();
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
        item = factory.createItem("doesnotmatter", "text/plain; charset=UTF-8", true, null);
        outstream = item.getOutputStream();
        for (int element : RUSSIAN_STUFF_UTF8) {
            outstream.write(element);
        }
        outstream.close();
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
    }
}

