/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.time.Duration;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.junit.jupiter.api.Test;

public class Exec49Test {
    private static final Duration WAIT = Duration.ofSeconds(10L);
    private final Executor exec = DefaultExecutor.builder().get();

    @Test
    public void testExec49_1() throws Exception {
        if (OS.isFamilyUnix()) {
            CommandLine cl = CommandLine.parse((String)"/bin/ls");
            cl.addArgument("/opt");
            try (PipedOutputStream pipedOutputStream = new PipedOutputStream();){
                PumpStreamHandler psh = new PumpStreamHandler((OutputStream)pipedOutputStream);
                this.exec.setStreamHandler((ExecuteStreamHandler)psh);
                System.out.println("Preparing to execute process - commandLine=" + cl.toString());
                DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
                this.exec.execute(cl, (ExecuteResultHandler)handler);
                System.out.println("Process spun off successfully - process=" + cl.getExecutable());
                try (PipedInputStream pis = new PipedInputStream(pipedOutputStream);){
                    while (pis.read() >= 0) {
                    }
                }
                handler.waitFor(WAIT);
                handler.getExitValue();
            }
        }
    }

    @Test
    public void testExec49_2() throws Exception {
        if (OS.isFamilyUnix()) {
            CommandLine cl = CommandLine.parse((String)"/bin/ls");
            cl.addArgument("/opt");
            try (PipedOutputStream pipedOutputStream = new PipedOutputStream();){
                PumpStreamHandler psh = new PumpStreamHandler((OutputStream)pipedOutputStream, (OutputStream)new ByteArrayOutputStream());
                this.exec.setStreamHandler((ExecuteStreamHandler)psh);
                System.out.println("Preparing to execute process - commandLine=" + cl.toString());
                DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
                this.exec.execute(cl, (ExecuteResultHandler)handler);
                System.out.println("Process spun off successfully - process=" + cl.getExecutable());
                try (PipedInputStream pis = new PipedInputStream(pipedOutputStream);){
                    while (pis.read() >= 0) {
                    }
                }
                handler.waitFor(WAIT);
                handler.getExitValue();
            }
        }
    }
}

