/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import org.apache.commons.exec.TestUtil;

public abstract class AbstractExecTest {
    public static final int TEST_TIMEOUT = 15000;
    public static final int WATCHDOG_TIMEOUT = 3000;
    private static final String OS_NAME = System.getProperty("os.name");
    private final File testDir = new File("src/test/scripts");

    protected File resolveTestScript(String baseName) {
        File result = TestUtil.resolveScriptForOS(this.testDir + "/" + baseName);
        if (!result.exists()) {
            throw new IllegalArgumentException("Unable to find the following file: " + result.getAbsolutePath());
        }
        return result;
    }

    protected File resolveTestScript(String directoryName, String baseName) {
        File result = TestUtil.resolveScriptForOS(this.testDir + "/" + directoryName + "/" + baseName);
        if (!result.exists()) {
            throw new IllegalArgumentException("Unable to find the following file: " + result.getAbsolutePath());
        }
        return result;
    }

    protected String testIsBrokenForCurrentOperatingSystem() {
        String msg = String.format("The test is broken for OS : %s", OS_NAME);
        System.err.println(msg);
        return msg;
    }

    protected String testNotSupportedForCurrentOperatingSystem() {
        String msg = String.format("The test is not possible for OS : %s", OS_NAME);
        System.out.println(msg);
        return msg;
    }
}

