/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class Exec44Test {
    private final Executor exec = new DefaultExecutor();
    private final File testDir = new File("src/test/scripts");
    private final File foreverTestScript = TestUtil.resolveScriptForOS(this.testDir + "/forever");

    @Test
    public void testExec44() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(-1L);
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cl, (ExecuteResultHandler)resultHandler);
        Thread.sleep(5000L);
        Assert.assertTrue((String)"The watchdog is watching the process", (boolean)watchdog.isWatching());
        watchdog.destroyProcess();
        Assert.assertTrue((String)"The watchdog has killed the process", (boolean)watchdog.killedProcess());
        Assert.assertFalse((String)"The watchdog is no longer watching any process", (boolean)watchdog.isWatching());
    }
}

