/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class Exec60Test {
    private final Executor exec = new DefaultExecutor();
    private final File testDir = new File("src/test/scripts");
    private final File pingScript = TestUtil.resolveScriptForOS(this.testDir + "/ping");

    @Test
    public void testExec_60() throws Exception {
        boolean start = false;
        boolean seconds = true;
        boolean offsetMultiplier = true;
        int maxRetries = 180;
        int processTerminatedCounter = 0;
        int watchdogKilledProcessCounter = 0;
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument(Integer.toString(2));
        long startTime = System.currentTimeMillis();
        for (int offset = 0; offset <= 180; ++offset) {
            ExecuteWatchdog watchdog = new ExecuteWatchdog((long)(1000 + offset * 1));
            this.exec.setWatchdog(watchdog);
            try {
                this.exec.execute(cmdLine);
                if (++processTerminatedCounter <= 5) continue;
                break;
            }
            catch (ExecuteException ex) {
                Assert.assertTrue((String)"Watchdog killed the process", (boolean)watchdog.killedProcess());
                ++watchdogKilledProcessCounter;
            }
        }
        long avg = (System.currentTimeMillis() - startTime) / (long)(watchdogKilledProcessCounter + processTerminatedCounter);
        System.out.println("Processes terminated: " + processTerminatedCounter + " killed: " + watchdogKilledProcessCounter + " Multiplier: " + 1 + " MaxRetries: " + 180 + " Elapsed (avg ms): " + avg);
        Assert.assertTrue((String)"Not a single process terminated on its own", (processTerminatedCounter > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Not a single process was killed by the watch dog", (watchdogKilledProcessCounter > 0 ? 1 : 0) != 0);
    }
}

