/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.junit.Assert;
import org.junit.Test;

public class Exec57Test {
    private final File testDir = new File("src/test/scripts");

    @Test
    public void testExec_57() throws IOException {
        if (!OS.isFamilyUnix()) {
            System.err.println("The test 'testSyncInvocationOfBackgroundProcess' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        CommandLine cmdLine = new CommandLine("sh").addArgument("-c").addArgument(this.testDir + "/invoker.sh", false);
        DefaultExecutor executor = new DefaultExecutor();
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err);
        pumpStreamHandler.setStopTimeout(2000L);
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        long startTime = System.currentTimeMillis();
        System.out.println("Executing " + cmdLine);
        try {
            executor.execute(cmdLine);
        }
        catch (ExecuteException e) {
            long duration = System.currentTimeMillis() - startTime;
            System.out.println("Process completed in " + duration + " millis; above is its output");
            return;
        }
        Assert.fail((String)"Expecting an ExecuteException");
    }
}

