/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class Exec36Test {
    private final Executor exec = new DefaultExecutor();
    private final File testDir = new File("src/test/scripts");
    private final File printArgsScript = TestUtil.resolveScriptForOS(this.testDir + "/printargs");
    private ByteArrayOutputStream baos;

    @Before
    public void setUp() throws Exception {
        this.baos = new ByteArrayOutputStream();
        this.exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)this.baos, (OutputStream)this.baos));
    }

    @After
    public void tearDown() throws Exception {
        this.baos.close();
    }

    @Test
    public void testExec36_1() throws Exception {
        if (!OS.isFamilyUnix()) {
            System.err.println("The test 'testExec36_1' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        String expected = "./script/jrake\ncruise:publish_installers\nINSTALLER_VERSION=unstable_2_1\nINSTALLER_PATH=\"/var/lib/ cruise-agent/installers\"\nINSTALLER_DOWNLOAD_SERVER='something'\nWITHOUT_HELP_DOC=true";
        CommandLine cmdl = new CommandLine(this.printArgsScript);
        cmdl.addArgument("./script/jrake", false);
        cmdl.addArgument("cruise:publish_installers", false);
        cmdl.addArgument("INSTALLER_VERSION=unstable_2_1", false);
        cmdl.addArgument("INSTALLER_PATH=\"/var/lib/ cruise-agent/installers\"", false);
        cmdl.addArgument("INSTALLER_DOWNLOAD_SERVER='something'", false);
        cmdl.addArgument("WITHOUT_HELP_DOC=true", false);
        int exitValue = this.exec.execute(cmdl);
        String result = this.baos.toString().trim();
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
        Assert.assertEquals((Object)"./script/jrake\ncruise:publish_installers\nINSTALLER_VERSION=unstable_2_1\nINSTALLER_PATH=\"/var/lib/ cruise-agent/installers\"\nINSTALLER_DOWNLOAD_SERVER='something'\nWITHOUT_HELP_DOC=true", (Object)result);
    }

    @Test
    public void testExec36_2() throws Exception {
        String expected;
        if (OS.isFamilyWindows()) {
            expected = "dotnetfx.exe\n/q:a\n/c:\"install.exe /l \"\"\\Documents and Settings\\myusername\\Local Settings\\Temp\\netfx.log\"\" /q\"";
        } else if (OS.isFamilyUnix()) {
            expected = "dotnetfx.exe\n/q:a\n/c:\"install.exe /l \"\"/Documents and Settings/myusername/Local Settings/Temp/netfx.log\"\" /q\"";
        } else {
            System.err.println("The test 'testExec36_3' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        File file = new File("/Documents and Settings/myusername/Local Settings/Temp/netfx.log");
        HashMap<String, File> map = new HashMap<String, File>();
        map.put("FILE", file);
        CommandLine cmdl = new CommandLine(this.printArgsScript);
        cmdl.setSubstitutionMap(map);
        cmdl.addArgument("dotnetfx.exe", false);
        cmdl.addArgument("/q:a", false);
        cmdl.addArgument("/c:\"install.exe /l \"\"${FILE}\"\" /q\"", false);
        int exitValue = this.exec.execute(cmdl);
        String result = this.baos.toString().trim();
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
        if (OS.isFamilyUnix()) {
            Assert.assertEquals((Object)expected, (Object)result);
        }
    }

    @Test
    @Ignore
    public void _testExec36_4() throws Exception {
        String line = "./script/jrake cruise:publish_installers INSTALLER_VERSION=unstable_2_1 INSTALLER_PATH=\"/var/lib/cruise-agent/installers\" INSTALLER_DOWNLOAD_SERVER='something'WITHOUT_HELP_DOC=true";
        CommandLine cmdl = CommandLine.parse((String)"./script/jrake cruise:publish_installers INSTALLER_VERSION=unstable_2_1 INSTALLER_PATH=\"/var/lib/cruise-agent/installers\" INSTALLER_DOWNLOAD_SERVER='something'WITHOUT_HELP_DOC=true");
        String[] args = cmdl.toStrings();
        Assert.assertEquals((Object)"./script/jrake", (Object)args[0]);
        Assert.assertEquals((Object)"cruise:publish_installers", (Object)args[1]);
        Assert.assertEquals((Object)"INSTALLER_VERSION=unstable_2_1", (Object)args[2]);
        Assert.assertEquals((Object)"INSTALLER_PATH=\"/var/lib/cruise-agent/installers\"", (Object)args[3]);
        Assert.assertEquals((Object)"INSTALLER_DOWNLOAD_SERVER='something'", (Object)args[4]);
        Assert.assertEquals((Object)"WITHOUT_HELP_DOC=true", (Object)args[5]);
    }

    @Test
    @Ignore
    public void _testExec36_5() {
        String line = "dotnetfx.exe /q:a /c:\"install.exe /l \"\"c:\\Documents and Settings\\myusername\\Local Settings\\Temp\\netfx.log\"\" /q\"";
        CommandLine cmdl = CommandLine.parse((String)"dotnetfx.exe /q:a /c:\"install.exe /l \"\"c:\\Documents and Settings\\myusername\\Local Settings\\Temp\\netfx.log\"\" /q\"");
        String[] args = cmdl.toStrings();
        Assert.assertEquals((Object)"dotnetfx.exe", (Object)args[0]);
        Assert.assertEquals((Object)"/q:a", (Object)args[1]);
        Assert.assertEquals((Object)"/c:\"install.exe /l \"\"c:\\Documents and Settings\\myusername\\Local Settings\\Temp\\netfx.log\"\" /q\"", (Object)args[2]);
    }

    @Test
    @Ignore
    public void _testExec36_6() {
        String commandline = "C:\\CVS_DB\\WeightsEngine /f WeightsEngine.mak CFG=\"WeightsEngine - Win32Release\"";
        CommandLine cmdl = CommandLine.parse((String)"C:\\CVS_DB\\WeightsEngine /f WeightsEngine.mak CFG=\"WeightsEngine - Win32Release\"");
        String[] args = cmdl.getArguments();
        Assert.assertEquals((Object)"/f", (Object)args[0]);
        Assert.assertEquals((Object)"WeightsEngine.mak", (Object)args[1]);
        Assert.assertEquals((Object)"CFG=\"WeightsEngine - Win32Release\"", (Object)args[2]);
    }
}

