/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class Exec34Test {
    private final Executor exec = new DefaultExecutor();
    private final File testDir = new File("src/test/scripts");
    private final File pingScript = TestUtil.resolveScriptForOS(this.testDir + "/ping");

    @Test
    public void testExec34_1() throws Exception {
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument("10");
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Integer.MAX_VALUE);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cmdLine, (ExecuteResultHandler)handler);
        Assert.assertTrue((boolean)watchdog.isWatching());
        watchdog.destroyProcess();
        Assert.assertTrue((String)"Watchdog should have killed the process", (boolean)watchdog.killedProcess());
        Assert.assertFalse((String)"Watchdog is no longer watching the process", (boolean)watchdog.isWatching());
    }

    @Test
    public void testExec34_2() throws Exception {
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument("10");
        ExecuteWatchdog watchdog = new ExecuteWatchdog(5000L);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cmdLine, (ExecuteResultHandler)handler);
        handler.waitFor();
        Assert.assertTrue((String)"Process has exited", (boolean)handler.hasResult());
        Assert.assertNotNull((String)"Process was aborted", (Object)((Object)handler.getException()));
        Assert.assertTrue((String)"Watchdog should have killed the process", (boolean)watchdog.killedProcess());
        Assert.assertFalse((String)"Watchdog is no longer watching the process", (boolean)watchdog.isWatching());
    }
}

