/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.environment;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.junit.Assert;
import org.junit.Test;

public class EnvironmentUtilsTest {
    @Test
    public void testToStrings() {
        Assert.assertNull((Object)EnvironmentUtils.toStrings(null));
        HashMap<String, String> env = new HashMap<String, String>();
        Assert.assertArrayEquals((Object[])new String[0], (Object[])EnvironmentUtils.toStrings(env));
        env.put("foo2", "bar2");
        env.put("foo", "bar");
        Object[] envStrings = EnvironmentUtils.toStrings(env);
        Object[] expected = new String[]{"foo2=bar2", "foo=bar"};
        Arrays.sort(expected);
        Arrays.sort(envStrings);
        Assert.assertArrayEquals((Object[])expected, (Object[])envStrings);
    }

    @Test
    public void testGetProcEnvironment() throws IOException {
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        Assert.assertTrue((String)"Expecting non-zero environment size", (procEnvironment.size() > 0 ? 1 : 0) != 0);
        String[] envArgs = EnvironmentUtils.toStrings((Map)procEnvironment);
        for (int i = 0; i < envArgs.length; ++i) {
            Assert.assertNotNull((String)("Entry " + i + " should not be null"), (Object)envArgs[i]);
            Assert.assertTrue((String)("Entry " + i + " should not be empty"), (envArgs[i].length() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetProcEnvironmentCaseInsensitiveLookup() throws IOException {
        if (!OS.isFamilyWindows()) {
            return;
        }
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        for (Map.Entry entry : procEnvironment.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Assert.assertEquals((Object)value, procEnvironment.get(key.toLowerCase(Locale.ENGLISH)));
            Assert.assertEquals((Object)value, procEnvironment.get(key.toUpperCase(Locale.ENGLISH)));
        }
        EnvironmentUtils.addVariableToEnvironment((Map)procEnvironment, (String)"foo=bar");
        Assert.assertEquals((Object)"bar", procEnvironment.get("FOO"));
        Assert.assertEquals((Object)"bar", procEnvironment.get("Foo"));
        Assert.assertEquals((Object)"bar", procEnvironment.get("foo"));
    }

    @Test
    public void testCaseInsensitiveVariableLookup() throws Exception {
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        EnvironmentUtils.addVariableToEnvironment((Map)procEnvironment, (String)"foo=bAr");
        Assert.assertEquals((Object)"bAr", procEnvironment.get("foo"));
    }

    @Test
    public void testToStringWithNullKey() {
        HashMap<Object, String> env = new HashMap<Object, String>();
        env.put(null, "TheNullKey");
        String[] strings = EnvironmentUtils.toStrings(env);
        Assert.assertEquals((long)1L, (long)strings.length);
        Assert.assertEquals((Object)"=TheNullKey", (Object)strings[0]);
    }

    @Test
    public void testToStringWithNullValue() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("key", null);
        String[] strings = EnvironmentUtils.toStrings(env);
        Assert.assertEquals((long)1L, (long)strings.length);
        Assert.assertEquals((Object)"key=", (Object)strings[0]);
    }
}

