/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import junit.framework.AssertionFailedError;
import org.apache.commons.exec.OS;

public final class TestUtil {
    private TestUtil() {
    }

    public static File resolveScriptForOS(String script) {
        if (OS.isFamilyWindows()) {
            return new File(script + ".bat");
        }
        if (OS.isFamilyUnix()) {
            return new File(script + ".sh");
        }
        if (OS.isFamilyOpenVms()) {
            return new File(script + ".dcl");
        }
        throw new AssertionFailedError("Test not supported for this OS");
    }

    public static int[] getTestScriptCodesForOS() {
        if (OS.isFamilyWindows()) {
            return new int[]{0, 1};
        }
        if (OS.isFamilyUnix()) {
            return new int[]{0, 1};
        }
        if (OS.isFamilyOpenVms()) {
            return new int[]{1, 2};
        }
        throw new AssertionFailedError("Test not supported for this OS");
    }
}

