/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.exec.TestUtil;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class DefaultExecutorTest {
    private static final int WAITFOR_TIMEOUT = 15000;
    private final Executor exec = new DefaultExecutor();
    private final File testDir = new File("src/test/scripts");
    private final File foreverOutputFile = new File("./target/forever.txt");
    private ByteArrayOutputStream baos;
    private final File testScript = TestUtil.resolveScriptForOS(this.testDir + "/test");
    private final File errorTestScript = TestUtil.resolveScriptForOS(this.testDir + "/error");
    private final File foreverTestScript = TestUtil.resolveScriptForOS(this.testDir + "/forever");
    private final File nonExistingTestScript = TestUtil.resolveScriptForOS(this.testDir + "/grmpffffff");
    private final File redirectScript = TestUtil.resolveScriptForOS(this.testDir + "/redirect");
    private final File printArgsScript = TestUtil.resolveScriptForOS(this.testDir + "/printargs");
    private final File stdinSript = TestUtil.resolveScriptForOS(this.testDir + "/stdin");
    private final File environmentSript = TestUtil.resolveScriptForOS(this.testDir + "/environment");
    private static int SUCCESS_STATUS;
    private static int ERROR_STATUS;

    @BeforeClass
    public static void classSetUp() {
        int[] statuses = TestUtil.getTestScriptCodesForOS();
        SUCCESS_STATUS = statuses[0];
        ERROR_STATUS = statuses[1];
        System.setProperty("org.apache.commons.exec.lenient", "false");
        System.setProperty("org.apache.commons.exec.debug", "true");
    }

    @Before
    public void setUp() throws Exception {
        this.foreverOutputFile.getParentFile().mkdirs();
        if (this.foreverOutputFile.exists()) {
            this.foreverOutputFile.delete();
        }
        this.baos = new ByteArrayOutputStream();
        this.exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)this.baos, (OutputStream)this.baos));
    }

    @After
    public void tearDown() throws Exception {
        this.baos.close();
        this.foreverOutputFile.delete();
    }

    @Test
    public void testExecute() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        int exitValue = this.exec.execute(cl);
        Assert.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
        Assert.assertEquals((Object)new File("."), (Object)this.exec.getWorkingDirectory());
    }

    @Test
    public void testExecuteWithWorkingDirectory() throws Exception {
        File workingDir = new File("./target");
        CommandLine cl = new CommandLine(this.testScript);
        this.exec.setWorkingDirectory(workingDir);
        int exitValue = this.exec.execute(cl);
        Assert.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
        Assert.assertEquals((Object)this.exec.getWorkingDirectory(), (Object)workingDir);
    }

    @Test(expected=IOException.class)
    public void testExecuteWithInvalidWorkingDirectory() throws Exception {
        File workingDir = new File("/foo/bar");
        CommandLine cl = new CommandLine(this.testScript);
        this.exec.setWorkingDirectory(workingDir);
        this.exec.execute(cl);
    }

    @Test
    public void testExecuteWithError() throws Exception {
        CommandLine cl = new CommandLine(this.errorTestScript);
        try {
            this.exec.execute(cl);
            Assert.fail((String)"Must throw ExecuteException");
        }
        catch (ExecuteException e) {
            Assert.assertTrue((boolean)this.exec.isFailure(e.getExitValue()));
        }
    }

    @Test
    public void testExecuteWithArg() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        cl.addArgument("BAR");
        int exitValue = this.exec.execute(cl);
        Assert.assertEquals((Object)"FOO..BAR", (Object)this.baos.toString().trim());
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    public void testExecuteWithSingleEnvironmentVariable() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("TEST_ENV_VAR", "XYZ");
        CommandLine cl = new CommandLine(this.testScript);
        int exitValue = this.exec.execute(cl, env);
        Assert.assertEquals((Object)"FOO.XYZ.", (Object)this.baos.toString().trim());
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    public void testExecuteAsync() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor(2000L);
        Assert.assertTrue((boolean)resultHandler.hasResult());
        Assert.assertNull((Object)((Object)resultHandler.getException()));
        Assert.assertFalse((boolean)this.exec.isFailure(resultHandler.getExitValue()));
        Assert.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
    }

    @Test
    public void testExecuteAsyncWithError() throws Exception {
        CommandLine cl = new CommandLine(this.errorTestScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor(2000L);
        Assert.assertTrue((boolean)resultHandler.hasResult());
        Assert.assertTrue((boolean)this.exec.isFailure(resultHandler.getExitValue()));
        Assert.assertNotNull((Object)((Object)resultHandler.getException()));
        Assert.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
    }

    @Test
    public void testExecuteAsyncWithTimelyUserTermination() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Integer.MAX_VALUE);
        this.exec.setWatchdog(watchdog);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(2000L);
        Assert.assertTrue((String)"Watchdog should watch the process", (boolean)watchdog.isWatching());
        watchdog.destroyProcess();
        handler.waitFor(15000L);
        Assert.assertTrue((String)"Watchdog should have killed the process", (boolean)watchdog.killedProcess());
        Assert.assertFalse((String)"Watchdog is no longer watching the process", (boolean)watchdog.isWatching());
        Assert.assertTrue((String)"ResultHandler received a result", (boolean)handler.hasResult());
        Assert.assertNotNull((String)"ResultHandler received an exception as result", (Object)((Object)handler.getException()));
    }

    @Test
    public void testExecuteAsyncWithTooLateUserTermination() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(3000L);
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(6000L);
        watchdog.destroyProcess();
        handler.waitFor(15000L);
        Assert.assertTrue((String)"Watchdog should have killed the process already", (boolean)watchdog.killedProcess());
        Assert.assertFalse((String)"Watchdog is no longer watching the process", (boolean)watchdog.isWatching());
        Assert.assertTrue((String)"ResultHandler received a result", (boolean)handler.hasResult());
        Assert.assertNotNull((String)"ResultHandler received an exception as result", (Object)((Object)handler.getException()));
    }

    @Test
    public void testExecuteWatchdogSync() throws Exception {
        if (OS.isFamilyOpenVms()) {
            System.out.println("The test 'testExecuteWatchdogSync' currently hangs on the following OS : " + System.getProperty("os.name"));
            return;
        }
        long timeout = 10000L;
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File("."));
        ExecuteWatchdog watchdog = new ExecuteWatchdog(10000L);
        executor.setWatchdog(watchdog);
        try {
            executor.execute(cl);
        }
        catch (ExecuteException e) {
            Thread.sleep(10000L);
            int nrOfInvocations = this.getOccurrences(this.readFile(this.foreverOutputFile), '.');
            Assert.assertTrue((boolean)executor.getWatchdog().killedProcess());
            Assert.assertTrue((String)("killing the subprocess did not work : " + nrOfInvocations), (nrOfInvocations > 5 && nrOfInvocations <= 11 ? 1 : 0) != 0);
            return;
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
        Assert.assertTrue((String)"Killed process should be true", (boolean)executor.getWatchdog().killedProcess());
        Assert.fail((String)"Process did not create ExecuteException when killed");
    }

    @Test
    public void testExecuteWatchdogAsync() throws Exception {
        long timeout = 10000L;
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File("."));
        executor.setWatchdog(new ExecuteWatchdog(10000L));
        executor.execute(cl, (ExecuteResultHandler)handler);
        handler.waitFor(15000L);
        Assert.assertTrue((String)"Killed process should be true", (boolean)executor.getWatchdog().killedProcess());
        Assert.assertTrue((String)"ResultHandler received a result", (boolean)handler.hasResult());
        Assert.assertNotNull((String)"ResultHandler received an exception as result", (Object)((Object)handler.getException()));
        int nrOfInvocations = this.getOccurrences(this.readFile(this.foreverOutputFile), '.');
        Assert.assertTrue((String)("Killing the process did not work : " + nrOfInvocations), (nrOfInvocations > 5 && nrOfInvocations <= 11 ? 1 : 0) != 0);
    }

    @Test
    public void testExecuteWatchdogVeryLongTimeout() throws Exception {
        long timeout = Long.MAX_VALUE;
        CommandLine cl = new CommandLine(this.testScript);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File("."));
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Long.MAX_VALUE);
        executor.setWatchdog(watchdog);
        try {
            executor.execute(cl);
        }
        catch (ExecuteException e) {
            Assert.assertFalse((String)"Process should exit normally, not be killed by watchdog", (boolean)watchdog.killedProcess());
            throw e;
        }
    }

    @Test(expected=IOException.class)
    public void testExecuteNonExistingApplication() throws Exception {
        CommandLine cl = new CommandLine(this.nonExistingTestScript);
        DefaultExecutor executor = new DefaultExecutor();
        executor.execute(cl);
    }

    @Test
    public void testExecuteAsyncWithNonExistingApplication() throws Exception {
        CommandLine cl = new CommandLine(this.nonExistingTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(2000L);
        Assert.assertNotNull((Object)((Object)handler.getException()));
        Assert.assertTrue((boolean)this.exec.isFailure(handler.getExitValue()));
    }

    @Test
    public void testExecuteWithCustomExitValue1() throws Exception {
        this.exec.setExitValue(ERROR_STATUS);
        CommandLine cl = new CommandLine(this.errorTestScript);
        this.exec.execute(cl);
    }

    @Test
    public void testExecuteWithCustomExitValue2() throws Exception {
        CommandLine cl = new CommandLine(this.errorTestScript);
        this.exec.setExitValue(SUCCESS_STATUS);
        try {
            this.exec.execute(cl);
            Assert.fail((String)"Must throw ExecuteException");
        }
        catch (ExecuteException e) {
            Assert.assertTrue((boolean)this.exec.isFailure(e.getExitValue()));
        }
    }

    @Test
    public void testExecuteWithProcessDestroyer() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        ShutdownHookProcessDestroyer processDestroyer = new ShutdownHookProcessDestroyer();
        this.exec.setProcessDestroyer((ProcessDestroyer)processDestroyer);
        Assert.assertTrue((processDestroyer.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((!processDestroyer.isAddedAsShutdownHook() ? 1 : 0) != 0);
        int exitValue = this.exec.execute(cl);
        Assert.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
        Assert.assertTrue((processDestroyer.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((!processDestroyer.isAddedAsShutdownHook() ? 1 : 0) != 0);
    }

    @Test
    public void testExecuteAsyncWithProcessDestroyer() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        ShutdownHookProcessDestroyer processDestroyer = new ShutdownHookProcessDestroyer();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Integer.MAX_VALUE);
        Assert.assertTrue((this.exec.getProcessDestroyer() == null ? 1 : 0) != 0);
        Assert.assertTrue((processDestroyer.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((!processDestroyer.isAddedAsShutdownHook() ? 1 : 0) != 0);
        this.exec.setWatchdog(watchdog);
        this.exec.setProcessDestroyer((ProcessDestroyer)processDestroyer);
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(2000L);
        Assert.assertNotNull((String)"Process destroyer should exist", (Object)this.exec.getProcessDestroyer());
        Assert.assertEquals((String)"Process destroyer size should be 1", (long)1L, (long)processDestroyer.size());
        Assert.assertTrue((String)"Process destroyer should exist as shutdown hook", (boolean)processDestroyer.isAddedAsShutdownHook());
        watchdog.destroyProcess();
        Assert.assertTrue((boolean)watchdog.killedProcess());
        handler.waitFor(15000L);
        Assert.assertTrue((String)"ResultHandler received a result", (boolean)handler.hasResult());
        Assert.assertNotNull((Object)((Object)handler.getException()));
        Assert.assertEquals((String)"Processor Destroyer size should be 0", (long)0L, (long)processDestroyer.size());
        Assert.assertFalse((String)"Process destroyer should not exist as shutdown hook", (boolean)processDestroyer.isAddedAsShutdownHook());
    }

    @Test
    public void testExecuteWithFancyArg() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        cl.addArgument("test $;`(0)[1]{2}");
        int exitValue = this.exec.execute(cl);
        Assert.assertTrue((this.baos.toString().trim().indexOf("test $;`(0)[1]{2}") > 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    public void testExecuteWithRedirectedStreams() throws Exception {
        if (!OS.isFamilyUnix()) {
            if (OS.isFamilyWindows()) {
                System.err.println("The code samples to do that in windows look like a joke ... :-( .., no way I'm doing that");
                System.err.println("The test 'testExecuteWithRedirectedStreams' does not support the following OS : " + System.getProperty("os.name"));
                return;
            }
            System.err.println("The test 'testExecuteWithRedirectedStreams' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        FileInputStream fis = new FileInputStream("./NOTICE.txt");
        CommandLine cl = new CommandLine(this.redirectScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)this.baos, (OutputStream)this.baos, (InputStream)fis);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File("."));
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        fis.close();
        String result = this.baos.toString().trim();
        Assert.assertTrue((String)result, (result.indexOf("Finished reading from stdin") > 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)("exitValue=" + exitValue), (boolean)this.exec.isFailure(exitValue));
    }

    @Test
    public void testExecuteWithStdOutErr() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    public void testExecuteWithNullOutErr() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(null, null);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteWithRedirectOutErr() throws Exception {
        File outfile = File.createTempFile("EXEC", ".test");
        outfile.deleteOnExit();
        CommandLine cl = new CommandLine(this.testScript);
        FileOutputStream outAndErr = new FileOutputStream(outfile);
        try {
            PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)outAndErr);
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
            int exitValue = executor.execute(cl);
            Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
            Assert.assertTrue((boolean)outfile.exists());
        }
        finally {
            outAndErr.close();
        }
    }

    @Test
    public void testExecuteWithComplexArguments() throws Exception {
        CommandLine cl = new CommandLine(this.printArgsScript);
        cl.addArgument("gdal_translate");
        cl.addArgument("HDF5:\"/home/kk/grass/data/4404.he5\"://HDFEOS/GRIDS/OMI_Column_Amount_O3/Data_Fields/ColumnAmountO3/home/kk/4.tif", false);
        DefaultExecutor executor = new DefaultExecutor();
        int exitValue = executor.execute(cl);
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    public void testStdInHandling() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream("Foo".getBytes());
        CommandLine cl = new CommandLine(this.stdinSript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)this.baos, (OutputStream)System.err, (InputStream)bais);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        executor.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor(15000L);
        Assert.assertTrue((String)"ResultHandler received a result", (boolean)resultHandler.hasResult());
        Assert.assertFalse((boolean)this.exec.isFailure(resultHandler.getExitValue()));
        String result = this.baos.toString();
        Assert.assertTrue((String)("Result '" + result + "' should contain 'Hello Foo!'"), (result.indexOf("Hello Foo!") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEnvironmentVariables() throws Exception {
        this.exec.execute(new CommandLine(this.environmentSript));
        String environment = this.baos.toString().trim();
        Assert.assertTrue((String)"Found no environment variables", (environment.length() > 0 ? 1 : 0) != 0);
        Assert.assertFalse((environment.indexOf("NEW_VAR") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAddEnvironmentVariables() throws Exception {
        HashMap<String, String> myEnvVars = new HashMap<String, String>();
        myEnvVars.putAll(EnvironmentUtils.getProcEnvironment());
        myEnvVars.put("NEW_VAR", "NEW_VAL");
        this.exec.execute(new CommandLine(this.environmentSript), myEnvVars);
        String environment = this.baos.toString().trim();
        Assert.assertTrue((String)("Expecting NEW_VAR in " + environment), (environment.indexOf("NEW_VAR") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expecting NEW_VAL in " + environment), (environment.indexOf("NEW_VAL") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAddEnvironmentVariableEmbeddedQuote() throws Exception {
        HashMap<String, String> myEnvVars = new HashMap<String, String>();
        myEnvVars.putAll(EnvironmentUtils.getProcEnvironment());
        String name = "NEW_VAR";
        String value = "NEW_\"_VAL";
        myEnvVars.put("NEW_VAR", "NEW_\"_VAL");
        this.exec.execute(new CommandLine(this.environmentSript), myEnvVars);
        String environment = this.baos.toString().trim();
        Assert.assertTrue((String)("Expecting NEW_VAR in " + environment), (environment.indexOf("NEW_VAR") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expecting NEW_\"_VAL in " + environment), (environment.indexOf("NEW_\"_VAL") >= 0 ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void _testExecuteStability() throws Exception {
        HashMap<String, String> env;
        int i;
        for (i = 0; i < 100; ++i) {
            env = new HashMap<String, String>();
            env.put("TEST_ENV_VAR", Integer.toString(i));
            CommandLine cl = new CommandLine(this.testScript);
            int exitValue = this.exec.execute(cl, env);
            Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
            Assert.assertEquals((Object)("FOO." + i + "."), (Object)this.baos.toString().trim());
            this.baos.reset();
        }
        for (i = 0; i < 100; ++i) {
            env = new HashMap();
            env.put("TEST_ENV_VAR", Integer.toString(i));
            DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
            CommandLine cl = new CommandLine(this.foreverTestScript);
            ExecuteWatchdog watchdog = new ExecuteWatchdog(500L);
            this.exec.setWatchdog(watchdog);
            this.exec.execute(cl, env, (ExecuteResultHandler)resultHandler);
            resultHandler.waitFor(15000L);
            Assert.assertTrue((String)"ResultHandler received a result", (boolean)resultHandler.hasResult());
            Assert.assertNotNull((Object)((Object)resultHandler.getException()));
            this.baos.reset();
        }
    }

    private String readFile(File file) throws Exception {
        String text;
        StringBuilder contents = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((text = reader.readLine()) != null) {
            contents.append(text).append(System.getProperty("line.separator"));
        }
        reader.close();
        return contents.toString();
    }

    private int getOccurrences(String data, char c) {
        int result = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != c) continue;
            ++result;
        }
        return result;
    }
}

