/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.AbstractEmailTest;
import org.apache.commons.mail.EmailConstants;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.mocks.MockSimpleEmail;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SimpleEmailTest
extends AbstractEmailTest {
    private MockSimpleEmail email;

    @BeforeEach
    public void setUpSimpleEmailTest() {
        this.email = new MockSimpleEmail();
    }

    @Test
    @Disabled
    public void testDefaultMimeCharset() throws EmailException, IOException {
        System.setProperty("mail.mime.charset", StandardCharsets.UTF_8.name());
        this.getMailServer();
        this.email = new MockSimpleEmail();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "Test Msg Subject";
        String strMessage = "Test Msg Body \u00e4";
        this.email.setSubject("Test Msg Subject");
        this.email.setMsg("Test Msg Body \u00e4");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "Test Msg Subject", this.email.getContentAsString().substring(0, 13), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        String message = this.getMessageAsString(0);
        Assertions.assertTrue((boolean)EmailUtils.toLower((String)message).contains("content-type: text/plain; charset=utf-8"));
        System.clearProperty("mail.mime.charset");
    }

    @Test
    public void testGetSetMsg() throws EmailException {
        for (String validChar : this.testCharsValid) {
            this.email.setMsg(validChar);
            Assertions.assertEquals((Object)validChar, (Object)this.email.getContentAsString());
        }
        for (String invalidChar : this.testCharsNotValid) {
            Assertions.assertThrows(EmailException.class, () -> this.email.setMsg(invalidChar));
        }
    }

    @Test
    public void testSend() throws EmailException, IOException {
        this.getMailServer();
        this.email = new MockSimpleEmail();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "Test Msg Subject";
        String strMessage = "Test Msg Body";
        this.email.setCharset(EmailConstants.ISO_8859_1);
        this.email.setSubject("Test Msg Subject");
        this.email.setMsg("Test Msg Body");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "Test Msg Subject", this.email.getContentAsString(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }
}

