/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.settings.EmailConfiguration;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.powermock.api.easymock.PowerMock;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public abstract class AbstractEmailTest {
    public static final int BODY_END_PAD = 3;
    public static final int BODY_START_PAD = 2;
    private static final String LINE_SEPARATOR = "\r\n";
    private static int mailServerPort = 2500;
    protected Wiser fakeMailServer;
    protected String strTestMailServer = "localhost";
    protected String strTestMailFrom = "test_from@apache.org";
    protected String strTestMailTo = "test_to@apache.org";
    protected String strTestUser = "user";
    protected String strTestPasswd = "password";
    protected String strTestURL = EmailConfiguration.TEST_URL;
    protected String[] testCharsValid = new String[]{" ", "a", "A", "\uc5ec", "0123456789", "012345678901234567890"};
    protected String[] endOfLineCombinations = new String[]{"\n", "\r", "\r\n", "\n\r"};
    protected String[] testCharsNotValid = new String[]{"", null};
    private File emailOutputDir;
    private static int fileNameCounter;

    @Before
    public void setUpAbstractEmailTest() {
        this.emailOutputDir = new File("target/test-emails");
        if (!this.emailOutputDir.exists()) {
            this.emailOutputDir.mkdirs();
        }
    }

    @After
    public void tearDownEmailTest() {
        if (this.fakeMailServer != null && !this.isMailServerStopped(this.fakeMailServer)) {
            this.fakeMailServer.stop();
            Assert.assertTrue((String)"Mail server didn't stop", (boolean)this.isMailServerStopped(this.fakeMailServer));
        }
        this.fakeMailServer = null;
    }

    protected int getMailServerPort() {
        return mailServerPort;
    }

    protected void saveEmailToFile(WiserMessage email) throws IOException, MessagingException {
        int currCounter = fileNameCounter++ % 10;
        String emailFileName = "email" + new Date().getTime() + "-" + currCounter + ".eml";
        File emailFile = new File(this.emailOutputDir, emailFileName);
        EmailUtils.writeMimeMessage((File)emailFile, (MimeMessage)email.getMimeMessage());
    }

    public String getMessageAsString(int intMsgNo) {
        List receivedMessages = this.fakeMailServer.getMessages();
        Assert.assertTrue((String)"mail server didn't get enough messages", (receivedMessages.size() >= intMsgNo ? 1 : 0) != 0);
        WiserMessage emailMessage = (WiserMessage)receivedMessages.get(intMsgNo);
        if (emailMessage != null) {
            try {
                return this.serializeEmailMessage(emailMessage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Assert.fail((String)"Message not found");
        return "";
    }

    public void getMailServer() {
        if (this.fakeMailServer == null || this.isMailServerStopped(this.fakeMailServer)) {
            ++mailServerPort;
            this.fakeMailServer = new Wiser();
            this.fakeMailServer.setPort(this.getMailServerPort());
            this.fakeMailServer.start();
            Assert.assertFalse((String)"fake mail server didn't start", (boolean)this.isMailServerStopped(this.fakeMailServer));
            Date dtStartWait = new Date();
            while (this.isMailServerStopped(this.fakeMailServer) && (this.fakeMailServer == null || this.isMailServerStopped(this.fakeMailServer))) {
                if (dtStartWait.getTime() + 500L > new Date().getTime()) continue;
                Assert.fail((String)"Mail server failed to start");
            }
        }
    }

    protected WiserMessage validateSend(Wiser mailServer, String strSubject, InternetAddress fromAdd, List<InternetAddress> toAdd, List<InternetAddress> ccAdd, List<InternetAddress> bccAdd, boolean boolSaveToFile) throws IOException {
        Assert.assertTrue((String)"mail server doesn't contain expected message", (mailServer.getMessages().size() == 1 ? 1 : 0) != 0);
        WiserMessage emailMessage = (WiserMessage)mailServer.getMessages().get(0);
        if (boolSaveToFile) {
            try {
                this.saveEmailToFile(emailMessage);
            }
            catch (MessagingException me) {
                IllegalStateException ise = new IllegalStateException("caught MessagingException during saving the email");
                ise.initCause(me);
                throw ise;
            }
        }
        try {
            MimeMessage mimeMessage = emailMessage.getMimeMessage();
            Assert.assertEquals((String)"got wrong subject from mail", (Object)strSubject, (Object)mimeMessage.getHeader("Subject", null));
            Assert.assertEquals((String)"got wrong From: address from mail", (Object)fromAdd.toString(), (Object)mimeMessage.getHeader("From", null));
            Assert.assertTrue((String)"got wrong To: address from mail", (boolean)toAdd.toString().contains(mimeMessage.getHeader("To", null)));
            if (ccAdd.size() > 0) {
                Assert.assertTrue((String)"got wrong Cc: address from mail", (boolean)ccAdd.toString().contains(mimeMessage.getHeader("Cc", null)));
            }
            if (bccAdd.size() > 0) {
                Assert.assertTrue((String)"got wrong Bcc: address from mail", (boolean)bccAdd.toString().contains(mimeMessage.getHeader("Bcc", null)));
            }
        }
        catch (MessagingException me) {
            IllegalStateException ise = new IllegalStateException("caught MessagingException in validateSend()");
            ise.initCause(me);
            throw ise;
        }
        return emailMessage;
    }

    protected void validateSend(Wiser mailServer, String strSubject, Multipart content, InternetAddress fromAdd, List<InternetAddress> toAdd, List<InternetAddress> ccAdd, List<InternetAddress> bccAdd, boolean boolSaveToFile) throws IOException {
        WiserMessage emailMessage = this.validateSend(mailServer, strSubject, fromAdd, toAdd, ccAdd, bccAdd, boolSaveToFile);
        String strSentContent = content.getContentType();
        String emailMessageBody = this.getMessageBody(emailMessage);
        String strMessageBody = emailMessageBody.substring(2, emailMessageBody.length() - 3);
        Assert.assertTrue((String)"didn't find expected content type in message body", (boolean)strMessageBody.contains(strSentContent));
    }

    protected void validateSend(Wiser mailServer, String strSubject, String strMessage, InternetAddress fromAdd, List<InternetAddress> toAdd, List<InternetAddress> ccAdd, List<InternetAddress> bccAdd, boolean boolSaveToFile) throws IOException {
        WiserMessage emailMessage = this.validateSend(mailServer, strSubject, fromAdd, toAdd, ccAdd, bccAdd, true);
        Assert.assertThat((String)"didn't find expected message content in message body", (Object)this.getMessageBody(emailMessage), (Matcher)CoreMatchers.containsString((String)strMessage));
    }

    private String serializeEmailMessage(WiserMessage wiserMessage) throws MessagingException, IOException {
        if (wiserMessage == null) {
            return "";
        }
        StringBuffer serializedEmail = new StringBuffer();
        MimeMessage message = wiserMessage.getMimeMessage();
        Enumeration headers = message.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            serializedEmail.append(header.getName());
            serializedEmail.append(": ");
            serializedEmail.append(header.getValue());
            serializedEmail.append(LINE_SEPARATOR);
        }
        byte[] messageBody = this.getMessageBodyBytes(message);
        serializedEmail.append(LINE_SEPARATOR);
        serializedEmail.append(messageBody);
        serializedEmail.append(LINE_SEPARATOR);
        return serializedEmail.toString();
    }

    private String getMessageBody(WiserMessage wiserMessage) throws IOException {
        if (wiserMessage == null) {
            return "";
        }
        byte[] messageBody = null;
        try {
            MimeMessage message = wiserMessage.getMimeMessage();
            messageBody = this.getMessageBodyBytes(message);
        }
        catch (MessagingException me) {
            IllegalStateException ise = new IllegalStateException("couldn't process MimeMessage from WiserMessage in getMessageBody()");
            ise.initCause(me);
            throw ise;
        }
        return messageBody != null ? new String(messageBody).intern() : "";
    }

    private byte[] getMessageBodyBytes(MimeMessage mimeMessage) throws IOException, MessagingException {
        DataHandler dataHandler = mimeMessage.getDataHandler();
        ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
        BufferedOutputStream buffOs = new BufferedOutputStream(byteArrayOutStream);
        dataHandler.writeTo((OutputStream)buffOs);
        buffOs.flush();
        return byteArrayOutStream.toByteArray();
    }

    protected boolean isMailServerStopped(Wiser fakeMailServer) {
        return !fakeMailServer.getServer().isRunning();
    }

    protected URL createInvalidURL() throws Exception {
        URL url = (URL)PowerMock.createMock(URL.class);
        EasyMock.expect((Object)url.openStream()).andThrow((Throwable)new IOException());
        PowerMock.replay((Object[])new Object[]{url});
        return url;
    }
}

