/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.util;

import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.util.MimeMessageParser;
import org.apache.commons.mail.util.MimeMessageUtils;
import org.junit.Assert;
import org.junit.Test;

public class MimeMessageParserTest {
    @Test
    public void testParseSimpleEmail() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/simple.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Test HTML Send #1 Subject (wo charset)", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assert.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    @Test
    public void testParseSimpleReplyEmail() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/simple-reply.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Re: java.lang.NoClassDefFoundError: org/bouncycastle/asn1/pkcs/PrivateKeyInfo", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertFalse((boolean)mimeMessageParser.isMultipart());
        Assert.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"coheigea@apache.org", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"dev@ws.apache.org", (Object)mimeMessageParser.getReplyTo());
        Assert.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    @Test
    public void testParseHtmlEmailWithAttachments() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/html-attachment.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Test", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getReplyTo());
        Assert.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assert.assertTrue((attachmentList.size() == 2 ? 1 : 0) != 0);
        DataSource dataSource = mimeMessageParser.findAttachmentByName("Wasserlilien.jpg");
        Assert.assertNotNull((Object)dataSource);
        Assert.assertEquals((Object)"image/jpeg", (Object)dataSource.getContentType());
        dataSource = mimeMessageParser.findAttachmentByName("it20one.pdf");
        Assert.assertNotNull((Object)dataSource);
        Assert.assertEquals((Object)"application/pdf", (Object)dataSource.getContentType());
    }

    @Test
    public void testParseHtmlEmailWithAttachmentAndEncodedFilename() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/html-attachment-encoded-filename.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Test HTML Send #1 Subject (w charset)", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assert.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assert.assertTrue((attachmentList.size() == 1 ? 1 : 0) != 0);
        DataSource dataSource = (DataSource)mimeMessageParser.getAttachmentList().get(0);
        Assert.assertNotNull((Object)dataSource);
        Assert.assertEquals((Object)"text/plain", (Object)dataSource.getContentType());
        Assert.assertEquals((Object)"Test Attachment - a>\u00e4, o>\u00f6, u>\u00fc, au>\u00e4u", (Object)dataSource.getName());
    }

    @Test
    public void testParseMultipartReport() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/multipart-report.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Gelesen: ", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getReplyTo());
        Assert.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assert.assertTrue((attachmentList.size() == 1 ? 1 : 0) != 0);
        DataSource dataSource = (DataSource)attachmentList.get(0);
        Assert.assertNotNull((Object)dataSource);
        Assert.assertNull((Object)dataSource.getName());
        Assert.assertEquals((Object)"message/disposition-notification", (Object)dataSource.getContentType());
    }

    @Test
    public void testAttachmentOnly() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/attachment-only.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Kunde 100029   Auftrag   3600", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertFalse((boolean)mimeMessageParser.isMultipart());
        Assert.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getReplyTo());
        Assert.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assert.assertTrue((attachmentList.size() == 1 ? 1 : 0) != 0);
        DataSource dataSource = mimeMessageParser.findAttachmentByName("Kunde 100029   Auftrag   3600.pdf");
        Assert.assertNotNull((Object)dataSource);
        Assert.assertEquals((Object)"application/pdf", (Object)dataSource.getContentType());
    }

    @Test
    public void testParseNoHeaderSeperatorWithOutOfMemory() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/outofmemory-no-header-seperation.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"A corrupt Attachment", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertEquals((long)mimeMessageParser.getTo().size(), (long)1L);
        Assert.assertEquals((long)mimeMessageParser.getCc().size(), (long)0L);
        Assert.assertEquals((long)mimeMessageParser.getBcc().size(), (long)0L);
    }

    @Test
    public void testMultipartTextAttachment() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/multipart-text-attachment.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"test", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assert.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assert.assertTrue((attachmentList.size() == 1 ? 1 : 0) != 0);
        DataSource dataSource = mimeMessageParser.findAttachmentByName("test.txt");
        Assert.assertNotNull((Object)dataSource);
        Assert.assertEquals((Object)"text/plain", (Object)dataSource.getContentType());
    }

    @Test
    public void testMultipartTextAttachmentOnly() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/multipart-text-attachment-only.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"test", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assert.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assert.assertTrue((attachmentList.size() == 1 ? 1 : 0) != 0);
        DataSource dataSource = mimeMessageParser.findAttachmentByName("test.txt");
        Assert.assertNotNull((Object)dataSource);
        Assert.assertEquals((Object)"text/plain", (Object)dataSource.getContentType());
    }

    @Test
    public void testParseHtmlEmailWithHtmlAttachment() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/html-attachment-content-disposition.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"test", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assert.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assert.assertTrue((attachmentList.size() == 1 ? 1 : 0) != 0);
        DataSource dataSource = mimeMessageParser.findAttachmentByName("test.html");
        Assert.assertNotNull((Object)dataSource);
        Assert.assertEquals((Object)"text/html", (Object)dataSource.getContentType());
    }

    @Test
    public void testParseCreatedHtmlEmailWithNoContent() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        HtmlEmail email = new HtmlEmail();
        email.setMailSession(session);
        email.setFrom("test_from@apache.org");
        email.setSubject("Test Subject");
        email.addTo("test_to@apache.org");
        email.buildMimeMessage();
        MimeMessage msg = email.getMimeMessage();
        MimeMessageParser mimeMessageParser = new MimeMessageParser(msg);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Test Subject", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assert.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    @Test
    public void testParseCreatedHtmlEmailWithTextContent() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        HtmlEmail email = new HtmlEmail();
        email.setMailSession(session);
        email.setFrom("test_from@apache.org");
        email.setSubject("Test Subject");
        email.addTo("test_to@apache.org");
        email.setTextMsg("My test message");
        email.buildMimeMessage();
        MimeMessage msg = email.getMimeMessage();
        MimeMessageParser mimeMessageParser = new MimeMessageParser(msg);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Test Subject", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assert.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    @Test
    public void testParseCreatedHtmlEmailWithMixedContent() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        HtmlEmail email = new HtmlEmail();
        email.setMailSession(session);
        email.setFrom("test_from@apache.org");
        email.setSubject("Test Subject");
        email.addTo("test_to@apache.org");
        email.setTextMsg("My test message");
        email.setHtmlMsg("<p>My HTML message</p>");
        email.buildMimeMessage();
        MimeMessage msg = email.getMimeMessage();
        MimeMessageParser mimeMessageParser = new MimeMessageParser(msg);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Test Subject", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assert.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assert.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    @Test
    public void testParseInlineCID() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/html-attachment.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assert.assertEquals((Object)"Test", (Object)mimeMessageParser.getSubject());
        Assert.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assert.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assert.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assert.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assert.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getFrom());
        Assert.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getReplyTo());
        Assert.assertTrue((boolean)mimeMessageParser.hasAttachments());
        Assert.assertTrue((boolean)mimeMessageParser.getContentIds().contains("part1.01080006.06060206@it20one.at"));
        Assert.assertFalse((boolean)mimeMessageParser.getContentIds().contains("part2"));
        DataSource ds = mimeMessageParser.findAttachmentByCid("part1.01080006.06060206@it20one.at");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((Object)ds, mimeMessageParser.getAttachmentList().get(0));
    }
}

