/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.util;

import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.util.IDNEmailAddressConverter;
import org.junit.Assert;
import org.junit.Test;

public class IDNEmailAddressConverterTest {
    private static final String AUSTRIAN_IDN_EMAIL_ADDRESS = "noreply@d\u00f6m\u00e4in.example";
    private static final String CZECH_IDN_EMAIL_ADDRESS = "noreply@\u010desk\u00e1republika.icom.museum";
    private static final String RUSSIAN_IDN_EMAIL_ADDRESS = "noreply@\u0440\u043e\u0441\u0441\u0438\u044f.\u0438\u043a\u043e\u043c.museum";
    private static final String GERMAN_IDN_EMAIL_NAME = "noreply@d\u00f6m\u00e4in.example";
    private static final String[] IDN_EMAIL_ADDRESSES = new String[]{"noreply@d\u00f6m\u00e4in.example", "noreply@\u010desk\u00e1republika.icom.museum", "noreply@\u0440\u043e\u0441\u0441\u0438\u044f.\u0438\u043a\u043e\u043c.museum"};
    private final IDNEmailAddressConverter idnEmailConverter = new IDNEmailAddressConverter();

    @Test
    public void testConvertInvalidEmailAddressToAscii() {
        Assert.assertEquals(null, (Object)this.idnEmailConverter.toASCII(null));
        Assert.assertEquals((Object)"", (Object)this.idnEmailConverter.toASCII(""));
        Assert.assertEquals((Object)"@", (Object)this.idnEmailConverter.toASCII("@"));
        Assert.assertEquals((Object)"@@", (Object)this.idnEmailConverter.toASCII("@@"));
        Assert.assertEquals((Object)"foo", (Object)this.idnEmailConverter.toASCII("foo"));
        Assert.assertEquals((Object)"foo@", (Object)this.idnEmailConverter.toASCII("foo@"));
        Assert.assertEquals((Object)"@badhost.com", (Object)this.idnEmailConverter.toASCII("@badhost.com"));
    }

    @Test
    public void testIDNEmailAddressToAsciiConversion() {
        Assert.assertEquals((Object)"noreply@xn--dmin-moa0i.example", (Object)this.idnEmailConverter.toASCII("noreply@d\u00f6m\u00e4in.example"));
        Assert.assertEquals((Object)"noreply@xn--h1alffa9f.xn--h1aegh.museum", (Object)this.idnEmailConverter.toASCII(RUSSIAN_IDN_EMAIL_ADDRESS));
    }

    @Test
    public void testMultipleIDNEmailAddressToAsciiConversion() {
        Assert.assertEquals((Object)"noreply@xn--dmin-moa0i.example", (Object)this.idnEmailConverter.toASCII(this.idnEmailConverter.toASCII("noreply@d\u00f6m\u00e4in.example")));
    }

    @Test
    public void testNonIDNEmailAddressToAsciiConversion() {
        Assert.assertEquals((Object)"me@home.com", (Object)this.idnEmailConverter.toASCII("me@home.com"));
    }

    @Test
    public void testInternetAddressToAsciiConversion() throws Exception {
        InternetAddress address = new InternetAddress(this.idnEmailConverter.toASCII("noreply@d\u00f6m\u00e4in.example"));
        Assert.assertEquals((Object)"noreply@d\u00f6m\u00e4in.example", (Object)this.idnEmailConverter.toUnicode(address));
        InternetAddress addressWithPersonalName = new InternetAddress(this.idnEmailConverter.toASCII("noreply@d\u00f6m\u00e4in.example"), "noreply@d\u00f6m\u00e4in.example");
        Assert.assertEquals((Object)"noreply@d\u00f6m\u00e4in.example", (Object)this.idnEmailConverter.toUnicode(addressWithPersonalName));
    }

    @Test
    public void testRoundTripConversionOfIDNEmailAddress() {
        for (String email : IDN_EMAIL_ADDRESSES) {
            Assert.assertEquals((Object)email, (Object)this.idnEmailConverter.toUnicode(this.idnEmailConverter.toASCII(email)));
        }
    }
}

