/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.IOException;
import org.apache.commons.mail.resolver.AbstractDataSourceResolverTest;
import org.apache.commons.mail.resolver.DataSourceClassPathResolver;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceClassPathResolverTest
extends AbstractDataSourceResolverTest {
    @Test
    public void testResolvingClassPathLenient() throws Exception {
        DataSourceClassPathResolver dataSourceResolver = new DataSourceClassPathResolver("/", true);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("./images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("/images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertNull((Object)dataSourceResolver.resolve("/asf_logo_wide.gif"));
        dataSourceResolver = new DataSourceClassPathResolver("/images", true);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("./asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertNull((Object)dataSourceResolver.resolve("./images/asf_logo_wide.gif"));
    }

    @Test(expected=IOException.class)
    public void testResolvingClassPathNonLenient() throws Exception {
        DataSourceClassPathResolver dataSourceResolver = new DataSourceClassPathResolver("/", false);
        Assert.assertNotNull((Object)dataSourceResolver.resolve("images/asf_logo_wide.gif"));
        dataSourceResolver.resolve("asf_logo_wide.gif");
    }
}

