/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers.properties;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.dbutils.PropertyHandler;

public class DatePropertyHandler
implements PropertyHandler {
    private static final String JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String JAVA_SQL_TIME = "java.sql.Time";
    private static final String JAVA_SQL_DATE = "java.sql.Date";

    @Override
    public Object apply(Class<?> parameter, Object value) {
        String targetType = parameter.getName();
        Date dateValue = (Date)value;
        long time = dateValue.getTime();
        if (JAVA_SQL_DATE.equals(targetType)) {
            value = new java.sql.Date(time);
        } else if (JAVA_SQL_TIME.equals(targetType)) {
            value = new Time(time);
        } else if (JAVA_SQL_TIMESTAMP.equals(targetType)) {
            value = new Timestamp(time);
        }
        return value;
    }

    @Override
    public boolean match(Class<?> parameter, Object value) {
        if (value instanceof Date) {
            String targetType = parameter.getName();
            if (JAVA_SQL_DATE.equals(targetType)) {
                return true;
            }
            if (JAVA_SQL_TIME.equals(targetType)) {
                return true;
            }
            if (JAVA_SQL_TIMESTAMP.equals(targetType) && !Timestamp.class.isInstance(value)) {
                return true;
            }
        }
        return false;
    }
}

