/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.reloading.FileHandlerReloadingDetector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestFileHandlerReloadingDetector {
    private static final long LAST_MODIFIED = 20121008215654L;

    @Test
    public void testDefaultRefreshDelay() {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        Assertions.assertEquals((long)5000L, (long)detector.getRefreshDelay());
    }

    @Test
    public void testGetFileJarURL() throws Exception {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        URL url = new URL("jar:" + new File("conf/resources.jar").getAbsoluteFile().toURI().toURL() + "!/test-jar.xml");
        detector.getFileHandler().setURL(url);
        File file = detector.getFile();
        Assertions.assertNotNull((Object)file);
        Assertions.assertEquals((Object)"resources.jar", (Object)file.getName());
    }

    @Test
    public void testInitWithFileHandler() {
        FileHandler handler = new FileHandler();
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector(handler);
        Assertions.assertSame((Object)handler, (Object)detector.getFileHandler());
    }

    @Test
    public void testIsReloadingRequiredFileDoesNotExist() {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        detector.getFileHandler().setFile(new File("NonExistingFile.txt"));
        detector.reloadingPerformed();
        Assertions.assertFalse((boolean)detector.isReloadingRequired());
    }

    @Test
    public void testIsReloadingRequiredNoLocation() {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        Assertions.assertFalse((boolean)detector.isReloadingRequired());
    }

    @Test
    public void testIsReloadingRequiredTrue() throws Exception {
        File f = (File)Mockito.mock(File.class);
        Mockito.when((Object)f.exists()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)f.lastModified()).thenReturn((Object)20121008215654L, (Object[])new Long[]{20121008215655L});
        FileHandlerReloadingDetectorTestImpl detector = new FileHandlerReloadingDetectorTestImpl(f);
        Assertions.assertFalse((boolean)detector.isReloadingRequired());
        Assertions.assertTrue((boolean)detector.isReloadingRequired());
    }

    @Test
    public void testLocationAfterInit() {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        Assertions.assertFalse((boolean)detector.getFileHandler().isLocationDefined());
    }

    @Test
    public void testRefreshDelay() throws Exception {
        File f = (File)Mockito.mock(File.class);
        Mockito.when((Object)f.exists()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)f.lastModified()).thenReturn((Object)20121008215654L, (Object[])new Long[]{20121008215654L});
        FileHandlerReloadingDetectorTestImpl detector = new FileHandlerReloadingDetectorTestImpl(f, 3600000L);
        detector.reloadingPerformed();
        Assertions.assertFalse((boolean)detector.isReloadingRequired());
        Assertions.assertFalse((boolean)detector.isReloadingRequired());
    }

    @Test
    public void testRefreshIsReloadingRequiredTrue() throws Exception {
        File f = (File)Mockito.mock(File.class);
        Mockito.when((Object)f.exists()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)f.lastModified()).thenReturn((Object)20121008215654L, (Object[])new Long[]{20121008215655L});
        FileHandlerReloadingDetectorTestImpl detector = new FileHandlerReloadingDetectorTestImpl(f);
        detector.refresh();
        Assertions.assertTrue((boolean)detector.isReloadingRequired());
    }

    @Test
    public void testRefreshReloadingAndReset() throws Exception {
        File f = (File)Mockito.mock(File.class);
        Mockito.when((Object)f.exists()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)f.lastModified()).thenReturn((Object)20121008215654L, (Object[])new Long[]{20121008215654L, 20121008215655L, 20121008215655L, 20121008215655L, 20121008215656L});
        FileHandlerReloadingDetectorTestImpl detector = new FileHandlerReloadingDetectorTestImpl(f);
        detector.refresh();
        Assertions.assertFalse((boolean)detector.isReloadingRequired());
        Assertions.assertTrue((boolean)detector.isReloadingRequired());
        detector.reloadingPerformed();
        Assertions.assertFalse((boolean)detector.isReloadingRequired());
        Assertions.assertTrue((boolean)detector.isReloadingRequired());
    }

    @Test
    public void testReloadingAndReset() throws Exception {
        File f = (File)Mockito.mock(File.class);
        Mockito.when((Object)f.exists()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)f.lastModified()).thenReturn((Object)20121008215654L, (Object[])new Long[]{20121008215655L, 20121008215655L, 20121008215655L, 20121008215656L});
        FileHandlerReloadingDetectorTestImpl detector = new FileHandlerReloadingDetectorTestImpl(f);
        Assertions.assertFalse((boolean)detector.isReloadingRequired());
        Assertions.assertTrue((boolean)detector.isReloadingRequired());
        detector.reloadingPerformed();
        Assertions.assertFalse((boolean)detector.isReloadingRequired());
        Assertions.assertTrue((boolean)detector.isReloadingRequired());
    }

    private static class FileHandlerReloadingDetectorTestImpl
    extends FileHandlerReloadingDetector {
        private final File mockFile;

        public FileHandlerReloadingDetectorTestImpl(File file) {
            this(file, 0L);
        }

        public FileHandlerReloadingDetectorTestImpl(File file, long delay) {
            super(null, delay);
            this.mockFile = file;
        }

        protected File getFile() {
            return this.mockFile;
        }
    }
}

