/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.AbsoluteNameLocationStrategy;
import org.apache.commons.configuration2.io.BasePathLocationStrategy;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.FileSystemLocationStrategy;
import org.apache.commons.configuration2.io.HomeDirectoryLocationStrategy;
import org.apache.commons.configuration2.io.ProvidedURLLocationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestFileLocatorUtils {
    private static final String FILE_NAME = "test.xml";
    private static final String BASE_PATH = "/etc/test/path/";
    private static final String ENCODING = "utf-8";
    private static URL sourceURL;
    private static FileSystem fileSystem;

    private static void checkFullyInitializedLocator(FileLocator locator) throws ConfigurationException {
        Assertions.assertNotNull((Object)locator.getBasePath());
        Assertions.assertNotNull((Object)locator.getFileName());
        Assertions.assertNotNull((Object)locator.getSourceURL());
        FileHandler handler = new FileHandler();
        handler.setBasePath(locator.getBasePath());
        handler.setFileName(locator.getFileName());
        TestFileLocatorUtils.checkTestConfiguration(handler);
        handler = new FileHandler();
        handler.setURL(locator.getSourceURL());
        TestFileLocatorUtils.checkTestConfiguration(handler);
    }

    private static void checkTestConfiguration(FileHandler handler) throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        FileHandler h2 = new FileHandler((FileBased)config, handler);
        h2.load();
        Assertions.assertEquals((Object)"value", (Object)config.getString("element"));
    }

    @BeforeAll
    public static void setUpOnce() throws Exception {
        sourceURL = ConfigurationAssert.getTestURL(FILE_NAME);
        fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
    }

    @Test
    public void testConvertFileToURL() throws ConfigurationException {
        File file = ConfigurationAssert.getTestFile(FILE_NAME);
        FileHandler handler = new FileHandler();
        handler.setURL(FileLocatorUtils.convertFileToURL((File)file));
        TestFileLocatorUtils.checkTestConfiguration(handler);
    }

    @Test
    public void testConvertToURIException() throws URISyntaxException {
        URI uri = new URI("test://test/path/file.tst");
        Assertions.assertNull((Object)FileLocatorUtils.convertURIToURL((URI)uri));
    }

    @Test
    public void testDefaultFileLocationStrategy() {
        CombinedLocationStrategy strategy = (CombinedLocationStrategy)FileLocatorUtils.DEFAULT_LOCATION_STRATEGY;
        Iterator it = strategy.getSubStrategies().iterator();
        Assertions.assertInstanceOf(ProvidedURLLocationStrategy.class, it.next());
        Assertions.assertInstanceOf(FileSystemLocationStrategy.class, it.next());
        Assertions.assertInstanceOf(AbsoluteNameLocationStrategy.class, it.next());
        Assertions.assertInstanceOf(BasePathLocationStrategy.class, it.next());
        FileLocationStrategy sub = (FileLocationStrategy)it.next();
        HomeDirectoryLocationStrategy subStrategy = (HomeDirectoryLocationStrategy)Assertions.assertInstanceOf(HomeDirectoryLocationStrategy.class, (Object)sub);
        Assertions.assertTrue((boolean)subStrategy.isEvaluateBasePath());
        sub = (FileLocationStrategy)it.next();
        subStrategy = (HomeDirectoryLocationStrategy)Assertions.assertInstanceOf(HomeDirectoryLocationStrategy.class, (Object)sub);
        Assertions.assertFalse((boolean)subStrategy.isEvaluateBasePath());
        Assertions.assertInstanceOf(ClasspathLocationStrategy.class, it.next());
    }

    @Test
    public void testFileFromURLNull() throws Exception {
        Assertions.assertNull((Object)FileLocatorUtils.fileFromURL(null));
    }

    @Test
    public void testFileFromURLWithEncodedPercent() throws MalformedURLException {
        File file = new File("https%3A%2F%2Fwww.apache.org%2F.url").getAbsoluteFile();
        URL fileURL = file.toURI().toURL();
        File file2 = FileLocatorUtils.fileFromURL((URL)fileURL);
        Assertions.assertEquals((Object)file, (Object)file2);
    }

    @Test
    public void testFileFromURLWithPlus() throws MalformedURLException {
        File file = new File(new File("target"), "foo+bar.txt").getAbsoluteFile();
        URL fileURL = file.toURI().toURL();
        File file2 = FileLocatorUtils.fileFromURL((URL)fileURL);
        Assertions.assertEquals((Object)file, (Object)file2);
    }

    @Test
    public void testFromMapNoMap() {
        FileLocator fileLocator = FileLocatorUtils.fromMap(null);
        Assertions.assertEquals((Object)FileLocatorUtils.fileLocator().create(), (Object)fileLocator);
    }

    @Test
    public void testFullyInitializedLocatorAlreadyComplete() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        FileLocator fullLocator = FileLocatorUtils.fullyInitializedLocator((FileLocator)locator);
        Assertions.assertSame((Object)fullLocator, (Object)FileLocatorUtils.fullyInitializedLocator((FileLocator)fullLocator));
    }

    @Test
    public void testFullyInitializedLocatorFileName() throws ConfigurationException {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        TestFileLocatorUtils.checkFullyInitializedLocator(FileLocatorUtils.fullyInitializedLocator((FileLocator)locator));
    }

    @Test
    public void testFullyInitializedLocatorLocateFails() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName("non existing file").create();
        Assertions.assertNull((Object)FileLocatorUtils.fullyInitializedLocator((FileLocator)locator));
    }

    @Test
    public void testFullyInitializedLocatorUndefined() {
        Assertions.assertNull((Object)FileLocatorUtils.fullyInitializedLocator((FileLocator)FileLocatorUtils.fileLocator().create()));
    }

    @Test
    public void testFullyInitializedLocatorURL() throws ConfigurationException {
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(sourceURL).create();
        TestFileLocatorUtils.checkFullyInitializedLocator(FileLocatorUtils.fullyInitializedLocator((FileLocator)locator));
    }

    @Test
    public void testGetBasePath() throws Exception {
        URL url = new URL("http://xyz.net/foo/bar.xml");
        Assertions.assertEquals((Object)"http://xyz.net/foo/", (Object)FileLocatorUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net/foo/");
        Assertions.assertEquals((Object)"http://xyz.net/foo/", (Object)FileLocatorUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net/foo");
        Assertions.assertEquals((Object)"http://xyz.net/", (Object)FileLocatorUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net/");
        Assertions.assertEquals((Object)"http://xyz.net/", (Object)FileLocatorUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net");
        Assertions.assertEquals((Object)"http://xyz.net", (Object)FileLocatorUtils.getBasePath((URL)url));
    }

    @Test
    public void testGetFile() throws Exception {
        File directory = new File("target");
        File reference = new File(directory, "test.txt").getAbsoluteFile();
        Assertions.assertEquals((Object)FileLocatorUtils.getFile(null, (String)reference.getAbsolutePath()), (Object)reference);
        Assertions.assertEquals((Object)FileLocatorUtils.getFile((String)directory.getAbsolutePath(), (String)reference.getAbsolutePath()), (Object)reference);
        Assertions.assertEquals((Object)FileLocatorUtils.getFile((String)directory.getAbsolutePath(), (String)reference.getName()), (Object)reference);
        Assertions.assertEquals((Object)FileLocatorUtils.getFile((String)directory.toURI().toURL().toString(), (String)reference.getName()), (Object)reference);
        Assertions.assertEquals((Object)FileLocatorUtils.getFile((String)"invalid", (String)reference.toURI().toURL().toString()), (Object)reference);
        Assertions.assertEquals((Object)FileLocatorUtils.getFile((String)"jar:file:/C:/myjar.jar!/my-config.xml/someprops.properties", (String)reference.getAbsolutePath()), (Object)reference);
    }

    @Test
    public void testGetFileName() throws Exception {
        Assertions.assertNull((Object)FileLocatorUtils.getFileName(null));
        URL url = new URL("http://xyz.net/foo/");
        Assertions.assertNull((Object)FileLocatorUtils.getFileName((URL)url));
        url = new URL("http://xyz.net/foo/bar.xml");
        Assertions.assertEquals((Object)"bar.xml", (Object)FileLocatorUtils.getFileName((URL)url));
    }

    @Test
    public void testIsFullyInitializedNoBasePath() {
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(ConfigurationAssert.getTestURL(FILE_NAME)).fileName(FILE_NAME).create();
        Assertions.assertFalse((boolean)FileLocatorUtils.isFullyInitialized((FileLocator)locator));
    }

    @Test
    public void testIsFullyInitializedNull() {
        Assertions.assertFalse((boolean)FileLocatorUtils.isFullyInitialized(null));
    }

    @Test
    public void testIsLocationDefinedFalse() {
        FileLocator locator = FileLocatorUtils.fileLocator().encoding(ENCODING).basePath(BASE_PATH).fileSystem(FileLocatorUtils.DEFAULT_FILE_SYSTEM).create();
        Assertions.assertFalse((boolean)FileLocatorUtils.isLocationDefined((FileLocator)locator));
    }

    @Test
    public void testIsLocationDefinedFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        Assertions.assertTrue((boolean)FileLocatorUtils.isLocationDefined((FileLocator)locator));
    }

    @Test
    public void testIsLocationDefinedNull() {
        Assertions.assertFalse((boolean)FileLocatorUtils.isLocationDefined(null));
    }

    @Test
    public void testIsLocationDefinedURL() {
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(ConfigurationAssert.getTestURL(FILE_NAME)).create();
        Assertions.assertTrue((boolean)FileLocatorUtils.isLocationDefined((FileLocator)locator));
    }

    @Test
    public void testLocateNullLocator() {
        Assertions.assertNull((Object)FileLocatorUtils.locate(null));
    }

    @Test
    public void testLocateOrThrowFailed() {
        FileLocationStrategy strategy = (FileLocationStrategy)Mockito.mock(FileLocationStrategy.class);
        Mockito.when((Object)strategy.locate((FileSystem)ArgumentMatchers.any(), (FileLocator)ArgumentMatchers.any())).thenReturn(null);
        FileLocator locator = FileLocatorUtils.fileLocator().locationStrategy(strategy).create();
        Assertions.assertThrows(ConfigurationException.class, () -> FileLocatorUtils.locateOrThrow((FileLocator)locator));
    }

    @Test
    public void testLocateSuccessWithDefaults() {
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(sourceURL).create();
        Assertions.assertSame((Object)sourceURL, (Object)FileLocatorUtils.locate((FileLocator)locator));
    }

    @Test
    public void testLocateSuccessWithStrategyAndFileSystem() throws ConfigurationException {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FileLocationStrategy strategy = (FileLocationStrategy)Mockito.mock(FileLocationStrategy.class);
        FileLocator locator = FileLocatorUtils.fileLocator().fileSystem(fs).locationStrategy(strategy).create();
        Mockito.when((Object)strategy.locate(fs, locator)).thenReturn((Object)sourceURL);
        Assertions.assertSame((Object)sourceURL, (Object)FileLocatorUtils.locateOrThrow((FileLocator)locator));
        ((FileLocationStrategy)Mockito.verify((Object)strategy)).locate(fs, locator);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{strategy});
    }

    @Test
    public void testLocateSuccessWithStrategyDefaultFileSystem() throws ConfigurationException {
        FileLocationStrategy strategy = (FileLocationStrategy)Mockito.mock(FileLocationStrategy.class);
        FileLocator locator = FileLocatorUtils.fileLocator().locationStrategy(strategy).create();
        Mockito.when((Object)strategy.locate(FileLocatorUtils.DEFAULT_FILE_SYSTEM, locator)).thenReturn((Object)sourceURL);
        Assertions.assertSame((Object)sourceURL, (Object)FileLocatorUtils.locateOrThrow((FileLocator)locator));
        ((FileLocationStrategy)Mockito.verify((Object)strategy)).locate(FileLocatorUtils.DEFAULT_FILE_SYSTEM, locator);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{strategy});
    }

    @Test
    public void testLocateWithNullTCCL() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            Assertions.assertNull((Object)FileLocatorUtils.locate((FileLocator)FileLocatorUtils.fileLocator().basePath("abase").fileName("aname").create()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Test
    public void testObtainFileSystemNotSetInLocator() {
        Assertions.assertSame((Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)FileLocatorUtils.getFileSystem((FileLocator)FileLocatorUtils.fileLocator().create()));
    }

    @Test
    public void testObtainFileSystemNullLocator() {
        Assertions.assertSame((Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)FileLocatorUtils.getFileSystem(null));
    }

    @Test
    public void testObtainFileSystemSetInLocator() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FileLocator locator = FileLocatorUtils.fileLocator().fileSystem(fs).create();
        Assertions.assertSame((Object)fs, (Object)FileLocatorUtils.getFileSystem((FileLocator)locator));
    }

    @Test
    public void testObtainLocationStrategyNotSetInLocator() {
        FileLocator locator = FileLocatorUtils.fileLocator().create();
        Assertions.assertSame((Object)FileLocatorUtils.DEFAULT_LOCATION_STRATEGY, (Object)FileLocatorUtils.getLocationStrategy((FileLocator)locator));
    }

    @Test
    public void testObtainLocationStrategyNullLocator() {
        Assertions.assertSame((Object)FileLocatorUtils.DEFAULT_LOCATION_STRATEGY, (Object)FileLocatorUtils.getLocationStrategy(null));
    }

    @Test
    public void testObtainLocationStrategySetInLocator() {
        FileLocationStrategy strategy = (FileLocationStrategy)Mockito.mock(FileLocationStrategy.class);
        FileLocator locator = FileLocatorUtils.fileLocator().locationStrategy(strategy).create();
        Assertions.assertSame((Object)strategy, (Object)FileLocatorUtils.getLocationStrategy((FileLocator)locator));
    }

    @Test
    public void testPutNoLocator() {
        HashMap map = new HashMap();
        FileLocatorUtils.put(null, map);
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testPutNoMap() {
        FileLocator fileLocator = FileLocatorUtils.fileLocator().create();
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileLocatorUtils.put((FileLocator)fileLocator, null));
    }

    @Test
    public void testStoreFileLocatorInMap() {
        FileLocationStrategy strategy = (FileLocationStrategy)Mockito.mock(FileLocationStrategy.class);
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).encoding(ENCODING).fileName(FILE_NAME).fileSystem(fileSystem).locationStrategy(strategy).sourceURL(sourceURL).create();
        HashMap map = new HashMap();
        FileLocatorUtils.put((FileLocator)locator, map);
        FileLocator locator2 = FileLocatorUtils.fromMap(map);
        Assertions.assertEquals((Object)locator, (Object)locator2);
    }
}

