/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerList;
import org.apache.commons.configuration2.event.EventListenerRegistrationData;
import org.apache.commons.configuration2.event.EventType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestEventListenerList {
    private static final String MESSAGE = "TestEventMessage";
    private static EventType<EventBase> typeBase;
    private static EventType<EventSub1> typeSub1;
    private static EventType<EventSub2> typeSub2;
    private EventListenerList list;

    private static <T> List<T> fetchElements(Iterable<? extends T> iterable) {
        LinkedList<T> elems = new LinkedList<T>();
        for (T listener : iterable) {
            elems.add(listener);
        }
        return elems;
    }

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        typeBase = new EventType(Event.ANY, "BASE");
        typeSub1 = new EventType(typeBase, "SUB1");
        typeSub2 = new EventType(typeBase, "SUB2");
    }

    private void checkEventListenersForType(EventType<? extends Event> eventType, EventListener<?> ... expListeners) {
        List listeners = TestEventListenerList.fetchElements(this.list.getEventListeners(eventType));
        Assertions.assertEquals(Arrays.asList(expListeners), listeners);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.list = new EventListenerList();
    }

    @Test
    public void testAddAll() {
        ListenerTestImpl l1 = new ListenerTestImpl();
        ListenerTestImpl l2 = new ListenerTestImpl();
        ListenerTestImpl l3 = new ListenerTestImpl();
        this.list.addEventListener(typeBase, (EventListener)l1);
        EventListenerList list2 = new EventListenerList();
        list2.addEventListener(typeSub1, (EventListener)l2);
        list2.addEventListener(typeBase, (EventListener)l3);
        this.list.addAll(list2);
        Iterator it = this.list.getRegistrations().iterator();
        EventListenerRegistrationData reg = (EventListenerRegistrationData)it.next();
        Assertions.assertEquals(typeBase, (Object)reg.getEventType());
        Assertions.assertEquals((Object)l1, (Object)reg.getListener());
        reg = (EventListenerRegistrationData)it.next();
        Assertions.assertEquals(typeSub1, (Object)reg.getEventType());
        Assertions.assertEquals((Object)l2, (Object)reg.getListener());
        reg = (EventListenerRegistrationData)it.next();
        Assertions.assertEquals(typeBase, (Object)reg.getEventType());
        Assertions.assertEquals((Object)l3, (Object)reg.getListener());
    }

    @Test
    public void testAddAllNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.list.addAll(null));
    }

    @Test
    public void testClear() {
        this.list.addEventListener(typeSub1, (EventListener)new ListenerTestImpl());
        this.list.addEventListener(typeSub2, (EventListener)new ListenerTestImpl());
        this.list.clear();
        Assertions.assertTrue((boolean)this.list.getRegistrations().isEmpty());
    }

    @Test
    public void testEventListenerIteratorNullEvent() {
        this.list.addEventListener(typeBase, (EventListener)new ListenerTestImpl());
        EventListenerList.EventListenerIterator iterator = this.list.getEventListenerIterator(typeBase);
        Assertions.assertThrows(IllegalArgumentException.class, () -> iterator.invokeNext(null));
    }

    @Test
    public void testEventListenerIteratorWrongEvent() {
        EventListener listener = event -> {};
        this.list.addEventListener(typeSub2, listener);
        EventListenerList.EventListenerIterator iterator = this.list.getEventListenerIterator(typeSub2);
        Assertions.assertTrue((boolean)iterator.hasNext());
        EventBase event2 = new EventBase(this, typeBase, "Test");
        Assertions.assertThrows(IllegalArgumentException.class, () -> iterator.invokeNext(event2));
    }

    @Test
    public void testFireNullEvent() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.list.fire(null));
    }

    @Test
    public void testGetEventListenerRegistrationsForSuperType() {
        ListenerTestImpl l1 = new ListenerTestImpl();
        ListenerTestImpl l2 = new ListenerTestImpl();
        EventListener l3 = (EventListener)Mockito.mock(EventListener.class);
        this.list.addEventListener(typeSub1, (EventListener)l1);
        this.list.addEventListener(Event.ANY, l3);
        this.list.addEventListener(typeBase, (EventListener)l2);
        List regs = this.list.getRegistrationsForSuperType(typeBase);
        Iterator iterator = regs.iterator();
        Assertions.assertEquals((Object)l1, (Object)((EventListenerRegistrationData)iterator.next()).getListener());
        Assertions.assertEquals((Object)l2, (Object)((EventListenerRegistrationData)iterator.next()).getListener());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testGetEventListenersBaseType() {
        ListenerTestImpl listener1 = new ListenerTestImpl();
        ListenerTestImpl listener2 = new ListenerTestImpl();
        this.list.addEventListener(typeBase, (EventListener)listener1);
        this.list.addEventListener(typeBase, (EventListener)listener2);
        this.checkEventListenersForType(typeSub1, listener1, listener2);
    }

    @Test
    public void testGetEventListenersIteratorNextNoElement() {
        ListenerTestImpl listener1 = new ListenerTestImpl();
        ListenerTestImpl listener2 = new ListenerTestImpl();
        this.list.addEventListener(typeBase, (EventListener)listener1);
        this.list.addEventListener(typeBase, (EventListener)listener2);
        Iterator iterator = this.list.getEventListeners(typeBase).iterator();
        for (int i = 0; i < 2; ++i) {
            iterator.next();
        }
        Assertions.assertThrows(NoSuchElementException.class, iterator::next);
    }

    @Test
    public void testGetEventListenersIteratorRemove() {
        this.list.addEventListener(typeBase, (EventListener)new ListenerTestImpl());
        Iterator iterator = this.list.getEventListeners(typeBase).iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertThrows(UnsupportedOperationException.class, iterator::remove);
    }

    @Test
    public void testGetEventListenersMatchingType() {
        ListenerTestImpl listener1 = new ListenerTestImpl();
        ListenerTestImpl listener2 = new ListenerTestImpl();
        this.list.addEventListener(typeSub1, (EventListener)listener1);
        this.list.addEventListener(typeSub2, (EventListener)listener2);
        this.checkEventListenersForType(typeSub1, listener1);
    }

    @Test
    public void testGetEventListenersNoMatch() {
        this.list.addEventListener(typeSub1, (EventListener)new ListenerTestImpl());
        this.checkEventListenersForType(typeSub2, new EventListener[0]);
    }

    @Test
    public void testGetEventListenersNull() {
        Assertions.assertTrue((boolean)TestEventListenerList.fetchElements(this.list.getEventListeners(null)).isEmpty());
    }

    @Test
    public void testGetRegistrations() {
        EventListenerRegistrationData reg1 = new EventListenerRegistrationData(typeSub1, (EventListener)new ListenerTestImpl());
        EventListenerRegistrationData reg2 = new EventListenerRegistrationData(typeSub2, (EventListener)new ListenerTestImpl());
        this.list.addEventListener(reg1);
        this.list.addEventListener(reg2);
        List registrations = this.list.getRegistrations();
        Assertions.assertEquals(Arrays.asList(reg1, reg2), (Object)registrations);
    }

    @Test
    public void testGetRegistrationsModify() {
        EventListenerRegistrationData registrationData = new EventListenerRegistrationData(typeBase, (EventListener)new ListenerTestImpl());
        List registrations = this.list.getRegistrations();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> registrations.add(registrationData));
    }

    @Test
    public void testListenerRegistrationWithListenerData() {
        ListenerTestImpl listener = new ListenerTestImpl();
        EventListenerRegistrationData regData = new EventListenerRegistrationData(typeSub1, (EventListener)listener);
        this.list.addEventListener(regData);
        this.list.fire((Event)new EventSub1((Object)this, (EventType<? extends EventSub1>)typeSub1, MESSAGE));
        listener.assertEvent(this, typeSub1, MESSAGE);
    }

    @Test
    public void testListenerRegistrationWithNullListenerData() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.list.addEventListener(null));
    }

    @Test
    public void testMultipleListenerRegistration() {
        ListenerTestImpl listener = new ListenerTestImpl();
        this.list.addEventListener(typeSub1, (EventListener)listener);
        this.list.addEventListener(typeSub2, (EventListener)listener);
        this.list.fire((Event)new EventSub2((Object)this, (EventType<? extends EventSub2>)typeSub2, MESSAGE));
        this.list.removeEventListener(typeSub1, (EventListener)listener);
        this.list.fire((Event)new EventSub1((Object)this, (EventType<? extends EventSub1>)typeSub1, MESSAGE));
        listener.assertEvent(this, typeSub2, MESSAGE);
    }

    @Test
    public void testReceiveEventDifferentType() {
        ListenerTestImpl listener1 = new ListenerTestImpl();
        ListenerTestImpl listener2 = new ListenerTestImpl();
        this.list.addEventListener(typeSub1, (EventListener)listener1);
        this.list.addEventListener(typeSub2, (EventListener)listener2);
        this.list.fire((Event)new EventSub1((Object)this, (EventType<? extends EventSub1>)typeSub1, MESSAGE));
        listener1.assertEvent(this, typeSub1, MESSAGE);
        listener2.assertNoEvent();
    }

    @Test
    public void testReceiveEventMultipleListeners() {
        ListenerTestImpl listener1 = new ListenerTestImpl();
        ListenerTestImpl listener2 = new ListenerTestImpl();
        this.list.addEventListener(typeSub1, (EventListener)listener1);
        this.list.addEventListener(typeSub1, (EventListener)listener2);
        this.list.fire((Event)new EventSub1((Object)this, (EventType<? extends EventSub1>)typeSub1, MESSAGE));
        listener1.assertEvent(this, typeSub1, MESSAGE);
        listener2.assertEvent(this, typeSub1, MESSAGE);
    }

    @Test
    public void testReceiveEventOfExactType() {
        ListenerTestImpl listener = new ListenerTestImpl();
        this.list.addEventListener(typeSub1, (EventListener)listener);
        this.list.fire((Event)new EventSub1((Object)this, (EventType<? extends EventSub1>)typeSub1, MESSAGE));
        listener.assertEvent(this, typeSub1, MESSAGE);
    }

    @Test
    public void testReceiveEventSubType() {
        ListenerTestImpl listener = new ListenerTestImpl();
        this.list.addEventListener(typeBase, (EventListener)listener);
        this.list.fire((Event)new EventSub1((Object)this, (EventType<? extends EventSub1>)typeSub1, MESSAGE));
        listener.assertEvent(this, typeSub1, MESSAGE);
    }

    @Test
    public void testRegisterEventTypeNull() {
        ListenerTestImpl listener = new ListenerTestImpl();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.list.addEventListener(null, (EventListener)listener));
    }

    @Test
    public void testRegisterListenerNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.list.addEventListener(typeBase, null));
    }

    @Test
    public void testRemoveEventListenerExisting() {
        ListenerTestImpl listener = new ListenerTestImpl();
        this.list.addEventListener(typeSub1, (EventListener)listener);
        Assertions.assertTrue((boolean)this.list.removeEventListener(typeSub1, (EventListener)listener));
        this.list.fire((Event)new EventSub1((Object)this, (EventType<? extends EventSub1>)typeSub1, MESSAGE));
        listener.assertNoEvent();
    }

    @Test
    public void testRemoveEventListenerNonExistingEventType() {
        ListenerTestImpl listener = new ListenerTestImpl();
        this.list.addEventListener(typeSub1, (EventListener)listener);
        Assertions.assertFalse((boolean)this.list.removeEventListener(typeBase, (EventListener)listener));
    }

    @Test
    public void testRemoveEventListenerNonExistingListener() {
        this.list.addEventListener(typeBase, (EventListener)new ListenerTestImpl());
        Assertions.assertFalse((boolean)this.list.removeEventListener(typeBase, (EventListener)new ListenerTestImpl()));
    }

    @Test
    public void testRemoveEventListenerNullListener() {
        Assertions.assertFalse((boolean)this.list.removeEventListener(typeBase, null));
    }

    @Test
    public void testRemoveEventListenerNullRegistration() {
        Assertions.assertFalse((boolean)this.list.removeEventListener(null));
    }

    @Test
    public void testRemoveEventListenerNullType() {
        Assertions.assertFalse((boolean)this.list.removeEventListener(null, (EventListener)new ListenerTestImpl()));
    }

    @Test
    public void testSuppressEventOfSuperType() {
        ListenerTestImpl listener = new ListenerTestImpl();
        this.list.addEventListener(typeSub1, (EventListener)listener);
        this.list.fire((Event)new EventBase(this, typeBase, MESSAGE));
        listener.assertNoEvent();
    }

    private static class ListenerTestImpl
    implements EventListener<EventBase> {
        private EventBase receivedEvent;

        private ListenerTestImpl() {
        }

        public void assertEvent(Object expSource, EventType<?> expType, String expMessage) {
            Assertions.assertNotNull((Object)((Object)this.receivedEvent));
            Assertions.assertEquals((Object)expSource, (Object)this.receivedEvent.getSource());
            Assertions.assertEquals(expType, (Object)this.receivedEvent.getEventType());
            Assertions.assertEquals((Object)expMessage, (Object)this.receivedEvent.getMessage());
        }

        public void assertNoEvent() {
            Assertions.assertNull((Object)((Object)this.receivedEvent));
        }

        public void onEvent(EventBase event) {
            Assertions.assertNull((Object)((Object)this.receivedEvent), (String)("Too many events: " + (Object)((Object)event)));
            this.receivedEvent = event;
        }
    }

    private static class EventSub2
    extends EventBase {
        private static final long serialVersionUID = 1L;

        public EventSub2(Object source, EventType<? extends EventSub2> type, String msg) {
            super(source, type, msg);
        }
    }

    private static class EventSub1
    extends EventBase {
        private static final long serialVersionUID = 1L;

        public EventSub1(Object source, EventType<? extends EventSub1> type, String msg) {
            super(source, type, msg);
        }
    }

    private static class EventBase
    extends Event {
        private static final long serialVersionUID = 1L;
        private final String message;

        public EventBase(Object source, EventType<? extends EventBase> type, String msg) {
            super(source, type);
            this.message = msg;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

