/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BasicBuilderProperties;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.CopyObjectDefaultHandler;
import org.apache.commons.configuration2.builder.DefaultParametersHandler;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedBuilderProperties;
import org.apache.commons.configuration2.builder.ReloadingDetectorFactory;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.ReloadingCombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.CombinedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.reloading.AlwaysReloadingDetector;
import org.apache.commons.configuration2.reloading.RandomReloadingDetector;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.MergeCombiner;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestReloadingCombinedConfigurationBuilderFileBased {
    private static final String PROP_SRC = "override.xml";
    private static final String PROP_RELOAD = "default.xmlReload";
    private static final String RELOAD_CONTENT = "<config><default><xmlReload{1}>{0}</xmlReload{1}></default></config>";
    @TempDir
    public File tempFolder;
    private Parameters parameters;
    private ReloadingCombinedConfigurationBuilder builder;

    private static void addReloadSource(Configuration config, String fileName) {
        config.addProperty("override.xml(-1)[@fileName]", (Object)fileName);
        config.addProperty("override.xml[@config-reload]", (Object)Boolean.TRUE);
    }

    private static String testProperty(int idx) {
        return PROP_RELOAD + idx;
    }

    private static void writeFile(File file, String content) throws IOException {
        try (PrintWriter out = new PrintWriter(new FileWriter(file));){
            out.print(content);
        }
    }

    private void checkReloadDefinitionFile(File defFile) throws IOException, ConfigurationException, InterruptedException {
        File src1 = this.writeReloadFile(null, 1, 0);
        File src2 = this.writeReloadFile(null, 1, 1);
        this.writeDefinitionFile(defFile, src1);
        CombinedConfiguration config = this.builder.getConfiguration();
        Assertions.assertEquals((int)0, (int)config.getInt(TestReloadingCombinedConfigurationBuilderFileBased.testProperty(1)));
        boolean reloaded = false;
        for (int attempts = 0; attempts < 50 && !reloaded; ++attempts) {
            this.writeDefinitionFile(defFile, src2);
            reloaded = this.builder.getReloadingController().checkForReloading(null);
            if (reloaded) continue;
            Thread.sleep(100L);
        }
        Assertions.assertTrue((boolean)reloaded);
        config = this.builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)config.getInt(TestReloadingCombinedConfigurationBuilderFileBased.testProperty(1)));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.parameters = new Parameters();
        this.builder = new ReloadingCombinedConfigurationBuilder();
    }

    @Test
    public void testConcurrentGetAndReload() throws Exception {
        int threadCount = 4;
        int loopCount = 100;
        ReloadingDetectorFactory detectorFactory = (handler, params) -> new RandomReloadingDetector();
        BaseHierarchicalConfiguration defConf = new BaseHierarchicalConfiguration();
        defConf.addProperty("header.result.nodeCombiner[@config-class]", (Object)MergeCombiner.class.getName());
        defConf.addProperty("header.result.expressionEngine[@config-class]", (Object)XPathExpressionEngine.class.getName());
        TestReloadingCombinedConfigurationBuilderFileBased.addReloadSource((Configuration)defConf, "configA.xml");
        TestReloadingCombinedConfigurationBuilderFileBased.addReloadSource((Configuration)defConf, "configB.xml");
        ReadWriteSynchronizer sync = new ReadWriteSynchronizer();
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)((CombinedBuilderParameters)((CombinedBuilderParameters)((CombinedBuilderParameters)this.parameters.combined().setDefinitionBuilder((ConfigurationBuilder)new ConstantConfigurationBuilder(defConf))).setSynchronizer((Synchronizer)sync)).registerChildDefaultsHandler(BasicBuilderProperties.class, (DefaultParametersHandler)new CopyObjectDefaultHandler((BuilderParameters)new BasicBuilderParameters().setSynchronizer((Synchronizer)sync)))).registerChildDefaultsHandler(FileBasedBuilderProperties.class, (DefaultParametersHandler)new CopyObjectDefaultHandler((BuilderParameters)new FileBasedBuilderParametersImpl().setReloadingDetectorFactory(detectorFactory)))});
        Assertions.assertEquals((Object)"100", (Object)this.builder.getConfiguration().getString("/property[@name='config']/@value"));
        Thread[] testThreads = new Thread[4];
        int[] failures = new int[4];
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReloadThread(this.builder, failures, i, 100);
            testThreads[i].start();
        }
        int totalFailures = 0;
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i].join();
            totalFailures += failures[i];
        }
        Assertions.assertEquals((int)0, (int)totalFailures);
    }

    @Test
    public void testReloadDefinitionFileDefaultBuilder() throws ConfigurationException, IOException, InterruptedException {
        File defFile = TempDirUtils.newFile(this.tempFolder);
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.parameters.combined().setDefinitionBuilderParameters((BuilderParameters)((XMLBuilderParameters)this.parameters.xml().setReloadingRefreshDelay(Long.valueOf(0L))).setFile(defFile))});
        this.checkReloadDefinitionFile(defFile);
    }

    @Test
    public void testReloadDefinitionFileExplicitBuilder() throws ConfigurationException, IOException, InterruptedException {
        File defFile = TempDirUtils.newFile(this.tempFolder);
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.parameters.combined().setDefinitionBuilder((ConfigurationBuilder)new ReloadingFileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)this.parameters.xml().setReloadingRefreshDelay(Long.valueOf(0L))).setFile(defFile)}))});
        this.checkReloadDefinitionFile(defFile);
    }

    @Test
    public void testReloadFromFile() throws ConfigurationException, IOException {
        File xmlConf1 = this.writeReloadFile(null, 1, 0);
        File xmlConf2 = this.writeReloadFile(null, 2, 0);
        ReloadingDetectorFactory detectorFactory = (handler, params) -> new AlwaysReloadingDetector();
        BaseHierarchicalConfiguration defConf = new BaseHierarchicalConfiguration();
        TestReloadingCombinedConfigurationBuilderFileBased.addReloadSource((Configuration)defConf, xmlConf1.getAbsolutePath());
        TestReloadingCombinedConfigurationBuilderFileBased.addReloadSource((Configuration)defConf, xmlConf2.getAbsolutePath());
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)((CombinedBuilderParameters)this.parameters.combined().setDefinitionBuilder((ConfigurationBuilder)new ConstantConfigurationBuilder(defConf))).registerChildDefaultsHandler(FileBasedBuilderProperties.class, (DefaultParametersHandler)new CopyObjectDefaultHandler((BuilderParameters)new FileBasedBuilderParametersImpl().setReloadingDetectorFactory(detectorFactory)))});
        CombinedConfiguration config = this.builder.getConfiguration();
        Assertions.assertEquals((int)0, (int)config.getInt(TestReloadingCombinedConfigurationBuilderFileBased.testProperty(1)));
        Assertions.assertEquals((int)0, (int)config.getInt(TestReloadingCombinedConfigurationBuilderFileBased.testProperty(2)));
        this.writeReloadFile(xmlConf1, 1, 1);
        this.builder.getReloadingController().checkForReloading(null);
        config = this.builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)config.getInt(TestReloadingCombinedConfigurationBuilderFileBased.testProperty(1)));
        Assertions.assertEquals((int)0, (int)config.getInt(TestReloadingCombinedConfigurationBuilderFileBased.testProperty(2)));
        this.writeReloadFile(xmlConf2, 2, 2);
        this.builder.getReloadingController().checkForReloading(null);
        config = this.builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)config.getInt(TestReloadingCombinedConfigurationBuilderFileBased.testProperty(1)));
        Assertions.assertEquals((int)2, (int)config.getInt(TestReloadingCombinedConfigurationBuilderFileBased.testProperty(2)));
    }

    private void writeDefinitionFile(File defFile, File src) throws ConfigurationException {
        XMLConfiguration defConf = new XMLConfiguration();
        TestReloadingCombinedConfigurationBuilderFileBased.addReloadSource((Configuration)defConf, src.getAbsolutePath());
        new FileHandler((FileBased)defConf).save(defFile);
    }

    private File writeReloadFile(File f, int tagIdx, int value) throws IOException {
        return this.writeReloadFile(f, MessageFormat.format(RELOAD_CONTENT, value, tagIdx));
    }

    private File writeReloadFile(File f, String content) throws IOException {
        File file = f != null ? f : TempDirUtils.newFile(this.tempFolder);
        TestReloadingCombinedConfigurationBuilderFileBased.writeFile(file, content);
        return file;
    }

    private static class ReloadThread
    extends Thread {
        private final ReloadingCombinedConfigurationBuilder builder;
        private final int[] failures;
        private final int index;
        private final int count;

        ReloadThread(ReloadingCombinedConfigurationBuilder bldr, int[] failures, int index, int count) {
            this.builder = bldr;
            this.failures = failures;
            this.index = index;
            this.count = count;
        }

        @Override
        public void run() {
            this.failures[this.index] = 0;
            for (int i = 0; i < this.count; ++i) {
                try {
                    this.builder.getReloadingController().checkForReloading(null);
                    String value = this.builder.getConfiguration().getString("/property[@name='config']/@value");
                    if (value != null && value.equals("100")) continue;
                    int n = this.index;
                    this.failures[n] = this.failures[n] + 1;
                    continue;
                }
                catch (Exception ex) {
                    int n = this.index;
                    this.failures[n] = this.failures[n] + 1;
                }
            }
        }
    }

    private static class ConstantConfigurationBuilder
    extends BasicConfigurationBuilder<BaseHierarchicalConfiguration> {
        private final BaseHierarchicalConfiguration configuration;

        public ConstantConfigurationBuilder(BaseHierarchicalConfiguration conf) {
            super(BaseHierarchicalConfiguration.class);
            this.configuration = conf;
        }

        public BaseHierarchicalConfiguration getConfiguration() throws ConfigurationException {
            return this.configuration;
        }
    }
}

