/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestXMLListHandling {
    private static final String SOURCE = "<config><values>a,b,c</values><split><value>1</value><value>2</value></split><mixed><values>foo,blah</values><values>bar,baz</values></mixed></config>";
    private static final String KEY_VALUES = "values";
    private static final String KEY_SPLIT = "split.value";
    private static final String ELEM_SPLIT = "value";
    private XMLConfiguration config;

    private static void checkCommaSeparated(String xml, String key, String ... values) {
        String strValues = StringUtils.join((Object[])values, (char)',');
        String element = TestXMLListHandling.element(key, strValues);
        MatcherAssert.assertThat((Object)xml, (Matcher)CoreMatchers.containsString((String)element));
    }

    private static void checkSplit(String xml, String key, String ... values) {
        for (String v : values) {
            MatcherAssert.assertThat((Object)xml, (Matcher)CoreMatchers.containsString((String)TestXMLListHandling.element(key, v)));
        }
    }

    private static String element(String key, String value) {
        return "<" + key + '>' + value + "</" + key + '>';
    }

    private static XMLConfiguration readFromString(String xml) throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load((Reader)new StringReader(xml));
        return config;
    }

    private String saveToString() throws ConfigurationException {
        StringWriter writer = new StringWriter(4096);
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.save((Writer)writer);
        return writer.toString();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.config = TestXMLListHandling.readFromString(SOURCE);
    }

    @Test
    public void testAddListItem() throws ConfigurationException {
        this.config.addProperty(KEY_VALUES, (Object)"d");
        this.config.addProperty(KEY_SPLIT, (Object)"3");
        String xml = this.saveToString();
        TestXMLListHandling.checkSplit(xml, ELEM_SPLIT, "1", "2", "3");
        TestXMLListHandling.checkCommaSeparated(xml, KEY_VALUES, "a", "b", "c", "d");
    }

    @Test
    public void testIncompatibleListDelimiterOnSaving() {
        this.config.setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.saveToString());
    }

    @Test
    public void testMixedList() throws ConfigurationException {
        List<String> expected = Arrays.asList("foo", "blah", "bar", "baz");
        Assertions.assertEquals(expected, (Object)this.config.getList("mixed.values"));
        String xml = this.saveToString();
        XMLConfiguration c2 = TestXMLListHandling.readFromString(xml);
        Assertions.assertEquals(expected, (Object)c2.getList("mixed.values"));
    }

    @Test
    public void testRemoveListItem() throws ConfigurationException {
        this.config.clearProperty("values(2)");
        this.config.clearProperty("split.value(1)");
        String xml = this.saveToString();
        TestXMLListHandling.checkSplit(xml, ELEM_SPLIT, "1");
        TestXMLListHandling.checkCommaSeparated(xml, KEY_VALUES, "a", "b");
    }

    @Test
    public void testSaveNoChanges() throws ConfigurationException {
        String xml = this.saveToString();
        TestXMLListHandling.checkSplit(xml, ELEM_SPLIT, "1", "2");
        TestXMLListHandling.checkCommaSeparated(xml, KEY_VALUES, "a", "b", "c");
    }
}

