/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.resolver.CatalogResolver;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestXMLConfiguration {
    private static final String CATALOG_FILES = ConfigurationAssert.getTestFile("catalog.xml").getAbsolutePath();
    static final String ENCODING = "ISO-8859-1";
    static final String SYSTEM_ID = "properties.dtd";
    static final String PUBLIC_ID = "-//Commons Configuration//DTD Test Configuration 1.3//EN";
    static final String DOCTYPE_DECL = " PUBLIC \"-//Commons Configuration//DTD Test Configuration 1.3//EN\" \"properties.dtd\">";
    static final String DOCTYPE = "<!DOCTYPE ";
    static final String PROP_FACTORY = "javax.xml.transform.TransformerFactory";
    private static final int THREAD_COUNT = 5;
    private static final int LOOP_COUNT = 100;
    @TempDir
    public File tempFolder;
    private final String testProperties = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();
    private final String testProperties2 = ConfigurationAssert.getTestFile("testDigesterConfigurationInclude1.xml").getAbsolutePath();
    private File testSaveConf;
    private File testSaveFile;
    private final String testFile2 = ConfigurationAssert.getTestFile("sample.xml").getAbsolutePath();
    private XMLConfiguration conf;

    private static XMLConfiguration createFromFile(String fileName) throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        TestXMLConfiguration.load(config, fileName);
        return config;
    }

    private static void load(XMLConfiguration config, String fileName) throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)config);
        handler.setFileName(fileName);
        handler.load();
    }

    private XMLConfiguration checkSavedConfig() throws ConfigurationException {
        return this.checkSavedConfig(this.testSaveConf);
    }

    private XMLConfiguration checkSavedConfig(File saveFile) throws ConfigurationException {
        XMLConfiguration config = TestXMLConfiguration.createFromFile(saveFile.getAbsolutePath());
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)config);
        return config;
    }

    private void checkSaveDelimiterParsingDisabled(String key) throws ConfigurationException {
        this.conf.clear();
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        TestXMLConfiguration.load(this.conf, this.testProperties);
        this.conf.setProperty(key, (Object)"C:\\Temp\\,C:\\Data\\");
        this.conf.addProperty(key, (Object)"a,b,c");
        this.saveTestConfig();
        XMLConfiguration checkConf = new XMLConfiguration();
        checkConf.setListDelimiterHandler(this.conf.getListDelimiterHandler());
        TestXMLConfiguration.load(checkConf, this.testSaveConf.getAbsolutePath());
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)checkConf);
    }

    private DocumentBuilder createValidatingDocBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new DefaultHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }
        });
        return builder;
    }

    private Document parseXml(String xml) throws SAXException, IOException, ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    private void removeTestFile() {
        if (this.testSaveConf.exists()) {
            Assertions.assertTrue((boolean)this.testSaveConf.delete());
        }
    }

    private void saveTestConfig() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.save(this.testSaveConf);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testSaveConf = TempDirUtils.newFile("testsave.xml", this.tempFolder);
        this.testSaveFile = TempDirUtils.newFile("testsample2.xml", this.tempFolder);
        this.conf = TestXMLConfiguration.createFromFile(this.testProperties);
        this.removeTestFile();
    }

    @Test
    public void testAddList() {
        this.conf.addProperty("test.array", (Object)"value1");
        this.conf.addProperty("test.array", (Object)"value2");
        List list = this.conf.getList("test.array");
        Assertions.assertEquals(Arrays.asList("value1", "value2"), (Object)list);
    }

    @Test
    public void testAddNodesAndSave() throws ConfigurationException {
        ImmutableNode.Builder bldrNode = new ImmutableNode.Builder(1);
        bldrNode.addChild(NodeStructureHelper.createNode("child", null));
        bldrNode.addAttribute("attr", (Object)"");
        ImmutableNode node2 = NodeStructureHelper.createNode("test2", null);
        this.conf.addNodes("add.nodes", Arrays.asList(bldrNode.name("test").create(), node2));
        this.saveTestConfig();
        this.conf.setProperty("add.nodes.test", (Object)"true");
        this.conf.setProperty("add.nodes.test.child", (Object)"yes");
        this.conf.setProperty("add.nodes.test[@attr]", (Object)"existing");
        this.conf.setProperty("add.nodes.test2", (Object)"anotherValue");
        this.saveTestConfig();
        XMLConfiguration c2 = new XMLConfiguration();
        TestXMLConfiguration.load(c2, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"true", (Object)c2.getString("add.nodes.test"));
        Assertions.assertEquals((Object)"yes", (Object)c2.getString("add.nodes.test.child"));
        Assertions.assertEquals((Object)"existing", (Object)c2.getString("add.nodes.test[@attr]"));
        Assertions.assertEquals((Object)"anotherValue", (Object)c2.getString("add.nodes.test2"));
    }

    @Test
    public void testAddNodesCopy() throws ConfigurationException {
        XMLConfiguration c2 = new XMLConfiguration();
        TestXMLConfiguration.load(c2, this.testProperties2);
        this.conf.addNodes("copiedProperties", (Collection)((ImmutableNode)c2.getModel().getNodeHandler().getRootNode()).getChildren());
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test
    public void testAddNodesToSubnodeConfiguration() throws Exception {
        HierarchicalConfiguration sub = this.conf.configurationAt("element2", true);
        sub.addProperty("newKey", (Object)"newvalue");
        Assertions.assertEquals((Object)"newvalue", (Object)this.conf.getString("element2.newKey"));
    }

    @Test
    public void testAddObjectAttribute() {
        this.conf.addProperty("test.boolean[@value]", (Object)Boolean.TRUE);
        Assertions.assertTrue((boolean)this.conf.getBoolean("test.boolean[@value]"));
    }

    @Test
    public void testAddObjectProperty() {
        this.conf.addProperty("test.boolean", (Object)Boolean.TRUE);
        Assertions.assertTrue((boolean)this.conf.getBoolean("test.boolean"));
    }

    @Test
    public void testAddProperty() {
        XMLConfiguration config = new XMLConfiguration();
        config.addProperty("test.string", (Object)"hello");
        Assertions.assertEquals((Object)"hello", (Object)config.getString("test.string"));
    }

    @Test
    public void testAddPropertyListWithDelimiterParsingDisabled() throws ConfigurationException {
        this.conf.clear();
        String prop = "delimiterListProp";
        this.conf.setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
        List<String> list = Arrays.asList("val", "val2", "val3");
        this.conf.addProperty("delimiterListProp", list);
        this.saveTestConfig();
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals(list, (Object)conf2.getProperty("delimiterListProp"));
    }

    @Test
    public void testAppend() throws Exception {
        TestXMLConfiguration.load(this.conf, this.testProperties2);
        Assertions.assertEquals((Object)"value", (Object)this.conf.getString("element"));
        Assertions.assertEquals((Object)"tasks", (Object)this.conf.getString("table.name"));
        this.saveTestConfig();
        this.conf = TestXMLConfiguration.createFromFile(this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"value", (Object)this.conf.getString("element"));
        Assertions.assertEquals((Object)"tasks", (Object)this.conf.getString("table.name"));
        Assertions.assertEquals((Object)"application", (Object)this.conf.getString("table[@tableType]"));
    }

    @Test
    public void testAttributeKeyWithMultipleValues() throws ConfigurationException {
        this.conf.addProperty("errorTest[@multiAttr]", Arrays.asList("v1", "v2"));
        this.saveTestConfig();
        XMLConfiguration checkConfig = new XMLConfiguration();
        TestXMLConfiguration.load(checkConfig, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"v1", (Object)checkConfig.getString("errorTest[@multiAttr]"));
    }

    @Test
    public void testAutoSaveAddNodes() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(this.testProperties)});
        this.conf = (XMLConfiguration)builder.getConfiguration();
        builder.getFileHandler().setFile(this.testSaveConf);
        builder.setAutoSave(true);
        ImmutableNode node = NodeStructureHelper.createNode("addNodesTest", Boolean.TRUE);
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>(1);
        nodes.add(node);
        this.conf.addNodes("test.autosave", nodes);
        XMLConfiguration c2 = new XMLConfiguration();
        TestXMLConfiguration.load(c2, this.testSaveConf.getAbsolutePath());
        Assertions.assertTrue((boolean)c2.getBoolean("test.autosave.addNodesTest"));
    }

    @Test
    public void testAutoSaveWithSubnodeConfig() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(this.testProperties)});
        this.conf = (XMLConfiguration)builder.getConfiguration();
        builder.getFileHandler().setFile(this.testSaveConf);
        builder.setAutoSave(true);
        String newValue = "I am autosaved";
        HierarchicalConfiguration sub = this.conf.configurationAt("element2.subelement", true);
        sub.setProperty("subsubelement", (Object)"I am autosaved");
        Assertions.assertEquals((Object)"I am autosaved", (Object)this.conf.getString("element2.subelement.subsubelement"));
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"I am autosaved", (Object)conf2.getString("element2.subelement.subsubelement"));
    }

    @Test
    public void testAutoSaveWithSubSubnodeConfig() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(this.testProperties)});
        this.conf = (XMLConfiguration)builder.getConfiguration();
        builder.getFileHandler().setFile(this.testSaveConf);
        builder.setAutoSave(true);
        String newValue = "I am autosaved";
        HierarchicalConfiguration sub1 = this.conf.configurationAt("element2", true);
        HierarchicalConfiguration sub2 = sub1.configurationAt("subelement", true);
        sub2.setProperty("subsubelement", (Object)"I am autosaved");
        Assertions.assertEquals((Object)"I am autosaved", (Object)this.conf.getString("element2.subelement.subsubelement"));
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"I am autosaved", (Object)conf2.getString("element2.subelement.subsubelement"));
    }

    @Test
    public void testClearAttributeMultipleDisjoined() throws Exception {
        String key = "clear.list.item[@id]";
        this.conf.clearProperty(key);
        Assertions.assertNull((Object)this.conf.getProperty(key));
        Assertions.assertNull((Object)this.conf.getProperty(key));
        key = "clear.list.item";
        Assertions.assertNotNull((Object)this.conf.getProperty(key));
        Assertions.assertNotNull((Object)this.conf.getProperty(key));
    }

    @Test
    public void testClearAttributeNonExisting() {
        String key = "clear[@id]";
        this.conf.clearProperty("clear[@id]");
        Assertions.assertNull((Object)this.conf.getProperty("clear[@id]"));
        Assertions.assertNull((Object)this.conf.getProperty("clear[@id]"));
    }

    @Test
    public void testClearAttributeSingle() {
        String key = "clear.element2[@id]";
        this.conf.clearProperty(key);
        Assertions.assertNull((Object)this.conf.getProperty(key));
        Assertions.assertNull((Object)this.conf.getProperty(key));
        key = "clear.element2";
        Assertions.assertNotNull((Object)this.conf.getProperty(key));
        Assertions.assertNotNull((Object)this.conf.getProperty(key));
    }

    @Test
    public void testClearPropertyCData() {
        String key = "clear.cdata";
        this.conf.clearProperty("clear.cdata");
        Assertions.assertNull((Object)this.conf.getProperty("clear.cdata"));
        Assertions.assertNull((Object)this.conf.getProperty("clear.cdata"));
    }

    @Test
    public void testClearPropertyMultipleDisjoined() throws Exception {
        String key = "list.item";
        this.conf.clearProperty("list.item");
        Assertions.assertNull((Object)this.conf.getProperty("list.item"));
        Assertions.assertNull((Object)this.conf.getProperty("list.item"));
    }

    @Test
    public void testClearPropertyMultipleSiblings() {
        String key = "clear.list.item";
        this.conf.clearProperty(key);
        Assertions.assertNull((Object)this.conf.getProperty(key));
        Assertions.assertNull((Object)this.conf.getProperty(key));
        key = "clear.list.item[@id]";
        Assertions.assertNotNull((Object)this.conf.getProperty(key));
        Assertions.assertNotNull((Object)this.conf.getProperty(key));
    }

    @Test
    public void testClearPropertyNonText() {
        String key = "clear.comment";
        this.conf.clearProperty("clear.comment");
        Assertions.assertNull((Object)this.conf.getProperty("clear.comment"));
        Assertions.assertNull((Object)this.conf.getProperty("clear.comment"));
    }

    @Test
    public void testClearPropertyNotExisting() {
        String key = "clearly";
        this.conf.clearProperty("clearly");
        Assertions.assertNull((Object)this.conf.getProperty("clearly"));
        Assertions.assertNull((Object)this.conf.getProperty("clearly"));
    }

    @Test
    public void testClearPropertySingleElement() {
        String key = "clear.element";
        this.conf.clearProperty("clear.element");
        Assertions.assertNull((Object)this.conf.getProperty("clear.element"));
        Assertions.assertNull((Object)this.conf.getProperty("clear.element"));
    }

    @Test
    public void testClearPropertySingleElementWithAttribute() {
        String key = "clear.element2";
        this.conf.clearProperty(key);
        Assertions.assertNull((Object)this.conf.getProperty(key));
        Assertions.assertNull((Object)this.conf.getProperty(key));
        key = "clear.element2[@id]";
        Assertions.assertNotNull((Object)this.conf.getProperty(key));
        Assertions.assertNotNull((Object)this.conf.getProperty(key));
    }

    @Test
    public void testClearTextRootElement() throws ConfigurationException {
        String xml = "<e a=\"v\">text</e>";
        this.conf.clear();
        StringReader in = new StringReader("<e a=\"v\">text</e>");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((Reader)in);
        Assertions.assertEquals((Object)"text", (Object)this.conf.getString(""));
        this.conf.clearProperty("");
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test
    public void testClone() {
        Configuration c = (Configuration)this.conf.clone();
        XMLConfiguration copy = (XMLConfiguration)Assertions.assertInstanceOf(XMLConfiguration.class, (Object)c);
        Assertions.assertNotNull((Object)this.conf.getDocument());
        Assertions.assertNull((Object)copy.getDocument());
        copy.setProperty("element3", (Object)"clonedValue");
        Assertions.assertEquals((Object)"value", (Object)this.conf.getString("element3"));
        this.conf.setProperty("element3[@name]", (Object)"originalFoo");
        Assertions.assertEquals((Object)"foo", (Object)copy.getString("element3[@name]"));
    }

    @Test
    public void testCloneWithSave() throws ConfigurationException {
        XMLConfiguration c = (XMLConfiguration)this.conf.clone();
        c.addProperty("test.newProperty", (Object)Boolean.TRUE);
        this.conf.addProperty("test.orgProperty", (Object)Boolean.TRUE);
        new FileHandler((FileBased)c).save(this.testSaveConf);
        XMLConfiguration c2 = new XMLConfiguration();
        TestXMLConfiguration.load(c2, this.testSaveConf.getAbsolutePath());
        Assertions.assertTrue((boolean)c2.getBoolean("test.newProperty"));
        Assertions.assertFalse((boolean)c2.containsKey("test.orgProperty"));
    }

    @Test
    public void testComplexNames() {
        Assertions.assertEquals((Object)"Name with dot", (Object)this.conf.getString("complexNames.my..elem"));
        Assertions.assertEquals((Object)"Another dot", (Object)this.conf.getString("complexNames.my..elem.sub..elem"));
    }

    @Test
    public void testConcurrentGetAndReload() throws ConfigurationException, InterruptedException {
        int i;
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(this.testProperties)});
        XMLConfiguration config = (XMLConfiguration)builder.getConfiguration();
        Assertions.assertNotNull((Object)config.getProperty("test.short"));
        Thread[] testThreads = new Thread[5];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReloadThread(builder);
            testThreads[i].start();
        }
        for (i = 0; i < 100; ++i) {
            config = (XMLConfiguration)builder.getConfiguration();
            Assertions.assertNotNull((Object)config.getProperty("test.short"));
        }
        for (Thread testThread : testThreads) {
            testThread.join();
        }
    }

    @Test
    public void testCopyNull() {
        this.conf = new XMLConfiguration(null);
        Assertions.assertTrue((boolean)this.conf.isEmpty());
        Assertions.assertEquals((Object)"configuration", (Object)this.conf.getRootElementName());
    }

    @Test
    public void testCopyRootName() throws ConfigurationException {
        String rootName = "rootElement";
        String xml = "<rootElement><test>true</test></rootElement>";
        this.conf.clear();
        new FileHandler((FileBased)this.conf).load((Reader)new StringReader("<rootElement><test>true</test></rootElement>"));
        XMLConfiguration copy = new XMLConfiguration((HierarchicalConfiguration)this.conf);
        Assertions.assertEquals((Object)"rootElement", (Object)copy.getRootElementName());
        new FileHandler((FileBased)copy).save(this.testSaveConf);
        copy = new XMLConfiguration();
        TestXMLConfiguration.load(copy, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"rootElement", (Object)copy.getRootElementName());
    }

    @Test
    public void testCopyRootNameNoDocument() throws ConfigurationException {
        String rootName = "rootElement";
        this.conf = new XMLConfiguration();
        this.conf.setRootElementName("rootElement");
        this.conf.setProperty("test", (Object)Boolean.TRUE);
        XMLConfiguration copy = new XMLConfiguration((HierarchicalConfiguration)this.conf);
        Assertions.assertEquals((Object)"rootElement", (Object)copy.getRootElementName());
        new FileHandler((FileBased)copy).save(this.testSaveConf);
        TestXMLConfiguration.load(copy, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"rootElement", (Object)copy.getRootElementName());
    }

    @Test
    public void testCustomDocBuilder() throws Exception {
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, ConfigurationAssert.getTestFile("testValidateInvalid.xml").getAbsolutePath());
        Assertions.assertEquals((Object)"customers", (Object)this.conf.getString("table.name"));
        Assertions.assertFalse((boolean)this.conf.containsKey("table.fields.field(1).type"));
    }

    @Test
    public void testCustomDocBuilderValidationError() throws Exception {
        DocumentBuilder builder = this.createValidatingDocBuilder();
        this.conf = new XMLConfiguration();
        this.conf.setDocumentBuilder(builder);
        String fileName = ConfigurationAssert.getTestFile("testValidateInvalid.xml").getAbsolutePath();
        Assertions.assertThrows(ConfigurationException.class, () -> TestXMLConfiguration.load(this.conf, fileName));
    }

    @Test
    public void testCustomDocBuilderValidationSuccess() throws Exception {
        DocumentBuilder builder = this.createValidatingDocBuilder();
        this.conf = new XMLConfiguration();
        this.conf.setDocumentBuilder(builder);
        TestXMLConfiguration.load(this.conf, ConfigurationAssert.getTestFile("testValidateValid.xml").getAbsolutePath());
        Assertions.assertTrue((boolean)this.conf.containsKey("table.fields.field(1).type"));
    }

    @Test
    public void testDelimiterParsingDisabled() throws ConfigurationException {
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testProperties);
        Assertions.assertEquals((Object)"a,b,c", (Object)conf2.getString("split.list3[@values]"));
        Assertions.assertEquals((int)0, (int)conf2.getMaxIndex("split.list3[@values]"));
        Assertions.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split.list4[@values]"));
        Assertions.assertEquals((Object)"a,b,c", (Object)conf2.getString("split.list1"));
        Assertions.assertEquals((int)0, (int)conf2.getMaxIndex("split.list1"));
        Assertions.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split.list2"));
    }

    @Test
    public void testDelimiterParsingDisabledXPath() throws ConfigurationException {
        XMLConfiguration conf2 = new XMLConfiguration();
        conf2.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        TestXMLConfiguration.load(conf2, this.testProperties);
        Assertions.assertEquals((Object)"a,b,c", (Object)conf2.getString("split/list3/@values"));
        Assertions.assertEquals((int)0, (int)conf2.getMaxIndex("split/list3/@values"));
        Assertions.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split/list4/@values"));
        Assertions.assertEquals((Object)"a,b,c", (Object)conf2.getString("split/list1"));
        Assertions.assertEquals((int)0, (int)conf2.getMaxIndex("split/list1"));
        Assertions.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split/list2"));
    }

    @Test
    public void testDtd() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, "testDtd.xml");
        Assertions.assertEquals((Object)"value1", (Object)this.conf.getString("entry(0)"));
        Assertions.assertEquals((Object)"test2", (Object)this.conf.getString("entry(1)[@key]"));
    }

    @Test
    public void testEmptyAttribute() throws ConfigurationException {
        String key = "element3[@value]";
        this.conf.setProperty("element3[@value]", (Object)"");
        Assertions.assertTrue((boolean)this.conf.containsKey("element3[@value]"));
        Assertions.assertEquals((Object)"", (Object)this.conf.getString("element3[@value]"));
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assertions.assertTrue((boolean)this.conf.containsKey("element3[@value]"));
        Assertions.assertEquals((Object)"", (Object)this.conf.getString("element3[@value]"));
    }

    @Test
    public void testEmptyElements() throws ConfigurationException {
        Assertions.assertTrue((boolean)this.conf.containsKey("empty"));
        Assertions.assertEquals((Object)"", (Object)this.conf.getString("empty"));
        this.conf.addProperty("empty2", (Object)"");
        this.conf.setProperty("empty", (Object)"no more empty");
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"no more empty", (Object)this.conf.getString("empty"));
        Assertions.assertEquals((Object)"", (Object)this.conf.getProperty("empty2"));
    }

    @Test
    public void testEmptyReload() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        Assertions.assertTrue((boolean)this.conf.isEmpty());
        this.saveTestConfig();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assertions.assertTrue((boolean)this.conf.isEmpty());
    }

    @Test
    public void testGetAttribute() {
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getProperty("element3[@name]"));
    }

    @Test
    public void testGetCommentedProperty() {
        Assertions.assertEquals((Object)"", (Object)this.conf.getProperty("test.comment"));
    }

    @Test
    public void testGetComplexProperty() {
        Assertions.assertEquals((Object)"I'm complex!", (Object)this.conf.getProperty("element2.subelement.subsubelement"));
    }

    @Test
    public void testgetProperty() {
        Object property = this.conf.getProperty("clear");
        Assertions.assertNull((Object)property);
        property = this.conf.getProperty("e");
        Assertions.assertNull((Object)property);
        property = this.conf.getProperty("element3[@n]");
        Assertions.assertNull((Object)property);
        property = this.conf.getProperty("element");
        Assertions.assertInstanceOf(String.class, (Object)property);
        Assertions.assertEquals((Object)"value", (Object)property);
        property = this.conf.getProperty("element3[@name]");
        Assertions.assertInstanceOf(String.class, (Object)property);
        Assertions.assertEquals((Object)"foo", (Object)property);
        property = this.conf.getProperty("test.comment");
        Assertions.assertEquals((Object)"", (Object)property);
        property = this.conf.getProperty("test.cdata");
        Assertions.assertInstanceOf(String.class, (Object)property);
        Assertions.assertEquals((Object)"<cdata value>", (Object)property);
        property = this.conf.getProperty("list.sublist.item");
        List list = (List)Assertions.assertInstanceOf(List.class, (Object)property);
        Assertions.assertEquals(Arrays.asList("five", "six"), (Object)list);
        property = this.conf.getProperty("list.item");
        list = (List)Assertions.assertInstanceOf(List.class, (Object)property);
        Assertions.assertEquals(Arrays.asList("one", "two", "three", "four"), (Object)list);
        property = this.conf.getProperty("list.item[@name]");
        list = (List)Assertions.assertInstanceOf(List.class, (Object)property);
        Assertions.assertEquals(Arrays.asList("one", "three"), (Object)list);
    }

    @Test
    public void testGetProperty() {
        Assertions.assertEquals((Object)"value", (Object)this.conf.getProperty("element"));
    }

    @Test
    public void testGetPropertyWithXMLEntity() {
        Assertions.assertEquals((Object)"1<2", (Object)this.conf.getProperty("test.entity"));
    }

    @Test
    public void testInitCopy() throws ConfigurationException {
        XMLConfiguration copy = new XMLConfiguration((HierarchicalConfiguration)this.conf);
        copy.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        Assertions.assertEquals((Object)"value", (Object)copy.getProperty("element"));
        Assertions.assertNull((Object)copy.getDocument());
        new FileHandler((FileBased)copy).save(this.testSaveConf);
        this.checkSavedConfig();
    }

    @Test
    public void testListWithAttributes() {
        Assertions.assertEquals((int)6, (int)this.conf.getList("attrList.a").size());
        Assertions.assertEquals((Object)"ABC", (Object)this.conf.getString("attrList.a(0)"));
        Assertions.assertEquals((Object)"x", (Object)this.conf.getString("attrList.a(0)[@name]"));
        Assertions.assertEquals((int)6, (int)this.conf.getList("attrList.a[@name]").size());
    }

    @Test
    public void testListWithAttributesMultiValue() {
        Assertions.assertEquals((Object)"1", (Object)this.conf.getString("attrList.a(1)"));
        Assertions.assertEquals((Object)"y", (Object)this.conf.getString("attrList.a(1)[@name]"));
        for (int i = 1; i <= 3; ++i) {
            Assertions.assertEquals((int)i, (int)this.conf.getInt("attrList.a(" + i + ")"));
            Assertions.assertEquals((Object)"y", (Object)this.conf.getString("attrList.a(" + i + ")[@name]"));
        }
    }

    @Test
    public void testListWithMultipleAttributesMultiValue() {
        for (int i = 1; i <= 2; ++i) {
            String idxStr = String.format("(%d)", i + 3);
            String nodeKey = "attrList.a" + idxStr;
            Assertions.assertEquals((Object)("value" + i), (Object)this.conf.getString(nodeKey));
            Assertions.assertEquals((Object)"u", (Object)this.conf.getString(nodeKey + "[@name]"));
            Assertions.assertEquals((Object)"yes", (Object)this.conf.getString(nodeKey + "[@test]"));
        }
    }

    @Test
    public void testLoadAndSaveFromFile() throws Exception {
        Assertions.assertFalse((boolean)this.testSaveConf.exists());
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class, null, true);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(this.testSaveConf)});
        this.conf = (XMLConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)this.conf.isEmpty());
        this.conf.addProperty("test", (Object)"yes");
        builder.save();
        XMLConfiguration checkConfig = TestXMLConfiguration.createFromFile(this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"yes", (Object)checkConfig.getString("test"));
    }

    @Test
    public void testLoadChildNamespace() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        new FileHandler((FileBased)this.conf).load(ConfigurationAssert.getTestFile("testChildNamespace.xml"));
        Assertions.assertEquals((Object)"http://example.com/", (Object)this.conf.getString("foo:bar.[@xmlns:foo]"));
    }

    @Test
    public void testLoadFromStream() throws Exception {
        String xml = "<?xml version=\"1.0\"?><config><test>1</test></config>";
        this.conf = new XMLConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\"?><config><test>1</test></config>".getBytes()));
        Assertions.assertEquals((int)1, (int)this.conf.getInt("test"));
        this.conf = new XMLConfiguration();
        handler = new FileHandler((FileBased)this.conf);
        handler.load((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\"?><config><test>1</test></config>".getBytes()), "UTF8");
        Assertions.assertEquals((int)1, (int)this.conf.getInt("test"));
    }

    @Test
    public void testLoadInvalidXML() throws Exception {
        String xml = "<?xml version=\"1.0\"?><config><test>1</rest></config>";
        this.conf = new XMLConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        StringReader reader = new StringReader("<?xml version=\"1.0\"?><config><test>1</rest></config>");
        Assertions.assertThrows(ConfigurationException.class, () -> handler.load((Reader)reader));
    }

    @Test
    public void testLoadWithEncoding() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        new FileHandler((FileBased)this.conf).load(ConfigurationAssert.getTestFile("testEncoding.xml"));
        Assertions.assertEquals((Object)"test3_yoge", (Object)this.conf.getString("yoge"));
    }

    @Test
    public void testLoadWithRootNamespace() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        new FileHandler((FileBased)this.conf).load(ConfigurationAssert.getTestFile("testRootNamespace.xml"));
        Assertions.assertEquals((Object)"http://example.com/", (Object)this.conf.getString("[@xmlns:foo]"));
    }

    @Test
    public void testNoDelimiterParsingInAttrValues() throws ConfigurationException {
        this.conf.clear();
        TestXMLConfiguration.load(this.conf, this.testProperties);
        List expr = this.conf.getList("expressions[@value]");
        Assertions.assertEquals(Arrays.asList("a || (b && c) | !d"), (Object)expr);
    }

    @Test
    public void testOverrideAttribute() {
        this.conf.addProperty("element3[@name]", (Object)"bar");
        List list = this.conf.getList("element3[@name]");
        Assertions.assertEquals(Arrays.asList("bar"), (Object)list);
    }

    @Test
    public void testPreserveSpace() {
        Assertions.assertEquals((Object)" ", (Object)this.conf.getString("space.blank"));
        Assertions.assertEquals((Object)" * * ", (Object)this.conf.getString("space.stars"));
    }

    @Test
    public void testPreserveSpaceInvalid() {
        Assertions.assertEquals((Object)"Some other text", (Object)this.conf.getString("space.testInvalid"));
    }

    @Test
    public void testPreserveSpaceOnElement() {
        Assertions.assertEquals((Object)" preserved ", (Object)this.conf.getString("spaceElement"));
        Assertions.assertEquals((Object)"   ", (Object)this.conf.getString("spaceBlankElement"));
    }

    @Test
    public void testPreserveSpaceOverride() {
        Assertions.assertEquals((Object)"Some text", (Object)this.conf.getString("space.description"));
    }

    @Test
    public void testPublicIdSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.setPublicID(PUBLIC_ID);
        Assertions.assertEquals((Object)PUBLIC_ID, (Object)this.conf.getPublicID());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE, SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testReadCalledDirectly() {
        this.conf = new XMLConfiguration();
        String content = "<configuration><test>1</test></configuration>";
        ByteArrayInputStream bis = new ByteArrayInputStream("<configuration><test>1</test></configuration>".getBytes());
        ConfigurationException e = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> this.conf.read((InputStream)bis));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"FileHandler"));
    }

    @Test
    public void testSave() throws Exception {
        this.conf.addProperty("string", (Object)"value1");
        for (int i = 1; i < 5; ++i) {
            this.conf.addProperty("test.array", (Object)("value" + i));
        }
        this.conf.addProperty("split.list5", (Object)"a\\,b\\,c");
        this.conf.setProperty("element3", (Object)"value\\,value1\\,value2");
        this.conf.setProperty("element3[@name]", (Object)"foo\\,bar");
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test
    public void testSaveAfterCreateWithCopyConstructor() throws ConfigurationException {
        HierarchicalConfiguration hc = this.conf.configurationAt("element2");
        this.conf = new XMLConfiguration(hc);
        this.saveTestConfig();
        XMLConfiguration checkConfig = this.checkSavedConfig();
        Assertions.assertEquals((Object)"element2", (Object)checkConfig.getRootElementName());
    }

    @Test
    public void testSaveAttributes() throws Exception {
        this.conf.clear();
        TestXMLConfiguration.load(this.conf, this.testProperties);
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getString("element3[@name]"));
    }

    @Test
    public void testSaveDelimiterParsingDisabled() throws ConfigurationException {
        this.checkSaveDelimiterParsingDisabled("list.delimiter.test");
    }

    @Test
    public void testSaveToStream() throws ConfigurationException, IOException {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        try (FileOutputStream out = new FileOutputStream(this.testSaveConf);){
            handler.save((OutputStream)out, "UTF8");
        }
        this.checkSavedConfig(this.testSaveConf);
    }

    @Test
    public void testSaveToStreamWithEncoding() throws ConfigurationException, IOException {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setEncoding("UTF8");
        try (FileOutputStream out = new FileOutputStream(this.testSaveConf);){
            handler.save((OutputStream)out);
        }
        this.checkSavedConfig(this.testSaveConf);
    }

    @Test
    public void testSaveToURL() throws Exception {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.save(this.testSaveConf.toURI().toURL());
        this.checkSavedConfig(this.testSaveConf);
    }

    @Test
    public void testSaveWindowsPath() throws ConfigurationException {
        this.conf.clear();
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        this.conf.addProperty("path", (Object)"C:\\Temp");
        StringWriter writer = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)writer);
        String content = writer.toString();
        MatcherAssert.assertThat((String)"Path not found: ", (Object)content, (Matcher)CoreMatchers.containsString((String)"<path>C:\\Temp</path>"));
        this.saveTestConfig();
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"C:\\Temp", (Object)conf2.getString("path"));
    }

    @Test
    public void testSaveWithDelimiterParsingDisabled() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        TestXMLConfiguration.load(this.conf, this.testProperties);
        Assertions.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split/list3/@values"));
        Assertions.assertEquals((int)0, (int)this.conf.getMaxIndex("split/list3/@values"));
        Assertions.assertEquals((Object)"a\\,b\\,c", (Object)this.conf.getString("split/list4/@values"));
        Assertions.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split/list1"));
        Assertions.assertEquals((int)0, (int)this.conf.getMaxIndex("split/list1"));
        Assertions.assertEquals((Object)"a\\,b\\,c", (Object)this.conf.getString("split/list2"));
        this.saveTestConfig();
        XMLConfiguration config = new XMLConfiguration();
        TestXMLConfiguration.load(config, this.testFile2);
        config.setProperty("Employee[@attr1]", (Object)"3,2,1");
        Assertions.assertEquals((Object)"3,2,1", (Object)config.getString("Employee[@attr1]"));
        new FileHandler((FileBased)config).save(this.testSaveFile);
        config = new XMLConfiguration();
        TestXMLConfiguration.load(config, this.testSaveFile.getAbsolutePath());
        config.setProperty("Employee[@attr1]", (Object)"1,2,3");
        Assertions.assertEquals((Object)"1,2,3", (Object)config.getString("Employee[@attr1]"));
        config.setProperty("Employee[@attr2]", (Object)"one, two, three");
        Assertions.assertEquals((Object)"one, two, three", (Object)config.getString("Employee[@attr2]"));
        config.setProperty("Employee.text", (Object)"a,b,d");
        Assertions.assertEquals((Object)"a,b,d", (Object)config.getString("Employee.text"));
        config.setProperty("Employee.Salary", (Object)"100,000");
        Assertions.assertEquals((Object)"100,000", (Object)config.getString("Employee.Salary"));
        new FileHandler((FileBased)config).save(this.testSaveFile);
        XMLConfiguration checkConfig = new XMLConfiguration();
        checkConfig.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        TestXMLConfiguration.load(checkConfig, this.testSaveFile.getAbsolutePath());
        Assertions.assertEquals((Object)"1,2,3", (Object)checkConfig.getString("Employee/@attr1"));
        Assertions.assertEquals((Object)"one, two, three", (Object)checkConfig.getString("Employee/@attr2"));
        Assertions.assertEquals((Object)"a,b,d", (Object)checkConfig.getString("Employee/text"));
        Assertions.assertEquals((Object)"100,000", (Object)checkConfig.getString("Employee/Salary"));
    }

    @Test
    public void testSaveWithDoctype() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, "testDtdPublic.xml");
        Assertions.assertEquals((Object)PUBLIC_ID, (Object)this.conf.getPublicID());
        Assertions.assertEquals((Object)SYSTEM_ID, (Object)this.conf.getSystemID());
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)out);
        MatcherAssert.assertThat((Object)out.toString(), (Matcher)CoreMatchers.containsString((String)DOCTYPE));
    }

    @Test
    public void testSaveWithDoctypeIDs() throws ConfigurationException {
        Assertions.assertNull((Object)this.conf.getPublicID());
        Assertions.assertNull((Object)this.conf.getSystemID());
        this.conf.setPublicID(PUBLIC_ID);
        this.conf.setSystemID(SYSTEM_ID);
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)out);
        MatcherAssert.assertThat((Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"<!DOCTYPE testconfig PUBLIC \"-//Commons Configuration//DTD Test Configuration 1.3//EN\" \"properties.dtd\">"));
    }

    @Test
    public void testSaveWithEncoding() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.setProperty("test", (Object)"a value");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setEncoding(ENCODING);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        MatcherAssert.assertThat((Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"encoding=\"ISO-8859-1\""));
    }

    @Test
    public void testSaveWithInvalidTransformerFactory() {
        System.setProperty(PROP_FACTORY, "an.invalid.Class");
        try {
            Assertions.assertThrows(TransformerFactoryConfigurationError.class, () -> this.saveTestConfig());
        }
        finally {
            System.getProperties().remove(PROP_FACTORY);
        }
    }

    @Test
    public void testSaveWithNullEncoding() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.setProperty("testNoEncoding", (Object)"yes");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        MatcherAssert.assertThat((String)"Encoding was written to file", (Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"encoding=\"UTF-"));
    }

    @Test
    public void testSaveWithRootAttributes() throws ConfigurationException {
        this.conf.setProperty("[@xmlns:ex]", (Object)"http://example.com/");
        Assertions.assertEquals((Object)"http://example.com/", (Object)this.conf.getString("[@xmlns:ex]"));
        FileHandler handler = new FileHandler((FileBased)this.conf);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        MatcherAssert.assertThat((String)"Encoding was not written to file", (Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"testconfig xmlns:ex=\"http://example.com/\""));
    }

    @Test
    public void testSaveWithRootAttributes_ByHand() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.addProperty("[@xmlns:foo]", (Object)"http://example.com/");
        Assertions.assertEquals((Object)"http://example.com/", (Object)this.conf.getString("[@xmlns:foo]"));
        FileHandler handler = new FileHandler((FileBased)this.conf);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        MatcherAssert.assertThat((String)"Encoding was not written to file", (Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"configuration xmlns:foo=\"http://example.com/\""));
    }

    @Test
    public void testSaveWithValidation() throws Exception {
        CatalogResolver resolver = new CatalogResolver();
        resolver.setCatalogFiles(CATALOG_FILES);
        this.conf = new XMLConfiguration();
        this.conf.setEntityResolver((EntityResolver)resolver);
        this.conf.setSchemaValidation(true);
        TestXMLConfiguration.load(this.conf, this.testFile2);
        this.conf.setProperty("Employee.SSN", (Object)"123456789");
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.validate();
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals((Object)"123456789", (Object)this.conf.getString("Employee.SSN"));
    }

    @Test
    public void testSaveWithValidationFailure() throws Exception {
        CatalogResolver resolver = new CatalogResolver();
        resolver.setCatalogFiles(CATALOG_FILES);
        this.conf = new XMLConfiguration();
        this.conf.setEntityResolver((EntityResolver)resolver);
        this.conf.setSchemaValidation(true);
        TestXMLConfiguration.load(this.conf, this.testFile2);
        this.conf.setProperty("Employee.Email", (Object)"JohnDoe@test.org");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> ((XMLConfiguration)this.conf).validate());
        Throwable cause = e.getCause();
        Assertions.assertInstanceOf(SAXParseException.class, (Object)cause);
    }

    @Test
    public void testSetAttribute() {
        this.conf.setProperty("element3[@name]", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)this.conf.getProperty("element3[@name]"));
        this.conf.setProperty("foo[@bar]", (Object)"value");
        Assertions.assertEquals((Object)"value", (Object)this.conf.getProperty("foo[@bar]"));
        this.conf.setProperty("name1", (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)this.conf.getProperty("name1"));
    }

    @Test
    public void testSetProperty() throws Exception {
        this.conf.setProperty("element.string", (Object)"hello");
        Assertions.assertEquals((Object)"hello", (Object)this.conf.getString("element.string"));
        Assertions.assertEquals((Object)"hello", (Object)this.conf.getProperty("element.string"));
    }

    @Test
    public void testSetPropertyListWithDelimiterParsingDisabled() throws ConfigurationException {
        String prop = "delimiterListProp";
        List<String> list = Arrays.asList("val", "val2", "val3");
        this.conf.setProperty("delimiterListProp", list);
        this.saveTestConfig();
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assertions.assertEquals(list, (Object)conf2.getProperty("delimiterListProp"));
    }

    @Test
    public void testSetRootAttribute() throws ConfigurationException {
        this.conf.setProperty("[@test]", (Object)"true");
        Assertions.assertEquals((Object)"true", (Object)this.conf.getString("[@test]"));
        this.saveTestConfig();
        XMLConfiguration checkConf = this.checkSavedConfig();
        Assertions.assertTrue((boolean)checkConf.containsKey("[@test]"));
        checkConf.setProperty("[@test]", (Object)"newValue");
        this.conf = checkConf;
        this.saveTestConfig();
        checkConf = this.checkSavedConfig();
        Assertions.assertEquals((Object)"newValue", (Object)checkConf.getString("[@test]"));
    }

    @Test
    public void testSetRootNamespace() throws ConfigurationException {
        this.conf.addProperty("[@xmlns:foo]", (Object)"http://example.com/");
        this.conf.addProperty("foo:bar", (Object)"foobar");
        Assertions.assertEquals((Object)"http://example.com/", (Object)this.conf.getString("[@xmlns:foo]"));
        this.saveTestConfig();
        XMLConfiguration checkConf = this.checkSavedConfig();
        Assertions.assertTrue((boolean)checkConf.containsKey("[@xmlns:foo]"));
        checkConf.setProperty("[@xmlns:foo]", (Object)"http://example.net/");
    }

    @Test
    public void testSetTextRootElement() throws ConfigurationException {
        this.conf.setProperty("", (Object)"Root text");
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test
    public void testSplitLists() {
        Assertions.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split.list3[@values]"));
        Assertions.assertEquals((int)0, (int)this.conf.getMaxIndex("split.list3[@values]"));
        Assertions.assertEquals((Object)"a\\,b\\,c", (Object)this.conf.getString("split.list4[@values]"));
        Assertions.assertEquals((Object)"a", (Object)this.conf.getString("split.list1"));
        Assertions.assertEquals((int)2, (int)this.conf.getMaxIndex("split.list1"));
        Assertions.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split.list2"));
    }

    @Test
    public void testSubset() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, "testHierarchicalXMLConfiguration.xml");
        this.conf.subset("tables.table(0)");
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, "testHierarchicalXMLConfiguration.xml");
        Assertions.assertEquals((Object)"users", (Object)this.conf.getString("tables.table(0).name"));
    }

    @Test
    public void testSystemIdSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.setSystemID(SYSTEM_ID);
        Assertions.assertEquals((Object)SYSTEM_ID, (Object)this.conf.getSystemID());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE, SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testValidating() throws ConfigurationException {
        File nonValidFile = ConfigurationAssert.getTestFile("testValidateInvalid.xml");
        this.conf = new XMLConfiguration();
        Assertions.assertFalse((boolean)this.conf.isValidating());
        TestXMLConfiguration.load(this.conf, nonValidFile.getAbsolutePath());
        Assertions.assertEquals((Object)"customers", (Object)this.conf.getString("table.name"));
        Assertions.assertFalse((boolean)this.conf.containsKey("table.fields.field(1).type"));
    }

    @Test
    public void testValidatingInvalidFile() {
        this.conf = new XMLConfiguration();
        this.conf.setValidating(true);
        Assertions.assertThrows(ConfigurationException.class, () -> TestXMLConfiguration.load(this.conf, "testValidateInvalid.xml"));
    }

    @Test
    public void testWrite() throws Exception {
        XMLConfiguration xmlConfig = new XMLConfiguration();
        xmlConfig.setRootElementName("IAmRoot");
        StringWriter sw = new StringWriter();
        xmlConfig.write((Writer)sw);
        Assertions.assertNotNull((Object)this.parseXml(sw.toString()));
    }

    @Test
    public void testWriteIndentSize() throws Exception {
        XMLConfiguration xmlConfig = new XMLConfiguration();
        xmlConfig.setRootElementName("IAmRoot");
        StringWriter sw = new StringWriter();
        xmlConfig.setProperty("Child", (Object)"Alexander");
        xmlConfig.write((Writer)sw);
        String xml = sw.toString();
        Assertions.assertNotNull((Object)this.parseXml(xml));
        String indent = StringUtils.repeat((char)' ', (int)2);
        Assertions.assertTrue((boolean)xml.contains(System.lineSeparator() + indent + "<Child>"));
    }

    @Test
    public void testWriteWithTransformer() throws Exception {
        XMLConfiguration xmlConfig = new XMLConfiguration();
        xmlConfig.setRootElementName("IAmRoot");
        xmlConfig.setProperty("Child", (Object)"Alexander");
        StringWriter sw = new StringWriter();
        Transformer transformer = xmlConfig.createTransformer();
        int indentSize = 8;
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(8));
        xmlConfig.write((Writer)sw, transformer);
        String xml = sw.toString();
        Assertions.assertNotNull((Object)this.parseXml(xml));
        String indent = StringUtils.repeat((char)' ', (int)8);
        Assertions.assertTrue((boolean)xml.contains(System.lineSeparator() + indent + "<Child>"));
    }

    @Test
    public void testXPathExpressionEngine() {
        this.conf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        Assertions.assertEquals((Object)"foo\"bar", (Object)this.conf.getString("test[1]/entity/@name"));
        this.conf.clear();
        Assertions.assertNull((Object)this.conf.getString("test[1]/entity/@name"));
    }

    private static class ReloadThread
    extends Thread {
        private final FileBasedConfigurationBuilder<?> builder;

        ReloadThread(FileBasedConfigurationBuilder<?> confBulder) {
            this.builder = confBulder;
        }

        @Override
        public void run() {
            for (int i = 0; i < 100; ++i) {
                this.builder.resetResult();
            }
        }
    }
}

