/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConfigurationSet {
    ConfigurationMap.ConfigurationSet set;
    String[] properties = new String[]{"booleanProperty", "doubleProperty", "floatProperty", "intProperty", "longProperty", "shortProperty", "stringProperty"};
    Object[] values = new Object[]{Boolean.TRUE, Double.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Integer.MAX_VALUE, Long.MAX_VALUE, (short)Short.MAX_VALUE, "This is a string"};

    @BeforeEach
    public void setUp() throws Exception {
        BaseConfiguration configuration = new BaseConfiguration();
        for (int i = 0; i < this.properties.length; ++i) {
            configuration.setProperty(this.properties[i], this.values[i]);
        }
        this.set = new ConfigurationMap.ConfigurationSet((Configuration)configuration);
    }

    @AfterEach
    public void tearDown() {
        this.set = null;
    }

    @Test
    public void testIterator() {
        Iterator iterator = this.set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            boolean found = false;
            for (int i = 0; i < this.properties.length; ++i) {
                if (!entry.getKey().equals(this.properties[i])) continue;
                Assertions.assertEquals((Object)this.values[i], entry.getValue(), (String)("Incorrect value for property " + this.properties[i]));
                found = true;
            }
            Assertions.assertTrue((boolean)found, (String)("Could not find property " + entry.getKey()));
            iterator.remove();
        }
        Assertions.assertTrue((boolean)this.set.isEmpty());
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)this.properties.length, (int)this.set.size());
    }
}

