/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConfigurationMap {
    ConfigurationMap map;
    String[] properties = new String[]{"booleanProperty", "doubleProperty", "floatProperty", "intProperty", "longProperty", "shortProperty", "stringProperty"};
    Object[] values = new Object[]{Boolean.TRUE, Double.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Integer.MAX_VALUE, Long.MAX_VALUE, (short)Short.MAX_VALUE, "This is a string"};

    @BeforeEach
    public void setUp() throws Exception {
        BaseConfiguration configuration = new BaseConfiguration();
        for (int i = 0; i < this.properties.length; ++i) {
            configuration.setProperty(this.properties[i], this.values[i]);
        }
        this.map = new ConfigurationMap((Configuration)configuration);
    }

    @AfterEach
    public void tearDown() {
        this.map = null;
    }

    @Test
    public void testPut() {
        for (int i = 0; i < this.properties.length; ++i) {
            Object object = this.map.put((Object)this.properties[i], this.values[i]);
            Assertions.assertNotNull((Object)object);
            Assertions.assertEquals((Object)this.values[i], (Object)object);
            object = this.map.get((Object)this.properties[i]);
            Assertions.assertNotNull((Object)object);
            Assertions.assertEquals((Object)this.values[i], (Object)object);
        }
    }
}

