/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.junit.jupiter.api.Assertions;

public class InterpolationTestHelper {
    public static void testGetInterpolator(AbstractConfiguration config) {
        config.addProperty("var", (Object)"${echo:testVar}");
        ConfigurationInterpolator interpol = config.getInterpolator();
        interpol.registerLookup("echo", varName -> "Value of variable " + varName);
        Assertions.assertEquals((Object)"Value of variable testVar", (Object)config.getString("var"));
    }

    public static Configuration testInterpolatedConfiguration(AbstractConfiguration config) {
        config.setProperty("applicationRoot", (Object)"/home/applicationRoot");
        config.setProperty("db", (Object)"${applicationRoot}/db/hypersonic");
        config.setProperty("inttest.interpol", (Object)"${unknown.property}");
        config.setProperty("intkey.code", (Object)"${const:java.awt.event.KeyEvent.VK_CANCEL}");
        config.setProperty("inttest.sysprop", (Object)"${sys:java.version}");
        config.setProperty("inttest.numvalue", (Object)"3\\,1415");
        config.setProperty("inttest.value", (Object)"${inttest.numvalue}");
        config.setProperty("inttest.list", (Object)"${db}");
        config.addProperty("inttest.list", (Object)"${inttest.value}");
        Configuration c = config.interpolatedConfiguration();
        Assertions.assertEquals((Object)"/home/applicationRoot/db/hypersonic", (Object)c.getProperty("db"));
        Assertions.assertEquals((int)3, (int)c.getInt("intkey.code"));
        Assertions.assertEquals((Object)System.getProperty("java.version"), (Object)c.getProperty("inttest.sysprop"));
        Assertions.assertEquals((Object)"3,1415", (Object)c.getProperty("inttest.value"));
        List lst = (List)c.getProperty("inttest.list");
        Assertions.assertEquals(Arrays.asList("/home/applicationRoot/db/hypersonic", "3,1415"), (Object)lst);
        Assertions.assertEquals((Object)"${unknown.property}", (Object)c.getProperty("inttest.interpol"));
        return c;
    }

    public static void testInterpolation(Configuration config) {
        config.setProperty("applicationRoot", (Object)"/home/applicationRoot");
        config.setProperty("db", (Object)"${applicationRoot}/db/hypersonic");
        String unInterpolatedValue = "${applicationRoot2}/db/hypersonic";
        config.setProperty("dbFailedInterpolate", (Object)"${applicationRoot2}/db/hypersonic");
        String dbProp = "/home/applicationRoot/db/hypersonic";
        Assertions.assertEquals((Object)"/home/applicationRoot/db/hypersonic", (Object)config.getString("db"));
        Assertions.assertEquals((Object)"${applicationRoot2}/db/hypersonic", (Object)config.getString("dbFailedInterpolate"));
        config.setProperty("arrayInt", (Object)"${applicationRoot}/1");
        String[] arrayInt = config.getStringArray("arrayInt");
        Assertions.assertEquals((Object)"/home/applicationRoot/1", (Object)arrayInt[0]);
        config.addProperty("path", Arrays.asList("/temp", "C:\\Temp", "/usr/local/tmp"));
        config.setProperty("path.current", (Object)"${path}");
        Assertions.assertEquals((Object)"/temp", (Object)config.getString("path.current"));
    }

    public static void testInterpolationConstants(Configuration config) {
        config.addProperty("key.code", (Object)"${const:java.awt.event.KeyEvent.VK_CANCEL}");
        Assertions.assertEquals((int)3, (int)config.getInt("key.code"));
        Assertions.assertEquals((int)3, (int)config.getInt("key.code"));
    }

    public static void testInterpolationEnvironment(Configuration config) {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> e : env.entrySet()) {
            config.addProperty("prop" + e.getKey(), (Object)("${env:" + e.getKey() + "}"));
        }
        for (Map.Entry<String, String> e : env.entrySet()) {
            Assertions.assertEquals((Object)e.getValue(), (Object)config.getString("prop" + e.getKey()), (String)("Wrong value for environment property " + e.getKey()));
        }
    }

    public static void testInterpolationEscaped(Configuration config) {
        config.addProperty("var", (Object)"x");
        config.addProperty("escVar", (Object)"Use the variable $${${var}}.");
        Assertions.assertEquals((Object)"Use the variable ${x}.", (Object)config.getString("escVar"));
    }

    public static void testInterpolationLocalhost(Configuration config) {
        int i;
        String[] localhostKeys = new String[]{"name", "canonical-name", "address"};
        InetAddress localHost = (InetAddress)Assertions.assertDoesNotThrow(InetAddress::getLocalHost);
        String[] localhostValues = new String[]{localHost.getHostName(), localHost.getCanonicalHostName(), localHost.getHostAddress()};
        for (i = 0; i < localhostKeys.length; ++i) {
            config.addProperty("prop" + i, (Object)("${localhost:" + localhostKeys[i] + "}"));
        }
        for (i = 0; i < localhostKeys.length; ++i) {
            Assertions.assertEquals((Object)localhostValues[i], (Object)config.getString("prop" + i), (String)("Wrong value for system property " + localhostKeys[i]));
        }
    }

    public static void testInterpolationLoop(Configuration config) {
        config.setProperty("test.a", (Object)"${test.b}");
        config.setProperty("test.b", (Object)"${test.a}");
        Assertions.assertThrows(IllegalStateException.class, () -> config.getString("test.a"));
    }

    public static void testInterpolationSubset(Configuration config) {
        config.addProperty("test.a", (Object)42);
        config.addProperty("test.b", (Object)"${test.a}");
        Assertions.assertEquals((int)42, (int)config.getInt("test.b"));
        Configuration subset = config.subset("test");
        Assertions.assertEquals((Object)"42", (Object)subset.getString("b"));
        Assertions.assertEquals((int)42, (int)subset.getInt("b"));
    }

    public static void testInterpolationSystemProperties(Configuration config) {
        int i;
        String[] sysProperties = new String[]{"java.version", "java.vendor", "os.name", "java.class.path"};
        for (i = 0; i < sysProperties.length; ++i) {
            config.addProperty("prop" + i, (Object)("${sys:" + sysProperties[i] + "}"));
        }
        for (i = 0; i < sysProperties.length; ++i) {
            Assertions.assertEquals((Object)System.getProperty(sysProperties[i]), (Object)config.getString("prop" + i), (String)("Wrong value for system property " + sysProperties[i]));
        }
    }

    public static void testInterpolationUnknownProperty(Configuration config) {
        config.addProperty("test.interpol", (Object)"${unknown.property}");
        Assertions.assertEquals((Object)"${unknown.property}", (Object)config.getString("test.interpol"));
    }

    public static void testMultipleInterpolation(Configuration config) {
        config.setProperty("test.base-level", (Object)"/base-level");
        config.setProperty("test.first-level", (Object)"${test.base-level}/first-level");
        config.setProperty("test.second-level", (Object)"${test.first-level}/second-level");
        config.setProperty("test.third-level", (Object)"${test.second-level}/third-level");
        String expectedValue = "/base-level/first-level/second-level/third-level";
        Assertions.assertEquals((Object)"/base-level/first-level/second-level/third-level", (Object)config.getString("test.third-level"));
    }
}

