/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.tree.ConfigurationNodeVisitor;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.NodeTreeWalker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestNodeTreeWalker {
    private static NodeHandler<ImmutableNode> createHandler() {
        return new InMemoryNodeModel().getNodeHandler();
    }

    private static NodeHandler<ImmutableNode> handlerMock() {
        return (NodeHandler)Mockito.mock(NodeHandler.class);
    }

    private static String visitAfterName(String name) {
        return "->" + name;
    }

    private static ConfigurationNodeVisitor<ImmutableNode> visitorMock() {
        return (ConfigurationNodeVisitor)Mockito.mock(ConfigurationNodeVisitor.class);
    }

    private List<String> expectBFS() {
        LinkedList<String> expected = new LinkedList<String>();
        LinkedList<String> works = new LinkedList<String>();
        LinkedList<String> personae = new LinkedList<String>();
        expected.add(NodeStructureHelper.ROOT_AUTHORS_TREE.getNodeName());
        for (int authorIdx = 0; authorIdx < NodeStructureHelper.authorsLength(); ++authorIdx) {
            expected.add(NodeStructureHelper.author(authorIdx));
            for (int workIdx = 0; workIdx < NodeStructureHelper.worksLength(authorIdx); ++workIdx) {
                works.add(NodeStructureHelper.work(authorIdx, workIdx));
                for (int personIdx = 0; personIdx < NodeStructureHelper.personaeLength(authorIdx, workIdx); ++personIdx) {
                    personae.add(NodeStructureHelper.persona(authorIdx, workIdx, personIdx));
                }
            }
        }
        expected.addAll(works);
        expected.addAll(personae);
        return expected;
    }

    private List<String> expectDFS() {
        LinkedList<String> expected = new LinkedList<String>();
        expected.add(NodeStructureHelper.ROOT_AUTHORS_TREE.getNodeName());
        for (int authorIdx = 0; authorIdx < NodeStructureHelper.authorsLength(); ++authorIdx) {
            expected.add(NodeStructureHelper.author(authorIdx));
            for (int workIdx = 0; workIdx < NodeStructureHelper.worksLength(authorIdx); ++workIdx) {
                expected.add(NodeStructureHelper.work(authorIdx, workIdx));
                for (int personaIdx = 0; personaIdx < NodeStructureHelper.personaeLength(authorIdx, workIdx); ++personaIdx) {
                    String persona = NodeStructureHelper.persona(authorIdx, workIdx, personaIdx);
                    expected.add(persona);
                    expected.add(TestNodeTreeWalker.visitAfterName(persona));
                }
                expected.add(TestNodeTreeWalker.visitAfterName(NodeStructureHelper.work(authorIdx, workIdx)));
            }
            expected.add(TestNodeTreeWalker.visitAfterName(NodeStructureHelper.author(authorIdx)));
        }
        expected.add(TestNodeTreeWalker.visitAfterName(NodeStructureHelper.ROOT_AUTHORS_TREE.getNodeName()));
        return expected;
    }

    @Test
    public void testWalkBFS() {
        List<String> expected = this.expectBFS();
        TestVisitor visitor = new TestVisitor();
        NodeTreeWalker.INSTANCE.walkBFS((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (ConfigurationNodeVisitor)visitor, TestNodeTreeWalker.createHandler());
        Assertions.assertEquals(expected, visitor.getVisitedNodes());
    }

    @Test
    public void testWalkBFSNoNode() {
        ConfigurationNodeVisitor<ImmutableNode> visitor = TestNodeTreeWalker.visitorMock();
        NodeHandler<ImmutableNode> handler = TestNodeTreeWalker.handlerMock();
        NodeTreeWalker.INSTANCE.walkBFS(null, visitor, handler);
    }

    @Test
    public void testWalkBFSTerminate() {
        TestVisitor visitor = new TestVisitor();
        int nodeCount = 9;
        visitor.setMaxNodeCount(9);
        NodeTreeWalker.INSTANCE.walkBFS((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (ConfigurationNodeVisitor)visitor, TestNodeTreeWalker.createHandler());
        Assertions.assertEquals((int)9, (int)visitor.getVisitedNodes().size());
    }

    @Test
    public void testWalkDFS() {
        List<String> expected = this.expectDFS();
        TestVisitor visitor = new TestVisitor();
        NodeTreeWalker.INSTANCE.walkDFS((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (ConfigurationNodeVisitor)visitor, TestNodeTreeWalker.createHandler());
        Assertions.assertEquals(expected, visitor.getVisitedNodes());
    }

    @Test
    public void testWalkDFSNoNode() {
        ConfigurationNodeVisitor<ImmutableNode> visitor = TestNodeTreeWalker.visitorMock();
        NodeHandler<ImmutableNode> handler = TestNodeTreeWalker.handlerMock();
        NodeTreeWalker.INSTANCE.walkDFS(null, visitor, handler);
    }

    @Test
    public void testWalkDFSTerminate() {
        TestVisitor visitor = new TestVisitor();
        int nodeCount = 5;
        visitor.setMaxNodeCount(5);
        NodeTreeWalker.INSTANCE.walkDFS((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (ConfigurationNodeVisitor)visitor, TestNodeTreeWalker.createHandler());
        Assertions.assertEquals((int)5, (int)visitor.getVisitedNodes().size());
    }

    @Test
    public void testWalkNoNodeHandler() {
        TestVisitor visitor = new TestVisitor();
        Assertions.assertThrows(IllegalArgumentException.class, () -> NodeTreeWalker.INSTANCE.walkDFS((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (ConfigurationNodeVisitor)visitor, null));
    }

    @Test
    public void testWalkNoVisitor() {
        NodeHandler<ImmutableNode> handler = TestNodeTreeWalker.createHandler();
        Assertions.assertThrows(IllegalArgumentException.class, () -> NodeTreeWalker.INSTANCE.walkDFS((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, null, handler));
    }

    private static class TestVisitor
    implements ConfigurationNodeVisitor<ImmutableNode> {
        private final List<String> visitedNodes = new LinkedList<String>();
        private int maxNodeCount = Integer.MAX_VALUE;

        private TestVisitor() {
        }

        public int getMaxNodeCount() {
            return this.maxNodeCount;
        }

        public List<String> getVisitedNodes() {
            return this.visitedNodes;
        }

        public void setMaxNodeCount(int maxNodeCount) {
            this.maxNodeCount = maxNodeCount;
        }

        public boolean terminate() {
            return this.visitedNodes.size() >= this.getMaxNodeCount();
        }

        public void visitAfterChildren(ImmutableNode node, NodeHandler<ImmutableNode> handler) {
            this.visitedNodes.add(TestNodeTreeWalker.visitAfterName(handler.nodeName((Object)node)));
        }

        public void visitBeforeChildren(ImmutableNode node, NodeHandler<ImmutableNode> handler) {
            this.visitedNodes.add(handler.nodeName((Object)node));
        }
    }
}

