/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration2.event.BaseEventSource;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.ErrorListenerTestImpl;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerRegistrationData;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.event.EventType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestEventSource {
    private static final Object TEST_PROPVALUE = "a test property value";
    private final String TEST_PROPNAME = "test.property.name";
    private CountingEventSource source;

    @BeforeEach
    public void setUp() throws Exception {
        this.source = new CountingEventSource();
    }

    @Test
    public void testAddEventListener() {
        EventListenerTestImpl l = new EventListenerTestImpl(this);
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        Collection listeners = this.source.getEventListeners(ConfigurationEvent.ANY);
        Assertions.assertEquals((int)1, (int)listeners.size());
        Assertions.assertTrue((boolean)listeners.contains(l));
    }

    @Test
    public void testAddNullEventListener() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.source.addEventListener(ConfigurationEvent.ANY, null));
    }

    @Test
    public void testClearErrorListeners() {
        EventListenerTestImpl cl = new EventListenerTestImpl(null);
        ErrorListenerTestImpl el1 = new ErrorListenerTestImpl(null);
        ErrorListenerTestImpl el2 = new ErrorListenerTestImpl(null);
        ErrorListenerTestImpl el3 = new ErrorListenerTestImpl(null);
        this.source.addEventListener(ConfigurationErrorEvent.READ, el1);
        this.source.addEventListener(ConfigurationErrorEvent.ANY, el2);
        this.source.addEventListener(ConfigurationEvent.ANY, cl);
        this.source.addEventListener(ConfigurationErrorEvent.WRITE, el3);
        this.source.clearErrorListeners();
        List regs = this.source.getEventListenerRegistrations();
        Assertions.assertEquals((int)1, (int)regs.size());
        Assertions.assertSame((Object)cl, (Object)((EventListenerRegistrationData)regs.get(0)).getListener());
    }

    @Test
    public void testClearEventListeners() {
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(this.source));
        this.source.addEventListener(ConfigurationEvent.ANY_HIERARCHICAL, new EventListenerTestImpl(this.source));
        this.source.clearEventListeners();
        Assertions.assertTrue((boolean)this.source.getEventListeners(ConfigurationEvent.ANY).isEmpty());
        Assertions.assertTrue((boolean)this.source.getEventListeners(ConfigurationEvent.ANY_HIERARCHICAL).isEmpty());
    }

    @Test
    public void testClone() throws CloneNotSupportedException {
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(this.source));
        BaseEventSource copy = (BaseEventSource)this.source.clone();
        Assertions.assertTrue((boolean)copy.getEventListenerRegistrations().isEmpty());
    }

    @Test
    public void testCopyEventListeners() {
        EventListenerTestImpl l1 = new EventListenerTestImpl(this.source);
        EventListenerTestImpl l2 = new EventListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationEvent.ANY, l1);
        this.source.addEventListener(ConfigurationEvent.ANY_HIERARCHICAL, l2);
        BaseEventSource source2 = new BaseEventSource();
        this.source.copyEventListeners(source2);
        Collection listeners = source2.getEventListeners(ConfigurationEvent.ANY_HIERARCHICAL);
        Assertions.assertEquals((int)2, (int)listeners.size());
        Assertions.assertTrue((boolean)listeners.contains(l1));
        Assertions.assertTrue((boolean)listeners.contains(l2));
        listeners = source2.getEventListeners(ConfigurationEvent.ANY);
        Assertions.assertEquals((int)1, (int)listeners.size());
        Assertions.assertTrue((boolean)listeners.contains(l1));
    }

    @Test
    public void testCopyEventListenersNullSource() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.source.copyEventListeners(null));
    }

    @Test
    public void testFireError() {
        ErrorListenerTestImpl lstRead = new ErrorListenerTestImpl(this.source);
        ErrorListenerTestImpl lstWrite = new ErrorListenerTestImpl(this.source);
        ErrorListenerTestImpl lstAll = new ErrorListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationErrorEvent.READ, lstRead);
        this.source.addEventListener(ConfigurationErrorEvent.WRITE, lstWrite);
        this.source.addEventListener(ConfigurationErrorEvent.ANY, lstAll);
        Exception testException = new Exception("A test");
        this.source.fireError(ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, testException);
        lstRead.done();
        Assertions.assertEquals((Object)testException, (Object)lstWrite.checkEvent(ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE));
        lstWrite.done();
        Assertions.assertEquals((Object)testException, (Object)lstAll.checkEvent(ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE));
        lstAll.done();
        Assertions.assertEquals((int)1, (int)this.source.errorCount);
    }

    @Test
    public void testFireErrorNoListeners() {
        this.source.fireError(ConfigurationErrorEvent.ANY, ConfigurationEvent.ANY, "test.property.name", TEST_PROPVALUE, new Exception());
        Assertions.assertEquals((int)0, (int)this.source.errorCount);
    }

    @Test
    public void testFireEvent() {
        EventListenerTestImpl l = new EventListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        this.source.fireEvent(ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, true);
        l.checkEvent(ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, true);
        l.done();
    }

    @Test
    public void testFireEventNoDetails() {
        EventListenerTestImpl l = new EventListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        this.source.setDetailEvents(false);
        this.source.fireEvent(ConfigurationEvent.SET_PROPERTY, "test.property.name", TEST_PROPVALUE, false);
        Assertions.assertEquals((int)0, (int)this.source.eventCount);
        l.done();
    }

    @Test
    public void testFireEventNoListeners() {
        this.source.fireEvent(ConfigurationEvent.ADD_NODES, "test.property.name", TEST_PROPVALUE, false);
        Assertions.assertEquals((int)0, (int)this.source.eventCount);
    }

    @Test
    public void testGetEventListenersAddNew() {
        Collection list = this.source.getEventListeners(ConfigurationEvent.ANY);
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null));
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testGetEventListenersUpdate() {
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null));
        Collection list = this.source.getEventListeners(ConfigurationEvent.ANY);
        Assertions.assertThrows(UnsupportedOperationException.class, list::clear);
    }

    @Test
    public void testInit() {
        Assertions.assertTrue((boolean)this.source.getEventListenerRegistrations().isEmpty());
        Assertions.assertFalse((boolean)this.source.removeEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null)));
        Assertions.assertFalse((boolean)this.source.isDetailEvents());
    }

    @Test
    public void testRemoveEventListener() {
        EventListenerTestImpl l = new EventListenerTestImpl(this);
        Assertions.assertFalse((boolean)this.source.removeEventListener(ConfigurationEvent.ANY, l));
        this.source.addEventListener(ConfigurationEvent.ADD_NODES, new EventListenerTestImpl(this));
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        Assertions.assertFalse((boolean)this.source.removeEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null)));
        Assertions.assertTrue((boolean)this.source.removeEventListener(ConfigurationEvent.ANY, l));
        Assertions.assertFalse((boolean)this.source.getEventListeners(ConfigurationEvent.ANY).contains(l));
    }

    @Test
    public void testRemoveListenerInFireEvent() {
        EventListener<ConfigurationEvent> lstRemove = new EventListener<ConfigurationEvent>(){

            public void onEvent(ConfigurationEvent event) {
                TestEventSource.this.source.removeEventListener(ConfigurationEvent.ANY, this);
            }
        };
        this.source.addEventListener(ConfigurationEvent.ANY, (EventListener)lstRemove);
        EventListenerTestImpl l = new EventListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        this.source.fireEvent(ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, false);
        l.checkEvent(ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, false);
        Assertions.assertEquals((int)1, (int)this.source.getEventListeners(ConfigurationEvent.ANY).size());
    }

    @Test
    public void testRemoveNullEventListener() {
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null));
        Assertions.assertFalse((boolean)this.source.removeEventListener(ConfigurationEvent.ANY, null));
        Assertions.assertEquals((int)1, (int)this.source.getEventListeners(ConfigurationEvent.ANY).size());
    }

    @Test
    public void testSetDetailEvents() {
        this.source.setDetailEvents(true);
        Assertions.assertTrue((boolean)this.source.isDetailEvents());
        this.source.setDetailEvents(true);
        this.source.setDetailEvents(false);
        Assertions.assertTrue((boolean)this.source.isDetailEvents());
        this.source.setDetailEvents(false);
        Assertions.assertFalse((boolean)this.source.isDetailEvents());
    }

    private static class CountingEventSource
    extends BaseEventSource
    implements Cloneable {
        int eventCount;
        int errorCount;

        private CountingEventSource() {
        }

        protected ConfigurationErrorEvent createErrorEvent(EventType<? extends ConfigurationErrorEvent> type, EventType<?> opType, String propName, Object propValue, Throwable ex) {
            ++this.errorCount;
            return super.createErrorEvent(type, opType, propName, propValue, ex);
        }

        protected <T extends ConfigurationEvent> ConfigurationEvent createEvent(EventType<T> eventType, String propName, Object propValue, boolean before) {
            ++this.eventCount;
            return super.createEvent(eventType, propName, propValue, before);
        }
    }
}

