/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.fluent;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.configuration2.ConfigurationConsumer;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BasicBuilderProperties;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.DefaultParametersHandler;
import org.apache.commons.configuration2.builder.DefaultParametersManager;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.CombinedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.MultiFileBuilderParametersImpl;
import org.apache.commons.configuration2.builder.fluent.CombinedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.DatabaseBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.HierarchicalBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.JndiBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.MultiFileBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestParameters {
    private static final String DEF_ENCODING = "UTF-8";
    private static ListDelimiterHandler listHandler;

    private static void checkBasicProperties(Map<String, Object> map) {
        Assertions.assertEquals((Object)listHandler, (Object)map.get("listDelimiterHandler"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)map.get("throwExceptionOnMissing"));
    }

    private static void checkInheritance(Object params, Class<?> ... ifcClasses) {
        Assertions.assertInstanceOf(BasicBuilderProperties.class, (Object)params);
        for (Class<?> c : ifcClasses) {
            Assertions.assertInstanceOf(c, (Object)params);
        }
    }

    private static DefaultParametersHandler<XMLBuilderParameters> createHandlerMock() {
        return (DefaultParametersHandler)Mockito.mock(DefaultParametersHandler.class);
    }

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        listHandler = (ListDelimiterHandler)Mockito.mock(ListDelimiterHandler.class);
    }

    @Test
    public void testApplyDefaults() {
        DefaultParametersManager manager = (DefaultParametersManager)Mockito.mock(DefaultParametersManager.class);
        ArrayList initializedParams = new ArrayList(1);
        ((DefaultParametersManager)Mockito.doAnswer(invocation -> {
            initializedParams.add(invocation.getArgument(0));
            return null;
        }).when((Object)manager)).initializeParameters((BuilderParameters)ArgumentMatchers.any());
        Parameters params = new Parameters(manager);
        XMLBuilderParameters xmlParams = params.xml();
        Assertions.assertEquals((int)1, (int)initializedParams.size());
        Assertions.assertSame((Object)xmlParams, initializedParams.get(0));
        ((DefaultParametersManager)Mockito.verify((Object)manager)).initializeParameters((BuilderParameters)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
    }

    @Test
    public void testBasic() {
        BasicBuilderParameters basic = new Parameters().basic();
        Assertions.assertNotNull((Object)basic);
    }

    @Test
    public void testCombined() {
        Map map = ((CombinedBuilderParameters)((CombinedBuilderParameters)((CombinedBuilderParameters)new Parameters().combined().setThrowExceptionOnMissing(true)).setBasePath("test")).setListDelimiterHandler(listHandler)).getParameters();
        CombinedBuilderParametersImpl cparams = CombinedBuilderParametersImpl.fromParameters((Map)map);
        Assertions.assertEquals((Object)"test", (Object)cparams.getBasePath());
        TestParameters.checkBasicProperties(map);
    }

    @Test
    public void testDatabase() {
        Map map = ((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)new Parameters().database().setThrowExceptionOnMissing(true)).setAutoCommit(true)).setTable("table")).setListDelimiterHandler(listHandler)).setKeyColumn("keyColumn")).getParameters();
        TestParameters.checkBasicProperties(map);
        Assertions.assertEquals((Object)"table", map.get("table"));
        Assertions.assertEquals((Object)"keyColumn", map.get("keyColumn"));
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("autoCommit"));
    }

    @Test
    public void testDefaultParametersManager() {
        Parameters parameters = new Parameters();
        Assertions.assertNotNull((Object)parameters.getDefaultParametersManager());
    }

    @Test
    public void testFileBased() {
        Map map = ((FileBasedBuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setThrowExceptionOnMissing(true)).setEncoding(DEF_ENCODING)).setListDelimiterHandler(listHandler)).setFileName("test.xml")).getParameters();
        FileBasedBuilderParametersImpl fbparams = FileBasedBuilderParametersImpl.fromParameters((Map)map);
        Assertions.assertEquals((Object)"test.xml", (Object)fbparams.getFileHandler().getFileName());
        Assertions.assertEquals((Object)DEF_ENCODING, (Object)fbparams.getFileHandler().getEncoding());
        TestParameters.checkBasicProperties(map);
    }

    @Test
    public void testFileBasedInheritance() {
        TestParameters.checkInheritance(new Parameters().fileBased(), new Class[0]);
    }

    @Test
    public void testHierarchical() {
        ExpressionEngine engine = (ExpressionEngine)Mockito.mock(ExpressionEngine.class);
        Map map = ((HierarchicalBuilderParameters)((HierarchicalBuilderParameters)((HierarchicalBuilderParameters)((HierarchicalBuilderParameters)new Parameters().hierarchical().setThrowExceptionOnMissing(true)).setExpressionEngine(engine)).setFileName("test.xml")).setListDelimiterHandler(listHandler)).getParameters();
        TestParameters.checkBasicProperties(map);
        FileBasedBuilderParametersImpl fbp = FileBasedBuilderParametersImpl.fromParameters((Map)map);
        Assertions.assertEquals((Object)"test.xml", (Object)fbp.getFileHandler().getFileName());
        Assertions.assertEquals((Object)engine, map.get("expressionEngine"));
    }

    @Test
    public void testHierarchicalInheritance() {
        TestParameters.checkInheritance(new Parameters().hierarchical(), FileBasedBuilderParameters.class);
    }

    @Test
    public void testInheritance() {
        XMLBuilderParameters params = new Parameters().xml();
        FileBasedBuilderParameters fbParams = (FileBasedBuilderParameters)Assertions.assertInstanceOf(FileBasedBuilderParameters.class, (Object)params);
        ((FileBasedBuilderParameters)((FileBasedBuilderParameters)fbParams.setListDelimiterHandler(listHandler)).setFileName("test.xml")).setThrowExceptionOnMissing(true);
        ExpressionEngine engine = (ExpressionEngine)Mockito.mock(ExpressionEngine.class);
        ((HierarchicalBuilderParameters)params).setExpressionEngine(engine);
        Map map = fbParams.getParameters();
        TestParameters.checkBasicProperties(map);
        Assertions.assertSame((Object)engine, map.get("expressionEngine"));
    }

    @Test
    public void testJndi() {
        Map map = ((JndiBuilderParameters)((JndiBuilderParameters)((JndiBuilderParameters)new Parameters().jndi().setThrowExceptionOnMissing(true)).setPrefix("test")).setListDelimiterHandler(listHandler)).getParameters();
        Assertions.assertEquals((Object)"test", map.get("prefix"));
        TestParameters.checkBasicProperties(map);
    }

    @Test
    public void testMultiFile() {
        BuilderParameters bp = (BuilderParameters)Mockito.mock(BuilderParameters.class);
        String pattern = "a pattern";
        Map map = ((MultiFileBuilderParameters)((MultiFileBuilderParameters)((MultiFileBuilderParameters)((MultiFileBuilderParameters)new Parameters().multiFile().setThrowExceptionOnMissing(true)).setFilePattern("a pattern")).setListDelimiterHandler(listHandler)).setManagedBuilderParameters(bp)).getParameters();
        TestParameters.checkBasicProperties(map);
        MultiFileBuilderParametersImpl params = MultiFileBuilderParametersImpl.fromParameters((Map)map);
        Assertions.assertSame((Object)bp, (Object)params.getManagedBuilderParameters());
        Assertions.assertEquals((Object)"a pattern", (Object)params.getFilePattern());
    }

    @Test
    public void testProperties() {
        PropertiesConfiguration.IOFactory factory = (PropertiesConfiguration.IOFactory)Mockito.mock(PropertiesConfiguration.IOFactory.class);
        ConfigurationConsumer includeListener = (ConfigurationConsumer)Mockito.mock(ConfigurationConsumer.class);
        Map map = ((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setThrowExceptionOnMissing(true)).setFileName("test.properties")).setIncludeListener(includeListener)).setIOFactory(factory)).setListDelimiterHandler(listHandler)).setIncludesAllowed(false)).getParameters();
        TestParameters.checkBasicProperties(map);
        FileBasedBuilderParametersImpl fbp = FileBasedBuilderParametersImpl.fromParameters((Map)map);
        Assertions.assertEquals((Object)"test.properties", (Object)fbp.getFileHandler().getFileName());
        Assertions.assertEquals((Object)Boolean.FALSE, map.get("includesAllowed"));
        Assertions.assertSame((Object)includeListener, map.get("includeListener"));
        Assertions.assertSame((Object)factory, map.get("IOFactory"));
    }

    @Test
    public void testPropertiesInheritance() {
        TestParameters.checkInheritance(new Parameters().properties(), FileBasedBuilderParameters.class);
    }

    @Test
    public void testProxyObjectMethods() {
        FileBasedBuilderParameters params = new Parameters().fileBased();
        String s = params.toString();
        Assertions.assertTrue((boolean)s.contains(FileBasedBuilderParametersImpl.class.getSimpleName()));
        Assertions.assertNotEquals((int)0, (int)params.hashCode());
    }

    @Test
    public void testRegisterDefaultsHandlerNoStartClass() {
        DefaultParametersManager manager = (DefaultParametersManager)Mockito.mock(DefaultParametersManager.class);
        DefaultParametersHandler<XMLBuilderParameters> handler = TestParameters.createHandlerMock();
        Parameters params = new Parameters(manager);
        params.registerDefaultsHandler(XMLBuilderParameters.class, handler);
        ((DefaultParametersManager)Mockito.verify((Object)manager)).registerDefaultsHandler(XMLBuilderParameters.class, handler);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
    }

    @Test
    public void testRegisterDefaultsHandlerWithStartClass() {
        DefaultParametersManager manager = (DefaultParametersManager)Mockito.mock(DefaultParametersManager.class);
        DefaultParametersHandler<XMLBuilderParameters> handler = TestParameters.createHandlerMock();
        Parameters params = new Parameters(manager);
        params.registerDefaultsHandler(XMLBuilderParameters.class, handler, FileBasedBuilderParameters.class);
        ((DefaultParametersManager)Mockito.verify((Object)manager)).registerDefaultsHandler(XMLBuilderParameters.class, handler, FileBasedBuilderParameters.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
    }

    @Test
    public void testXml() {
        ExpressionEngine engine = (ExpressionEngine)Mockito.mock(ExpressionEngine.class);
        Map map = ((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)new Parameters().xml().setThrowExceptionOnMissing(true)).setFileName("test.xml")).setValidating(true)).setExpressionEngine(engine)).setListDelimiterHandler(listHandler)).setSchemaValidation(true)).getParameters();
        TestParameters.checkBasicProperties(map);
        FileBasedBuilderParametersImpl fbp = FileBasedBuilderParametersImpl.fromParameters((Map)map);
        Assertions.assertEquals((Object)"test.xml", (Object)fbp.getFileHandler().getFileName());
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("validating"));
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("schemaValidation"));
        Assertions.assertEquals((Object)engine, map.get("expressionEngine"));
    }

    @Test
    public void testXmlInheritance() {
        TestParameters.checkInheritance(new Parameters().xml(), HierarchicalBuilderParameters.class, FileBasedBuilderParameters.class);
    }
}

