/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.beanutils.BeanCreationContext;
import org.apache.commons.configuration2.beanutils.BeanCreationTestBean;
import org.apache.commons.configuration2.beanutils.BeanCreationTestBeanWithListChild;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.BeanDeclarationTestImpl;
import org.apache.commons.configuration2.beanutils.BeanFactory;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.beanutils.DefaultBeanFactory;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestBeanHelper {
    private static final String TEST_STRING = "testString";
    private static final int TEST_INT = 42;
    private static final String TEST_FACTORY = "testFactory";
    private BeanHelper helper;

    private void checkBean(BeanCreationTestBean bean) {
        Assertions.assertEquals((Object)TEST_STRING, (Object)bean.getStringValue());
        Assertions.assertEquals((int)42, (int)bean.getIntValue());
        BeanCreationTestBean buddy = bean.getBuddy();
        Assertions.assertNotNull((Object)buddy);
        Assertions.assertEquals((Object)"Another test string", (Object)buddy.getStringValue());
        Assertions.assertEquals((int)100, (int)buddy.getIntValue());
    }

    private void checkBean(BeanCreationTestBeanWithListChild bean) {
        Assertions.assertEquals((Object)TEST_STRING, (Object)bean.getStringValue());
        Assertions.assertEquals((int)42, (int)bean.getIntValue());
        List<BeanCreationTestBean> children = bean.getChildren();
        Assertions.assertNotNull(children);
        Assertions.assertEquals((int)2, (int)children.size());
        Assertions.assertNotNull((Object)children.get(0));
        Assertions.assertNotNull((Object)children.get(1));
    }

    private BeanDeclarationTestImpl createChildBean(String name) {
        BeanDeclarationTestImpl childBean = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties2 = new HashMap<String, Object>();
        properties2.put("stringValue", name + " Another test string");
        properties2.put("intValue", 100);
        childBean.setBeanProperties(properties2);
        childBean.setBeanClassName(BeanCreationTestBean.class.getName());
        return childBean;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.helper = new BeanHelper((BeanFactory)new TestBeanFactory());
    }

    private BeanDeclarationTestImpl setUpBeanDeclaration() {
        BeanDeclarationTestImpl data = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("stringValue", TEST_STRING);
        properties.put("intValue", String.valueOf(42));
        data.setBeanProperties(properties);
        BeanDeclarationTestImpl buddyData = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties2 = new HashMap<String, Object>();
        properties2.put("stringValue", "Another test string");
        properties2.put("intValue", 100);
        buddyData.setBeanProperties(properties2);
        buddyData.setBeanClassName(BeanCreationTestBean.class.getName());
        HashMap<String, Object> nested = new HashMap<String, Object>();
        nested.put("buddy", buddyData);
        data.setNestedBeanDeclarations(nested);
        return data;
    }

    private BeanDeclarationTestImpl setUpBeanDeclarationWithListChild() {
        BeanDeclarationTestImpl data = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("stringValue", TEST_STRING);
        properties.put("intValue", String.valueOf(42));
        data.setBeanProperties(properties);
        ArrayList<BeanDeclarationTestImpl> childData = new ArrayList<BeanDeclarationTestImpl>();
        childData.add(this.createChildBean("child1"));
        childData.add(this.createChildBean("child2"));
        HashMap<String, Object> nested = new HashMap<String, Object>();
        nested.put("children", childData);
        data.setNestedBeanDeclarations(nested);
        return data;
    }

    @Test
    public void testCopyProperties() throws Exception {
        PropertiesConfiguration src = new PropertiesConfiguration();
        src.setHeader("TestHeader");
        src.setFooter("TestFooter");
        LazyDynaBean dest = new LazyDynaBean();
        BeanHelper.copyProperties((Object)dest, (Object)src);
        Assertions.assertEquals((Object)"TestFooter", (Object)dest.get("footer"));
        Assertions.assertEquals((Object)"TestHeader", (Object)dest.get("header"));
    }

    @Test
    public void testCreateBean() {
        TestBeanFactory factory = new TestBeanFactory();
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(BeanCreationTestBean.class.getName());
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, null));
        Assertions.assertNull((Object)factory.parameter);
        Assertions.assertEquals((int)1, (int)factory.getCreateBeanCount());
    }

    @Test
    public void testCreateBeanWithDefaultClass() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, BeanCreationTestBean.class));
    }

    @Test
    public void testCreateBeanWithDefaultFactory() {
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanClassName(BeanCreationTestBean.class.getName());
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, null));
        TestBeanFactory factory = (TestBeanFactory)this.helper.getDefaultBeanFactory();
        Assertions.assertTrue((factory.getCreateBeanCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateBeanWithException() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(this.getClass().getName());
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.helper.createBean((BeanDeclaration)data, null));
    }

    @Test
    public void testCreateBeanWithFactoryDefaultClass() {
        TestBeanFactory factory = new TestBeanFactory();
        factory.supportsDefaultClass = true;
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, null));
        Assertions.assertEquals((int)1, (int)factory.getCreateBeanCount());
    }

    @Test
    public void testCreateBeanWithInvalidClass() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName("non.existing.ClassName");
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.helper.createBean((BeanDeclaration)data, null));
    }

    @Test
    public void testCreateBeanWithListChildBean() {
        TestBeanFactory factory = new TestBeanFactory();
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        BeanDeclarationTestImpl data = this.setUpBeanDeclarationWithListChild();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(BeanCreationTestBeanWithListChild.class.getName());
        this.checkBean((BeanCreationTestBeanWithListChild)this.helper.createBean((BeanDeclaration)data, null));
        Assertions.assertNull((Object)factory.parameter);
        Assertions.assertEquals((int)1, (int)factory.getCreateBeanCount());
    }

    @Test
    public void testCreateBeanWithNoClass() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.helper.createBean((BeanDeclaration)data, null));
    }

    @Test
    public void testCreateBeanWithNullDeclaration() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.helper.createBean(null));
    }

    @Test
    public void testCreateBeanWithParameter() {
        Integer param = 42;
        TestBeanFactory factory = new TestBeanFactory();
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(BeanCreationTestBean.class.getName());
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, null, (Object)param));
        Assertions.assertSame((Object)param, (Object)factory.parameter);
    }

    @Test
    public void testCreateBeanWithUnknownFactory() {
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(BeanCreationTestBean.class.getName());
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.helper.createBean((BeanDeclaration)data, null));
    }

    @Test
    public void testCreateWrapDynaBean() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        DynaBean bean = BeanHelper.createWrapDynaBean((Object)config);
        String value = "TestFooter";
        bean.set("footer", (Object)"TestFooter");
        Assertions.assertEquals((Object)"TestFooter", (Object)config.getFooter());
    }

    @Test
    public void testCreateWrapDynaBeanNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BeanHelper.createWrapDynaBean(null));
    }

    @Test
    public void testDefaultBeanFactory() {
        this.helper = new BeanHelper();
        Assertions.assertSame((Object)DefaultBeanFactory.INSTANCE, (Object)this.helper.getDefaultBeanFactory());
    }

    @Test
    public void testDefaultInstance() {
        Assertions.assertSame((Object)DefaultBeanFactory.INSTANCE, (Object)BeanHelper.INSTANCE.getDefaultBeanFactory());
    }

    @Test
    public void testDeregisterBeanFactory() {
        TestBeanFactory factory = new TestBeanFactory();
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        Assertions.assertSame((Object)factory, (Object)this.helper.deregisterBeanFactory(TEST_FACTORY));
        Assertions.assertEquals(Collections.emptySet(), (Object)this.helper.registeredFactoryNames());
    }

    @Test
    public void testDeregisterBeanFactoryNonExisting() {
        Assertions.assertNull((Object)this.helper.deregisterBeanFactory(TEST_FACTORY));
    }

    @Test
    public void testDeregisterBeanFactoryNull() {
        Assertions.assertNull((Object)this.helper.deregisterBeanFactory(null));
    }

    @Test
    public void testInitBean() {
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        BeanCreationTestBean bean = new BeanCreationTestBean();
        this.helper.initBean((Object)bean, (BeanDeclaration)data);
        this.checkBean(bean);
    }

    @Test
    public void testInitBeanWithInvalidProperty() {
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.getBeanProperties().put("nonExistingProperty", Boolean.TRUE);
        BeanCreationTestBean bean = new BeanCreationTestBean();
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.helper.initBean((Object)bean, (BeanDeclaration)data));
    }

    @Test
    public void testInitBeanWithNoData() {
        BeanDeclarationTestImpl data = new BeanDeclarationTestImpl();
        BeanCreationTestBean bean = new BeanCreationTestBean();
        this.helper.initBean((Object)bean, (BeanDeclaration)data);
        Assertions.assertNull((Object)bean.getStringValue());
        Assertions.assertEquals((int)0, (int)bean.getIntValue());
        Assertions.assertNull((Object)bean.getBuddy());
    }

    @Test
    public void testInitWithBeanFactory() {
        BeanFactory factory = (BeanFactory)Mockito.mock(BeanFactory.class);
        this.helper = new BeanHelper(factory);
        Assertions.assertSame((Object)factory, (Object)this.helper.getDefaultBeanFactory());
    }

    @Test
    public void testRegisterBeanFactory() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        Assertions.assertEquals(Collections.singleton(TEST_FACTORY), (Object)this.helper.registeredFactoryNames());
    }

    @Test
    public void testRegisterBeanFactoryNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.helper.registerBeanFactory(TEST_FACTORY, null));
    }

    @Test
    public void testRegisterBeanFactoryNullName() {
        TestBeanFactory beanFactory = new TestBeanFactory();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.helper.registerBeanFactory(null, beanFactory));
    }

    @Test
    public void testRegisteredFactoriesEmptyForNewInstance() {
        Assertions.assertEquals(Collections.emptySet(), (Object)this.helper.registeredFactoryNames());
    }

    private class TestBeanFactory
    implements BeanFactory {
        Object parameter;
        boolean supportsDefaultClass;
        private int createBeanCount;

        private TestBeanFactory() {
        }

        public Object createBean(BeanCreationContext bcc) {
            ++this.createBeanCount;
            this.parameter = bcc.getParameter();
            if (BeanCreationTestBean.class.equals((Object)bcc.getBeanClass())) {
                BeanCreationTestBean bean = new BeanCreationTestBean();
                TestBeanHelper.this.helper.initBean((Object)bean, bcc.getBeanDeclaration());
                return bean;
            }
            if (BeanCreationTestBeanWithListChild.class.equals((Object)bcc.getBeanClass())) {
                BeanCreationTestBeanWithListChild bean = new BeanCreationTestBeanWithListChild();
                TestBeanHelper.this.helper.initBean((Object)bean, bcc.getBeanDeclaration());
                return bean;
            }
            throw new IllegalArgumentException("Unsupported class: " + bcc.getBeanClass());
        }

        public int getCreateBeanCount() {
            return this.createBeanCount;
        }

        public Class<?> getDefaultBeanClass() {
            return this.supportsDefaultClass ? BeanCreationTestBean.class : null;
        }
    }
}

