/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodeIteratorAttribute;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationIteratorAttributes
extends AbstractXPathTest {
    private static final String TEST_ATTR = "test";
    private static final String NAMESPACE = "commons";
    private static final String NS_ATTR = "commons:attr";
    private ConfigurationNodePointer<ImmutableNode> pointer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ImmutableNode orgNode = (ImmutableNode)this.root.getChildren().get(1);
        ImmutableNode testNode = orgNode.setAttribute(TEST_ATTR, (Object)"yes").setAttribute(NS_ATTR, (Object)"configuration");
        this.pointer = new ConfigurationNodePointer((Object)testNode, Locale.getDefault(), this.handler);
    }

    @Test
    public void testIterateAllAttributes() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(null, "*"));
        Assert.assertEquals((String)"Wrong number of attributes", (long)3L, (long)this.iteratorSize((NodeIterator)it));
        List<NodePointer> attrs = this.iterationElements((NodeIterator)it);
        HashSet<String> attrNames = new HashSet<String>();
        for (NodePointer np : attrs) {
            attrNames.add(np.getName().getName());
        }
        Assert.assertTrue((String)"First attribute not found", (boolean)attrNames.contains("counter"));
        Assert.assertTrue((String)"Second attribute not found", (boolean)attrNames.contains(TEST_ATTR));
        Assert.assertTrue((String)"Namespace attribute not found", (boolean)attrNames.contains(NS_ATTR));
    }

    @Test
    public void testIterateNamespaceAttribute() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(NAMESPACE, "attr"));
        Assert.assertEquals((String)"Wrong number of attributes", (long)1L, (long)this.iteratorSize((NodeIterator)it));
        Assert.assertEquals((String)"Wrong attribute", (Object)NS_ATTR, (Object)this.iterationElements((NodeIterator)it).get(0).getName().getName());
    }

    @Test
    public void testIterateNamespaceUnknown() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(TEST_ATTR, "*"));
        Assert.assertEquals((String)"Found attributes", (long)0L, (long)this.iteratorSize((NodeIterator)it));
    }

    @Test
    public void testIterateNamespaceWildcard() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(NAMESPACE, "*"));
        Assert.assertEquals((String)"Wrong number of attributes", (long)1L, (long)this.iteratorSize((NodeIterator)it));
        Assert.assertEquals((String)"Wrong attribute", (Object)NS_ATTR, (Object)this.iterationElements((NodeIterator)it).get(0).getName().getName());
    }

    @Test
    public void testIterateSpecificAttribute() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(null, TEST_ATTR));
        Assert.assertEquals((String)"Wrong number of attributes", (long)1L, (long)this.iteratorSize((NodeIterator)it));
        Assert.assertEquals((String)"Wrong attribute", (Object)TEST_ATTR, (Object)this.iterationElements((NodeIterator)it).get(0).getName().getName());
    }

    @Test
    public void testIterateUnknownAttribute() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(null, "unknown"));
        Assert.assertEquals((String)"Found attributes", (long)0L, (long)this.iteratorSize((NodeIterator)it));
    }
}

