/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.TrackedNodeHandler;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTrackedNodeHandler {
    private static ImmutableNode root;
    private NodeHandler<ImmutableNode> parentHandler;
    private TrackedNodeHandler handler;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        root = new ImmutableNode.Builder().name("ROOT").create();
    }

    @Before
    public void setUp() throws Exception {
        this.parentHandler = (NodeHandler)EasyMock.createMock(NodeHandler.class);
        this.handler = new TrackedNodeHandler(root, this.parentHandler);
    }

    @Test
    public void testGetParent() {
        ImmutableNode node = new ImmutableNode.Builder().name("node").create();
        ImmutableNode parent = new ImmutableNode.Builder().name("parent").create();
        EasyMock.expect((Object)this.parentHandler.getParent((Object)node)).andReturn((Object)parent);
        EasyMock.replay((Object[])new Object[]{this.parentHandler});
        Assert.assertSame((String)"Wrong parent node", (Object)parent, (Object)this.handler.getParent(node));
        EasyMock.verify((Object[])new Object[]{this.parentHandler});
    }

    @Test
    public void testGetRootNode() {
        Assert.assertSame((String)"Wrong root node", (Object)root, (Object)this.handler.getRootNode());
    }
}

