/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Locale;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.NodeNameMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNodeNameMatchers {
    private static final String NODE_NAME = "TestNodeName";
    private NodeHandler<ImmutableNode> handler;

    private static ImmutableNode createNode(String name) {
        return new ImmutableNode.Builder().name(name).create();
    }

    private void checkMatcherWithNullInput(NodeMatcher<String> matcher) {
        Assert.assertFalse((String)"Match (1)", (boolean)matcher.matches((Object)TestNodeNameMatchers.createNode(NODE_NAME), this.handler, null));
        Assert.assertFalse((String)"Match (2)", (boolean)matcher.matches((Object)TestNodeNameMatchers.createNode(null), this.handler, (Object)NODE_NAME));
    }

    @Before
    public void setUp() throws Exception {
        InMemoryNodeModel model = new InMemoryNodeModel();
        this.handler = model.getNodeHandler();
    }

    @Test
    public void testEqualsIgnoreCaseMatch() {
        ImmutableNode node = TestNodeNameMatchers.createNode(NODE_NAME);
        Assert.assertTrue((String)"No match (1)", (boolean)NodeNameMatchers.EQUALS_IGNORE_CASE.matches((Object)node, this.handler, (Object)NODE_NAME));
        Assert.assertTrue((String)"No match (2)", (boolean)NodeNameMatchers.EQUALS_IGNORE_CASE.matches((Object)node, this.handler, (Object)NODE_NAME.toLowerCase(Locale.ENGLISH)));
        Assert.assertTrue((String)"No match (3)", (boolean)NodeNameMatchers.EQUALS_IGNORE_CASE.matches((Object)node, this.handler, (Object)NODE_NAME.toUpperCase(Locale.ENGLISH)));
    }

    @Test
    public void testEqualsIgnoreCaseNoMatch() {
        ImmutableNode node = TestNodeNameMatchers.createNode(NODE_NAME);
        Assert.assertFalse((String)"Match", (boolean)NodeNameMatchers.EQUALS_IGNORE_CASE.matches((Object)node, this.handler, (Object)"TestNodeName_other"));
    }

    @Test
    public void testEqualsIgnoreCaseNullCriterion() {
        this.checkMatcherWithNullInput((NodeMatcher<String>)NodeNameMatchers.EQUALS_IGNORE_CASE);
    }

    @Test
    public void testEqualsMatch() {
        ImmutableNode node = TestNodeNameMatchers.createNode(NODE_NAME);
        Assert.assertTrue((String)"No match", (boolean)NodeNameMatchers.EQUALS.matches((Object)node, this.handler, (Object)NODE_NAME));
    }

    @Test
    public void testEqualsNoMatch() {
        ImmutableNode node = TestNodeNameMatchers.createNode(NODE_NAME);
        Assert.assertFalse((String)"Match (1)", (boolean)NodeNameMatchers.EQUALS.matches((Object)node, this.handler, (Object)"TestNodeName_other"));
        Assert.assertFalse((String)"Match (2)", (boolean)NodeNameMatchers.EQUALS.matches((Object)node, this.handler, (Object)NODE_NAME.toLowerCase(Locale.ENGLISH)));
    }

    @Test
    public void testEqualsNullCriterion() {
        this.checkMatcherWithNullInput((NodeMatcher<String>)NodeNameMatchers.EQUALS);
    }
}

