/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultExpressionEngineSymbols {
    private static DefaultExpressionEngineSymbols.Builder builder() {
        return new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS);
    }

    private static void expEqual(Object o1, Object o2) {
        Assert.assertEquals((String)"Not equal", (Object)o1, (Object)o2);
        Assert.assertEquals((String)"Not symmetric", (Object)o2, (Object)o1);
        Assert.assertEquals((String)"Different hash codes", (long)o1.hashCode(), (long)o2.hashCode());
    }

    private static void expNE(Object o1, Object o2) {
        Assert.assertNotEquals((String)"Equal", (Object)o1, (Object)o2);
        if (o2 != null) {
            Assert.assertNotEquals((String)"Not symmetric", (Object)o2, (Object)o1);
        }
    }

    @Test
    public void testDefaultSymbols() {
        Assert.assertEquals((String)"Wrong delimiter", (Object)".", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getPropertyDelimiter());
        Assert.assertEquals((String)"Wrong escaped delimiter", (Object)"..", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getEscapedDelimiter());
        Assert.assertEquals((String)"Wrong index start", (Object)"(", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getIndexStart());
        Assert.assertEquals((String)"Wrong index end", (Object)")", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getIndexEnd());
        Assert.assertEquals((String)"Wrong attribute start", (Object)"[@", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getAttributeStart());
        Assert.assertEquals((String)"Wrong attribute end", (Object)"]", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getAttributeEnd());
    }

    @Test
    public void testEqualsFalse() {
        DefaultExpressionEngineSymbols s1 = DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS;
        DefaultExpressionEngineSymbols s2 = TestDefaultExpressionEngineSymbols.builder().setPropertyDelimiter("/").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setEscapedDelimiter("\\.").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setIndexStart("[").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setIndexEnd("]").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setAttributeStart("#").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setAttributeEnd("~").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
    }

    @Test
    public void testEqualsNull() {
        TestDefaultExpressionEngineSymbols.expNE(TestDefaultExpressionEngineSymbols.builder().create(), null);
    }

    @Test
    public void testEqualsOtherClass() {
        TestDefaultExpressionEngineSymbols.expNE(TestDefaultExpressionEngineSymbols.builder().create(), this);
    }

    @Test
    public void testEqualsTrue() {
        TestDefaultExpressionEngineSymbols.expEqual(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS, DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS);
        DefaultExpressionEngineSymbols s2 = new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).create();
        TestDefaultExpressionEngineSymbols.expEqual(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS, s2);
    }

    @Test
    public void testToString() {
        DefaultExpressionEngineSymbols symbols = TestDefaultExpressionEngineSymbols.builder().create();
        String s = symbols.toString();
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("propertyDelimiter=" + symbols.getPropertyDelimiter())));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("escapedDelimiter=" + symbols.getEscapedDelimiter())));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("indexStart=" + symbols.getIndexStart())));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("indexEnd=" + symbols.getIndexEnd())));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("attributeStart=" + symbols.getAttributeStart())));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("attributeEnd=" + symbols.getAttributeEnd())));
    }
}

