/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.TreeData;
import org.apache.commons.lang3.StringUtils;
import org.dbunit.dataset.common.handlers.NoHandler;
import org.easymock.EasyMock;

public class NodeStructureHelper {
    private static final Pattern PAT_KEY_WITH_INDEX = Pattern.compile("(\\w+)\\((\\d+)\\)");
    private static final String PATH_SEPARATOR = "/";
    private static final String[] AUTHORS = new String[]{"Shakespeare", "Homer", "Simmons"};
    private static final String[][] WORKS = new String[][]{{"Troilus and Cressida", "The Tempest", "A Midsummer Night's Dream"}, {"Ilias"}, {"Ilium", "Hyperion"}};
    private static final String[][][] PERSONAE = new String[][][]{{{"Troilus", "Cressidia", "Ajax", "Achilles"}, {"Prospero", "Ariel"}, {"Oberon", "Titania", "Puck"}}, {{"Achilles", "Agamemnon", "Hektor"}}, {{"Hockenberry", "Achilles"}, {"Shrike", "Moneta", "Consul", "Weintraub"}}};
    private static final String[] TABLES = new String[]{"users", "documents"};
    private static final String[][] FIELDS = new String[][]{{"uid", "uname", "firstName", "lastName", "email"}, {"docid", "name", "creationDate", "authorID", "version", "length"}};
    public static final String ATTR_AUTHOR = "author";
    public static final String ELEM_ORG_VALUE = "originalValue";
    public static final String ATTR_TESTED = "tested";
    public static final ImmutableNode ROOT_AUTHORS_TREE = NodeStructureHelper.createAuthorsTree();
    public static final ImmutableNode ROOT_PERSONAE_TREE = NodeStructureHelper.createPersonaeTree();
    public static final ImmutableNode ROOT_TABLES_TREE = NodeStructureHelper.createTablesTree();

    public static String appendPath(String path, String component) {
        StringBuilder buf = new StringBuilder(StringUtils.length((CharSequence)path) + StringUtils.length((CharSequence)component) + 1);
        buf.append(path).append(PATH_SEPARATOR).append(component);
        return buf.toString();
    }

    public static String author(int idx) {
        return AUTHORS[idx];
    }

    public static int authorsLength() {
        return AUTHORS.length;
    }

    private static ImmutableNode createAuthorsTree() {
        ImmutableNode.Builder rootBuilder = new ImmutableNode.Builder(AUTHORS.length);
        for (int author = 0; author < AUTHORS.length; ++author) {
            ImmutableNode.Builder authorBuilder = new ImmutableNode.Builder();
            authorBuilder.name(AUTHORS[author]);
            for (int work = 0; work < WORKS[author].length; ++work) {
                ImmutableNode.Builder workBuilder = new ImmutableNode.Builder();
                workBuilder.name(WORKS[author][work]);
                for (String person : PERSONAE[author][work]) {
                    workBuilder.addChild(new ImmutableNode.Builder().name(person).create());
                }
                authorBuilder.addChild(workBuilder.create());
            }
            rootBuilder.addChild(authorBuilder.create());
        }
        return rootBuilder.name("authorTree").create();
    }

    public static ImmutableNode createFieldNode(String name) {
        ImmutableNode.Builder fldBuilder = new ImmutableNode.Builder(1);
        fldBuilder.addChild(NodeStructureHelper.createNode("name", name));
        return fldBuilder.name("field").create();
    }

    public static ImmutableNode createNode(String name, Object value) {
        return new ImmutableNode.Builder().name(name).value(value).create();
    }

    private static ImmutableNode createPersonaeTree() {
        ImmutableNode.Builder rootBuilder = new ImmutableNode.Builder();
        for (int author = 0; author < AUTHORS.length; ++author) {
            for (int work = 0; work < WORKS[author].length; ++work) {
                for (String person : PERSONAE[author][work]) {
                    ImmutableNode orgValue = new ImmutableNode.Builder().name(ELEM_ORG_VALUE).value((Object)"yes").addAttribute(ATTR_TESTED, (Object)Boolean.FALSE).create();
                    ImmutableNode workNode = new ImmutableNode.Builder(1).name(WORKS[author][work]).addChild(orgValue).create();
                    ImmutableNode personNode = new ImmutableNode.Builder(1).name(person).addAttribute(ATTR_AUTHOR, (Object)AUTHORS[author]).addChild(workNode).create();
                    rootBuilder.addChild(personNode);
                }
            }
        }
        return rootBuilder.create();
    }

    public static NodeKeyResolver<ImmutableNode> createResolverMock() {
        return (NodeKeyResolver)EasyMock.createMock(NodeKeyResolver.class);
    }

    private static ImmutableNode createTablesTree() {
        return NodeStructureHelper.createTablesTree(TABLES, FIELDS);
    }

    public static ImmutableNode createTablesTree(String[] tables, String[][] fields) {
        ImmutableNode.Builder bldTables = new ImmutableNode.Builder(tables.length);
        bldTables.name("tables");
        for (int i = 0; i < tables.length; ++i) {
            ImmutableNode.Builder bldTable = new ImmutableNode.Builder(2);
            bldTable.addChild(NodeStructureHelper.createNode("name", tables[i]));
            ImmutableNode.Builder bldFields = new ImmutableNode.Builder(fields[i].length);
            bldFields.name("fields");
            for (int j = 0; j < fields[i].length; ++j) {
                bldFields.addChild(NodeStructureHelper.createFieldNode(fields[i][j]));
            }
            bldTable.addChild(bldFields.create());
            bldTables.addChild(bldTable.name("table").create());
        }
        return bldTables.create();
    }

    public static void expectResolveAddKeys(NodeKeyResolver<ImmutableNode> resolver) {
        EasyMock.expect((Object)resolver.resolveAddKey(EasyMock.anyObject(ImmutableNode.class), EasyMock.anyString(), (NodeHandler)EasyMock.anyObject(TreeData.class))).andAnswer(() -> {
            ImmutableNode root = (ImmutableNode)EasyMock.getCurrentArguments()[0];
            String key = (String)EasyMock.getCurrentArguments()[1];
            TreeData handler = (TreeData)EasyMock.getCurrentArguments()[2];
            return DefaultExpressionEngine.INSTANCE.prepareAdd((Object)root, key, (NodeHandler)handler);
        }).anyTimes();
    }

    public static void expectResolveKeyForQueries(NodeKeyResolver<ImmutableNode> resolver) {
        EasyMock.expect((Object)resolver.resolveKey(EasyMock.anyObject(ImmutableNode.class), (String)EasyMock.anyObject(String.class), (NodeHandler)EasyMock.anyObject(NoHandler.class))).andAnswer(() -> {
            ImmutableNode root = (ImmutableNode)EasyMock.getCurrentArguments()[0];
            String key = (String)EasyMock.getCurrentArguments()[1];
            NodeHandler handler = (NodeHandler)EasyMock.getCurrentArguments()[2];
            return DefaultExpressionEngine.INSTANCE.query((Object)root, key, handler);
        }).anyTimes();
    }

    public static String field(int tabIdx, int fldIdx) {
        return FIELDS[tabIdx][fldIdx];
    }

    public static int fieldsLength(int tabIdx) {
        return FIELDS[tabIdx].length;
    }

    private static ImmutableNode findNode(ImmutableNode parent, String[] components, int currentIdx) {
        int childIndex;
        String childName;
        if (currentIdx >= components.length) {
            return parent;
        }
        Matcher m = PAT_KEY_WITH_INDEX.matcher(components[currentIdx]);
        if (m.matches()) {
            childName = m.group(1);
            childIndex = Integer.parseInt(m.group(2));
        } else {
            childName = components[currentIdx];
            childIndex = 0;
        }
        int foundIdx = 0;
        for (ImmutableNode node : parent) {
            if (!childName.equals(node.getNodeName()) || foundIdx++ != childIndex) continue;
            return NodeStructureHelper.findNode(node, components, currentIdx + 1);
        }
        throw new NoSuchElementException("Cannot resolve child " + components[currentIdx]);
    }

    public static String[][] getClonedFields() {
        String[][] fieldNamesNew = new String[FIELDS.length][];
        for (int i = 0; i < FIELDS.length; ++i) {
            fieldNamesNew[i] = (String[])FIELDS[i].clone();
        }
        return fieldNamesNew;
    }

    public static String[] getClonedTables() {
        return (String[])TABLES.clone();
    }

    public static ImmutableNode nodeForKey(ImmutableNode root, String key) {
        String[] components = key.split(PATH_SEPARATOR);
        return NodeStructureHelper.findNode(root, components, 0);
    }

    public static ImmutableNode nodeForKey(InMemoryNodeModel model, String key) {
        return NodeStructureHelper.nodeForKey(model.getRootNode(), key);
    }

    public static ImmutableNode nodeForKey(NodeHandler<ImmutableNode> handler, String key) {
        return NodeStructureHelper.nodeForKey((ImmutableNode)handler.getRootNode(), key);
    }

    public static String nodePath(String ... path) {
        return StringUtils.join((Object[])path, (String)PATH_SEPARATOR);
    }

    public static String nodePathWithEndNode(String endNode, String ... path) {
        return NodeStructureHelper.nodePath(path) + PATH_SEPARATOR + endNode;
    }

    public static String persona(int authorIdx, int workIdx, int personaIdx) {
        return PERSONAE[authorIdx][workIdx][personaIdx];
    }

    public static int personaeLength(int authorIdx, int workIdx) {
        return PERSONAE[authorIdx][workIdx].length;
    }

    public static String table(int idx) {
        return TABLES[idx];
    }

    public static int tablesLength() {
        return TABLES.length;
    }

    public static String work(int authorIdx, int idx) {
        return WORKS[authorIdx][idx];
    }

    public static int worksLength(int authorIdx) {
        return WORKS[authorIdx].length;
    }
}

