/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.VFSFileSystem;
import org.apache.commons.configuration2.reloading.VFSFileHandlerReloadingDetector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestVFSFileHandlerReloadingDetector {
    private static final String PROPERTY = "string";
    private static final String FMT_XML = "<configuration><string>%s</string></configuration>";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testGetRefreshDelay() throws Exception {
        long delay = 20130325L;
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector(null, 20130325L);
        Assert.assertNotNull((String)"No file handler was created", (Object)strategy.getFileHandler());
        Assert.assertEquals((String)"Wrong refresh delay", (long)20130325L, (long)strategy.getRefreshDelay());
    }

    @Test
    public void testLastModificationDateExisting() throws IOException {
        File file = this.folder.newFile();
        this.writeTestFile(file, "value1");
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector();
        strategy.getFileHandler().setFile(file);
        strategy.getFileHandler().setFileSystem((FileSystem)new VFSFileSystem());
        long modificationDate = strategy.getLastModificationDate();
        long expectedMillis = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
        Assert.assertEquals((String)"Wrong modification date", (long)expectedMillis, (long)modificationDate);
    }

    @Test
    public void testLastModificationDateFileSystemEx() throws FileSystemException {
        final FileObject fo = (FileObject)EasyMock.createMock(FileObject.class);
        FileName name = (FileName)EasyMock.createMock(FileName.class);
        EasyMock.expect((Object)fo.exists()).andReturn((Object)Boolean.TRUE);
        EasyMock.expect((Object)fo.getContent()).andThrow((Throwable)new FileSystemException("error"));
        EasyMock.expect((Object)fo.getName()).andReturn((Object)name);
        EasyMock.expect((Object)name.getURI()).andReturn((Object)"someURI");
        EasyMock.replay((Object[])new Object[]{fo, name});
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector(){

            protected FileObject getFileObject() {
                return fo;
            }
        };
        Assert.assertEquals((String)"Got a modification date", (long)0L, (long)strategy.getLastModificationDate());
        EasyMock.verify((Object[])new Object[]{fo});
    }

    @Test
    public void testLastModificationDateNonExisting() {
        File file = ConfigurationAssert.getOutFile("NonExistingFile.xml");
        FileHandler handler = new FileHandler();
        handler.setFileSystem((FileSystem)new VFSFileSystem());
        handler.setFile(file);
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector(handler);
        Assert.assertEquals((String)"Got a modification date", (long)0L, (long)strategy.getLastModificationDate());
    }

    @Test
    public void testLastModificationDateUndefinedHandler() {
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector();
        Assert.assertEquals((String)"Got a modification date", (long)0L, (long)strategy.getLastModificationDate());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testLastModificationDateUnresolvableURI() {
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector(){

            protected String resolveFileURI() {
                return null;
            }
        };
        strategy.getFileHandler().setFileSystem((FileSystem)new VFSFileSystem());
        strategy.getFileHandler().setFileName("test.xml");
        strategy.getLastModificationDate();
    }

    private void writeTestFile(File file, String value) throws IOException {
        try (FileWriter out = new FileWriter(file);){
            out.write(String.format(FMT_XML, value));
        }
    }
}

