/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.io.DefaultFileSystem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultFileSystem {
    private DefaultFileSystem fileSystem;

    @Before
    public void setUp() throws Exception {
        this.fileSystem = new DefaultFileSystem();
    }

    @Test
    public void testDefaultLogger() {
        Assert.assertNotNull((String)"No default logger", (Object)this.fileSystem.getLogger());
    }

    @Test(expected=ConfigurationException.class)
    public void testGetOutputStreamInvalidPath() throws ConfigurationException {
        this.fileSystem.getOutputStream(new File(""));
    }

    @Test
    public void testSetLogger() {
        ConfigurationLogger log = new ConfigurationLogger(this.getClass());
        this.fileSystem.setLogger(log);
        Assert.assertSame((String)"Logger not set", (Object)log, (Object)this.fileSystem.getLogger());
    }
}

