/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.commons.logging.impl.NoOpLog;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationLogger {
    private static final String MSG = "Interesting log output";

    @Test
    public void testAbstractConfigurationDefaultLogger() {
        BaseConfiguration config = new BaseConfiguration();
        Assert.assertThat((String)"Wrong default logger", (Object)config.getLogger().getLog(), (Matcher)CoreMatchers.instanceOf(NoOpLog.class));
    }

    @Test
    public void testAbstractConfigurationSetLogger() {
        ConfigurationLogger logger = new ConfigurationLogger(this.getClass());
        BaseConfiguration config = new BaseConfiguration();
        config.setLogger(logger);
        Assert.assertThat((String)"Logger not set", (Object)config.getLogger(), (Matcher)CoreMatchers.sameInstance((Object)logger));
    }

    @Test
    public void testAbstractConfigurationSetLoggerNull() {
        BaseConfiguration config = new BaseConfiguration();
        config.setLogger(new ConfigurationLogger(this.getClass()));
        config.setLogger(null);
        Assert.assertThat((String)"Logger not disabled", (Object)config.getLogger().getLog(), (Matcher)CoreMatchers.instanceOf(NoOpLog.class));
    }

    @Test
    public void testDebug() {
        Log log = (Log)EasyMock.createMock(Log.class);
        log.debug((Object)MSG);
        EasyMock.replay((Object[])new Object[]{log});
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.debug(MSG);
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testDummyLogger() {
        ConfigurationLogger logger = ConfigurationLogger.newDummyLogger();
        Assert.assertThat((String)"Wrong internal logger", (Object)logger.getLog(), (Matcher)CoreMatchers.instanceOf(NoOpLog.class));
    }

    @Test
    public void testError() {
        Log log = (Log)EasyMock.createMock(Log.class);
        log.error((Object)MSG);
        EasyMock.replay((Object[])new Object[]{log});
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.error(MSG);
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testErrorWithException() {
        Log log = (Log)EasyMock.createMock(Log.class);
        Exception ex = new Exception("Test exception");
        log.error((Object)MSG, (Throwable)ex);
        EasyMock.replay((Object[])new Object[]{log});
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.error(MSG, (Throwable)ex);
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testInfo() {
        Log log = (Log)EasyMock.createMock(Log.class);
        log.info((Object)MSG);
        EasyMock.replay((Object[])new Object[]{log});
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.info(MSG);
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoLoggerClass() {
        new ConfigurationLogger((Class)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoLoggerName() {
        new ConfigurationLogger((String)null);
    }

    @Test
    public void testInitWithLoggerSpec() {
        ConfigurationLogger logger1 = new ConfigurationLogger(this.getClass().getName());
        ConfigurationLogger logger2 = new ConfigurationLogger(this.getClass());
        Assert.assertNotNull((String)"No internal logger", (Object)logger1.getLog());
        if (logger1.getLog() instanceof Log4JLogger) {
            Assert.assertEquals((String)"Different internal Log4JLoggers", (Object)logger1.getLog(), (Object)logger2.getLog());
        }
    }

    @Test
    public void testIsDebugEnabled() {
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log.isDebugEnabled()).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{log});
        ConfigurationLogger logger = new ConfigurationLogger(log);
        Assert.assertTrue((String)"No debug log", (boolean)logger.isDebugEnabled());
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsInfoEnabled() {
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log.isInfoEnabled()).andReturn((Object)Boolean.FALSE);
        EasyMock.replay((Object[])new Object[]{log});
        ConfigurationLogger logger = new ConfigurationLogger(log);
        Assert.assertFalse((String)"Wrong info log", (boolean)logger.isInfoEnabled());
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testSubClass() {
        final StringBuilder buf = new StringBuilder();
        ConfigurationLogger logger = new ConfigurationLogger(){

            public void info(String msg) {
                buf.append(msg);
            }
        };
        Assert.assertNull((String)"Got an internal logger", (Object)logger.getLog());
        logger.info(MSG);
        Assert.assertEquals((String)"Message not logged", (Object)MSG, (Object)buf.toString());
    }

    @Test
    public void testWarn() {
        Log log = (Log)EasyMock.createMock(Log.class);
        log.warn((Object)MSG);
        EasyMock.replay((Object[])new Object[]{log});
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.warn(MSG);
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testWarnWithException() {
        Log log = (Log)EasyMock.createMock(Log.class);
        Exception ex = new Exception("Test exception");
        log.warn((Object)MSG, (Throwable)ex);
        EasyMock.replay((Object[])new Object[]{log});
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.warn(MSG, (Throwable)ex);
        EasyMock.verify((Object[])new Object[]{log});
    }
}

