/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLPropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.ConfigurationDeclaration;
import org.apache.commons.configuration2.builder.combined.FileExtensionConfigurationBuilderProvider;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestFileExtensionConfigurationBuilderProvider {
    private static final String DEF_CLASS = PropertiesConfiguration.class.getName();
    private static final String MATCH_CLASS = XMLPropertiesConfiguration.class.getName();
    private static final String EXT = "xml";

    private static FileExtensionConfigurationBuilderProvider setUpProvider() {
        return new FileExtensionConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, MATCH_CLASS, DEF_CLASS, EXT, null);
    }

    private ConfigurationDeclaration setUpDecl() {
        ConfigurationDeclaration decl = (ConfigurationDeclaration)EasyMock.createMock(ConfigurationDeclaration.class);
        EasyMock.replay((Object[])new Object[]{decl});
        return decl;
    }

    @Test
    public void testDetermineConfigurationClassExtensionMatch() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setPath("C:\\Test\\someTestConfiguration.xml");
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assert.assertEquals((String)"Wrong class", (Object)MATCH_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test
    public void testDetermineConfigurationClassExtensionNoMatch() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setPath("C:\\Test\\someTestConfiguration.properties");
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assert.assertEquals((String)"Wrong class", (Object)DEF_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test
    public void testDetermineConfigurationClassMatchCase() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setPath("C:\\Test\\someTestConfiguration." + EXT.toUpperCase(Locale.ENGLISH));
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assert.assertEquals((String)"Wrong class", (Object)MATCH_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test
    public void testDetermineConfigurationClassNoExtension() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setPath("C:\\Test\\someTestConfiguration");
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assert.assertEquals((String)"Wrong class", (Object)DEF_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test
    public void testDetermineConfigurationClassNoParams() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assert.assertEquals((String)"Wrong class", (Object)DEF_CLASS, (Object)provider.determineConfigurationClass(decl, new ArrayList()));
    }

    @Test
    public void testDeterminieConfigurationClassNoFileName() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assert.assertEquals((String)"Wrong class", (Object)DEF_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoDefaultConfigClass() {
        new FileExtensionConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, MATCH_CLASS, null, EXT, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoExt() {
        new FileExtensionConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, MATCH_CLASS, DEF_CLASS, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoMatchingConfigClass() {
        new FileExtensionConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, null, DEF_CLASS, EXT, null);
    }

    @Test
    public void testInitSuper() {
        FileExtensionConfigurationBuilderProvider provider = new FileExtensionConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), ReloadingFileBasedConfigurationBuilder.class.getName(), MATCH_CLASS, DEF_CLASS, EXT, null);
        Assert.assertEquals((String)"Wrong builder class", (Object)BasicConfigurationBuilder.class.getName(), (Object)provider.getBuilderClass());
        Assert.assertEquals((String)"Wrong reloading builder class", (Object)ReloadingFileBasedConfigurationBuilder.class.getName(), (Object)provider.getReloadingBuilderClass());
        Assert.assertEquals((String)"Wrong configuration class", (Object)DEF_CLASS, (Object)provider.getConfigurationClass());
    }
}

