/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import javax.naming.Context;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.JndiBuilderParametersImpl;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJndiBuilderParametersImpl {
    private JndiBuilderParametersImpl params;

    @Before
    public void setUp() throws Exception {
        this.params = new JndiBuilderParametersImpl();
    }

    @Test
    public void testGetParametersBaseProperties() {
        this.params.setPrefix("somePrefix");
        this.params.setThrowExceptionOnMissing(true);
        Map paramsMap = this.params.getParameters();
        Assert.assertEquals((String)"Wrong exception flag", (Object)Boolean.TRUE, paramsMap.get("throwExceptionOnMissing"));
    }

    @Test
    public void testSetBeanProperties() throws Exception {
        Context ctx = (Context)EasyMock.createMock(Context.class);
        EasyMock.replay((Object[])new Object[]{ctx});
        String prefix = "testJndiPrefix";
        BeanHelper.setProperty((Object)this.params, (String)"context", (Object)ctx);
        BeanHelper.setProperty((Object)this.params, (String)"prefix", (Object)"testJndiPrefix");
        Map paramsMap = this.params.getParameters();
        Assert.assertSame((String)"Context not in map", (Object)ctx, paramsMap.get("context"));
        Assert.assertEquals((String)"Prefix not in map", (Object)"testJndiPrefix", paramsMap.get("prefix"));
    }

    @Test
    public void testSetContext() {
        Context ctx = (Context)EasyMock.createMock(Context.class);
        EasyMock.replay((Object[])new Object[]{ctx});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setContext(ctx));
        Map paramsMap = this.params.getParameters();
        Assert.assertSame((String)"Context not in map", (Object)ctx, paramsMap.get("context"));
    }

    @Test
    public void testSetPrefix() {
        String prefix = "testJndiPrefix";
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setPrefix("testJndiPrefix"));
        Map paramsMap = this.params.getParameters();
        Assert.assertEquals((String)"Prefix not in map", (Object)"testJndiPrefix", paramsMap.get("prefix"));
    }
}

