/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.XMLPropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.HomeDirectoryLocationStrategy;
import org.apache.commons.configuration2.io.URLConnectionOptions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFileBasedConfigurationBuilder {
    private static final String PROP = "testProperty";
    @Rule
    public TemporaryFolder folder = TemporaryFolder.builder().assureDeletion().build();

    private static void checkSavedConfig(File file, int expValue) throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load(file);
        Assert.assertEquals((String)"Configuration was not saved", (long)expValue, (long)config.getInt(PROP));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTestFile(int value) {
        File file;
        Writer out = null;
        try {
            file = this.folder.newFile();
            out = new FileWriter(file);
            out.write(String.format("%s=%d", PROP, value));
        }
        catch (IOException ioex) {
            Assert.fail((String)("Could not create test file: " + ioex));
            File file2 = null;
            return file2;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    @Test
    public void testAutoSave() throws ConfigurationException {
        File file = this.createTestFile(0);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        Assert.assertFalse((String)"Wrong auto save flag", (boolean)builder.isAutoSave());
        builder.setAutoSave(true);
        Assert.assertTrue((String)"Auto save not enabled", (boolean)builder.isAutoSave());
        builder.setAutoSave(true);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        config.setProperty(PROP, (Object)1);
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 1);
    }

    @Test
    public void testAutoSaveWithPropertiesConfiguration() throws ConfigurationException, IOException {
        File file = this.folder.newFile();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        builder.setAutoSave(true);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        config.setProperty(PROP, (Object)1);
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 1);
    }

    @Test
    public void testAutoSaveWithReset() throws ConfigurationException {
        File file = this.createTestFile(0);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config1 = (PropertiesConfiguration)builder.getConfiguration();
        builder.setAutoSave(true);
        builder.resetResult();
        PropertiesConfiguration config2 = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertNotSame((String)"No new configuration created", (Object)config1, (Object)config2);
        config2.setProperty(PROP, (Object)1);
        config1.setProperty(PROP, (Object)2);
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 1);
    }

    @Test
    public void testChangeLocationAfterCreation() throws ConfigurationException {
        File file1 = this.createTestFile(1);
        File file2 = this.createTestFile(2);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file1)});
        builder.getConfiguration();
        builder.getFileHandler().setFile(file2);
        builder.resetResult();
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertEquals((String)"Not read from file 2", (long)2L, (long)config.getInt(PROP));
    }

    @Test
    public void testChangeLocationAfterReset() throws ConfigurationException {
        File file1 = this.createTestFile(1);
        File file2 = this.createTestFile(2);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file1)});
        builder.getConfiguration();
        builder.getFileHandler().setFile(file2);
        builder.reset();
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file1)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertEquals((String)"Not read from file 1", (long)1L, (long)config.getInt(PROP));
        builder.getFileHandler().setFile(file2);
        builder.resetResult();
        config = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertEquals((String)"Not read from file 2", (long)2L, (long)config.getInt(PROP));
    }

    @Test
    public void testCreateConfigurationNonExistingFileAndThenSave() throws ConfigurationException {
        File outFile = ConfigurationAssert.getOutFile("save.properties");
        Parameters parameters = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class, null, true).configure(new BuilderParameters[]{(BuilderParameters)parameters.properties().setFile(outFile)});
        Configuration config = (Configuration)builder.getConfiguration();
        config.setProperty(PROP, (Object)1);
        builder.save();
        TestFileBasedConfigurationBuilder.checkSavedConfig(outFile, 1);
        Assert.assertTrue((String)"Could not remove test file", (boolean)outFile.delete());
    }

    @Test
    public void testDisableAutoSave() throws ConfigurationException {
        File file = this.createTestFile(0);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        builder.setAutoSave(true);
        config.setProperty(PROP, (Object)1);
        builder.setAutoSave(false);
        config.setProperty(PROP, (Object)2);
        builder.setAutoSave(false);
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 1);
    }

    @Test
    public void testFileBasedConfigurationBuilderWithHomeDirectoryLocationStrategy() throws IOException, ConfigurationException {
        String folderName = "test";
        String fileName = "sample.properties";
        this.folder.newFolder("test");
        this.folder.newFile("test" + File.separatorChar + "sample.properties");
        FileBasedConfigurationBuilder homeDirConfigurationBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        PropertiesBuilderParameters homeDirProperties = new Parameters().properties();
        HomeDirectoryLocationStrategy strategy = new HomeDirectoryLocationStrategy(this.folder.getRoot().getAbsolutePath(), true);
        FileBasedConfigurationBuilder builder = homeDirConfigurationBuilder.configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)homeDirProperties.setLocationStrategy((FileLocationStrategy)strategy)).setBasePath("test")).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setFileName("sample.properties")});
        builder.getConfiguration();
    }

    @Test
    public void testGetConfigurationLoadFromFile() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertEquals((String)"Not read from file", (long)1L, (long)config.getInt(PROP));
        Assert.assertSame((String)"FileHandler not initialized", (Object)config, (Object)builder.getFileHandler().getContent());
    }

    @Test
    public void testGetConfigurationLoadFromJarFile() throws ConfigurationException, IOException {
        URL jarResourceUrl = this.getClass().getClassLoader().getResource("org/apache/commons/configuration2/test.jar");
        Assert.assertNotNull((Object)jarResourceUrl);
        Path testJar = Paths.get(this.folder.getRoot().getAbsolutePath(), "test.jar");
        try (InputStream inputStream = jarResourceUrl.openStream();){
            Files.copy(inputStream, testJar, new CopyOption[0]);
        }
        URL url = new URL("jar:" + testJar.toUri() + "!/configuration.properties");
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setURL(url, new URLConnectionOptions().setUseCaches(false))});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertEquals((String)"Not read from file", (long)1L, (long)config.getInt(PROP));
        Assert.assertSame((String)"FileHandler not initialized", (Object)config, (Object)builder.getFileHandler().getContent());
    }

    @Test
    public void testGetConfigurationNoLocation() throws ConfigurationException {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("throwExceptionOnMissing", Boolean.TRUE);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class, params);
        PropertiesConfiguration conf = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertTrue((String)"Property not set", (boolean)conf.isThrowExceptionOnMissing());
        Assert.assertTrue((String)"Not empty", (boolean)conf.isEmpty());
    }

    @Test
    public void testGetDefaultEncodingInterface() {
        String encoding = "testEncoding";
        FileBasedConfigurationBuilder.setDefaultEncoding(Configuration.class, (String)"testEncoding");
        Assert.assertEquals((String)"Wrong default encoding", (Object)"testEncoding", (Object)FileBasedConfigurationBuilder.getDefaultEncoding(XMLConfiguration.class));
        FileBasedConfigurationBuilder.setDefaultEncoding(Configuration.class, null);
        Assert.assertNull((String)"Default encoding not removed", (Object)FileBasedConfigurationBuilder.getDefaultEncoding(XMLConfiguration.class));
    }

    @Test
    public void testGetDefaultEncodingProperties() {
        Assert.assertEquals((String)"Wrong default encoding", (Object)"ISO-8859-1", (Object)FileBasedConfigurationBuilder.getDefaultEncoding(PropertiesConfiguration.class));
    }

    @Test
    public void testGetDefaultEncodingSubClass() {
        PropertiesConfiguration conf = new PropertiesConfiguration(){};
        Assert.assertEquals((String)"Wrong default encodng", (Object)"ISO-8859-1", (Object)FileBasedConfigurationBuilder.getDefaultEncoding(conf.getClass()));
    }

    @Test
    public void testGetDefaultEncodingXmlProperties() {
        Assert.assertEquals((String)"Wrong default encoding", (Object)"UTF-8", (Object)FileBasedConfigurationBuilder.getDefaultEncoding(XMLPropertiesConfiguration.class));
    }

    @Test
    public void testInitAllowFailOnInitFlag() {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class, null, true);
        Assert.assertTrue((String)"Flag not set", (boolean)builder.isAllowFailOnInit());
    }

    @Test
    public void testInitFileHandlerOverrideDefaultEncoding() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        FileHandler handler = new FileHandler();
        String encoding = "testEncoding";
        handler.setEncoding("testEncoding");
        builder.initFileHandler(handler);
        Assert.assertEquals((String)"Encoding was changed", (Object)"testEncoding", (Object)handler.getEncoding());
    }

    @Test
    public void testInitFileHandlerSetDefaultEncoding() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        FileHandler handler = new FileHandler();
        builder.initFileHandler(handler);
        Assert.assertEquals((String)"Wrong encoding", (Object)"ISO-8859-1", (Object)handler.getEncoding());
    }

    @Test
    public void testLocationIsFullyDefined() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        builder.getConfiguration();
        FileLocator locator = builder.getFileHandler().getFileLocator();
        Assert.assertTrue((String)("Not fully defined: " + locator), (boolean)FileLocatorUtils.isFullyInitialized((FileLocator)locator));
    }

    @Test
    public void testLocationSurvivesResetResult() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        builder.resetResult();
        PropertiesConfiguration config2 = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertNotSame((String)"Same configuration", (Object)config, (Object)config2);
        Assert.assertEquals((String)"Not read from file", (long)1L, (long)config2.getInt(PROP));
    }

    @Test
    public void testResetLocation() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        builder.getConfiguration();
        builder.reset();
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertTrue((String)"Configuration was read from file", (boolean)config.isEmpty());
        Assert.assertFalse((String)"FileHandler has location", (boolean)builder.getFileHandler().isLocationDefined());
    }

    @Test
    public void testSave() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        config.setProperty(PROP, (Object)5);
        builder.save();
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 5);
    }

    @Test
    public void testSaveNewFile() throws ConfigurationException, IOException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        config.setProperty(PROP, (Object)2);
        File file = this.folder.newFile();
        builder.getFileHandler().setFile(file);
        builder.save();
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetDefaultEncodingNull() {
        FileBasedConfigurationBuilder.setDefaultEncoding(null, (String)"UTF-8");
    }

    @Test
    public void testSetLocationNoFileHandler() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        builder.getFileHandler().setFile(file);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertFalse((String)"No data was loaded", (boolean)config.isEmpty());
    }
}

