/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import org.apache.commons.configuration2.builder.BasicBuilderProperties;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.DefaultParametersHandler;
import org.apache.commons.configuration2.builder.DefaultParametersManager;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDefaultParametersManager {
    private static final String DEF_ENCODING = "UTF-8";
    private static ListDelimiterHandler listHandler;
    private Parameters parameters;
    private DefaultParametersManager manager;

    private static void checkDefaultValues(Map<String, Object> map) {
        Assert.assertEquals((String)"Wrong delimiter handler", (Object)listHandler, (Object)map.get("listDelimiterHandler"));
        Assert.assertEquals((String)"Wrong exception flag value", (Object)Boolean.TRUE, (Object)map.get("throwExceptionOnMissing"));
        FileBasedBuilderParametersImpl fbparams = FileBasedBuilderParametersImpl.fromParameters(map);
        Assert.assertEquals((String)"Wrong encoding", (Object)DEF_ENCODING, (Object)fbparams.getFileHandler().getEncoding());
    }

    private static void checkNoDefaultValues(Map<String, Object> map) {
        Assert.assertFalse((String)"Got base properties", (boolean)map.containsKey("throwExceptionOnMissing"));
        FileBasedBuilderParametersImpl fbParams = FileBasedBuilderParametersImpl.fromParameters(map, (boolean)true);
        Assert.assertNull((String)"Got an encoding", (Object)fbParams.getFileHandler().getEncoding());
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        listHandler = (ListDelimiterHandler)EasyMock.createMock(ListDelimiterHandler.class);
    }

    @Before
    public void setUp() throws Exception {
        this.parameters = new Parameters();
        this.manager = new DefaultParametersManager();
    }

    @Test
    public void testApplyDefaults() {
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler());
        FileBasedBuilderParameters params = this.parameters.fileBased();
        this.manager.initializeParameters((BuilderParameters)params);
        Map map = params.getParameters();
        TestDefaultParametersManager.checkDefaultValues(map);
    }

    @Test
    public void testApplyDefaultsMultipleHandlers() {
        ExpressionEngine engine = (ExpressionEngine)EasyMock.createMock(ExpressionEngine.class);
        this.manager.registerDefaultsHandler(XMLBuilderParameters.class, parameters -> {
            XMLBuilderParameters cfr_ignored_0 = (XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)parameters.setThrowExceptionOnMissing(false)).setListDelimiterHandler((ListDelimiterHandler)EasyMock.createMock(ListDelimiterHandler.class))).setExpressionEngine(engine);
        });
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler());
        XMLBuilderParameters params = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)params);
        Map map = params.getParameters();
        TestDefaultParametersManager.checkDefaultValues(map);
        Assert.assertSame((String)"Expression engine not set", (Object)engine, map.get("expressionEngine"));
    }

    @Test
    public void testApplyDefaultsOnSubClass() {
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler());
        XMLBuilderParameters params = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)params);
        Map map = params.getParameters();
        TestDefaultParametersManager.checkDefaultValues(map);
    }

    @Test
    public void testApplyDefaultsStartClass() {
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler(), XMLBuilderParameters.class);
        XMLBuilderParameters paramsXml = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)paramsXml);
        Map map = paramsXml.getParameters();
        TestDefaultParametersManager.checkDefaultValues(map);
        PropertiesBuilderParameters paramsProps = this.parameters.properties();
        this.manager.initializeParameters((BuilderParameters)paramsProps);
        map = paramsProps.getParameters();
        TestDefaultParametersManager.checkNoDefaultValues(map);
    }

    @Test
    public void testInitializeParametersNull() {
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler());
        this.manager.initializeParameters(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterDefaultsHandlerNoClass() {
        this.manager.registerDefaultsHandler(null, (DefaultParametersHandler)new FileBasedDefaultsHandler());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterDefaultsHandlerNoHandler() {
        this.manager.registerDefaultsHandler(BasicBuilderProperties.class, null);
    }

    @Test
    public void testUnregisterDefaultsHandlerAll() {
        FileBasedDefaultsHandler handler = new FileBasedDefaultsHandler();
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)handler, XMLBuilderParameters.class);
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)handler, PropertiesBuilderParameters.class);
        this.manager.unregisterDefaultsHandler((DefaultParametersHandler)handler);
        XMLBuilderParameters paramsXml = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)paramsXml);
        TestDefaultParametersManager.checkNoDefaultValues(paramsXml.getParameters());
        PropertiesBuilderParameters paramsProps = this.parameters.properties();
        this.manager.initializeParameters((BuilderParameters)paramsProps);
        TestDefaultParametersManager.checkNoDefaultValues(paramsProps.getParameters());
    }

    @Test
    public void testUnregisterDefaultsHandlerSpecific() {
        FileBasedDefaultsHandler handler = new FileBasedDefaultsHandler();
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)handler, XMLBuilderParameters.class);
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)handler, PropertiesBuilderParameters.class);
        this.manager.unregisterDefaultsHandler((DefaultParametersHandler)handler, PropertiesBuilderParameters.class);
        XMLBuilderParameters paramsXml = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)paramsXml);
        TestDefaultParametersManager.checkDefaultValues(paramsXml.getParameters());
        PropertiesBuilderParameters paramsProps = this.parameters.properties();
        this.manager.initializeParameters((BuilderParameters)paramsProps);
        TestDefaultParametersManager.checkNoDefaultValues(paramsProps.getParameters());
    }

    private static class FileBasedDefaultsHandler
    implements DefaultParametersHandler<FileBasedBuilderParameters> {
        private FileBasedDefaultsHandler() {
        }

        public void initializeDefaults(FileBasedBuilderParameters parameters) {
            ((FileBasedBuilderParameters)((FileBasedBuilderParameters)parameters.setThrowExceptionOnMissing(true)).setEncoding(TestDefaultParametersManager.DEF_ENCODING)).setListDelimiterHandler(listHandler);
        }
    }
}

