/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.DatabaseBuilderParametersImpl;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDatabaseBuilderParametersImpl {
    private DatabaseBuilderParametersImpl params;

    @Before
    public void setUp() throws Exception {
        this.params = new DatabaseBuilderParametersImpl();
    }

    @Test
    public void testBeanProperties() throws Exception {
        BeanHelper.setProperty((Object)this.params, (String)"table", (Object)"testTable");
        BeanHelper.setProperty((Object)this.params, (String)"autoCommit", (Object)Boolean.FALSE);
        Map map = this.params.getParameters();
        Assert.assertEquals((String)"Wrong table name", (Object)"testTable", map.get("table"));
        Assert.assertEquals((String)"Wrong auto commit", (Object)Boolean.FALSE, map.get("autoCommit"));
    }

    @Test
    public void testSetAutoCommit() {
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setAutoCommit(true));
        Assert.assertEquals((String)"Wrong auto commit flag", (Object)Boolean.TRUE, this.params.getParameters().get("autoCommit"));
    }

    @Test
    public void testSetConfigurationName() {
        String confName = "TestConfiguration";
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setConfigurationName("TestConfiguration"));
        Assert.assertEquals((String)"Wrong configuration name", (Object)"TestConfiguration", this.params.getParameters().get("configurationName"));
    }

    @Test
    public void testSetConfigurationNameColumn() {
        String colName = "CONFIG_COLUMN";
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setConfigurationNameColumn("CONFIG_COLUMN"));
        Assert.assertEquals((String)"Wrong configuration name column", (Object)"CONFIG_COLUMN", this.params.getParameters().get("configurationNameColumn"));
    }

    @Test
    public void testSetDataSource() {
        DataSource src = (DataSource)EasyMock.createMock(DataSource.class);
        EasyMock.replay((Object[])new Object[]{src});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setDataSource(src));
        Assert.assertSame((String)"Data source not set", (Object)src, this.params.getParameters().get("dataSource"));
    }

    @Test
    public void testSetKeyColumn() {
        String colName = "KEY_COLUMN";
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setKeyColumn("KEY_COLUMN"));
        Assert.assertEquals((String)"Wrong key column name", (Object)"KEY_COLUMN", this.params.getParameters().get("keyColumn"));
    }

    @Test
    public void testSetTable() {
        String table = "TestTable";
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setTable("TestTable"));
        Assert.assertEquals((String)"Wrong table name", (Object)"TestTable", this.params.getParameters().get("table"));
    }

    @Test
    public void testSetValueColumn() {
        String colName = "VALUE_COLUMN";
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setValueColumn("VALUE_COLUMN"));
        Assert.assertEquals((String)"Wrong value column name", (Object)"VALUE_COLUMN", this.params.getParameters().get("valueColumn"));
    }
}

