/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.ConfigurationDecoder;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.convert.ConversionHandler;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.InterpolatorSpecification;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBasicBuilderParameters {
    private BasicBuilderParameters params;

    @Before
    public void setUp() throws Exception {
        this.params = new BasicBuilderParameters();
    }

    @Test
    public void testCloneDefaultLookups() {
        Lookup look = (Lookup)EasyMock.createMock(Lookup.class);
        Set<Lookup> looks = Collections.singleton(look);
        this.params.setDefaultLookups(looks);
        BasicBuilderParameters clone = this.params.clone();
        Collection defLooks = (Collection)this.params.getParameters().get("defaultLookups");
        defLooks.clear();
        defLooks = (Collection)clone.getParameters().get("defaultLookups");
        Assert.assertEquals((String)"Wrong number of default lookups", (long)1L, (long)defLooks.size());
        Assert.assertTrue((String)"Wrong default lookup", (boolean)defLooks.contains(look));
    }

    @Test
    public void testClonePrefixLookups() {
        Lookup look = (Lookup)EasyMock.createMock(Lookup.class);
        Map<String, Lookup> lookups = Collections.singletonMap("test", look);
        this.params.setPrefixLookups(lookups);
        BasicBuilderParameters clone = this.params.clone();
        Map map = (Map)this.params.getParameters().get("prefixLookups");
        map.clear();
        map = (Map)clone.getParameters().get("prefixLookups");
        Assert.assertEquals((String)"Wrong number of lookups", (long)1L, (long)map.size());
        Assert.assertSame((String)"Wrong lookup", (Object)look, map.get("test"));
    }

    @Test
    public void testCloneValues() {
        ConfigurationLogger log = (ConfigurationLogger)EasyMock.createMock(ConfigurationLogger.class);
        ConfigurationInterpolator ci = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        ListDelimiterHandler handler1 = (ListDelimiterHandler)EasyMock.createMock(ListDelimiterHandler.class);
        ListDelimiterHandler handler2 = (ListDelimiterHandler)EasyMock.createMock(ListDelimiterHandler.class);
        this.params.setListDelimiterHandler(handler1);
        this.params.setLogger(log);
        this.params.setInterpolator(ci);
        this.params.setThrowExceptionOnMissing(true);
        BasicBuilderParameters clone = this.params.clone();
        this.params.setListDelimiterHandler(handler2);
        this.params.setThrowExceptionOnMissing(false);
        Map map = clone.getParameters();
        Assert.assertSame((String)"Wrong logger", (Object)log, map.get("logger"));
        Assert.assertSame((String)"Wrong interpolator", (Object)ci, map.get("interpolator"));
        Assert.assertEquals((String)"Wrong list delimiter handler", (Object)handler1, map.get("listDelimiterHandler"));
        Assert.assertEquals((String)"Wrong exception flag", (Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
    }

    @Test
    public void testDefaults() {
        Map paramMap = this.params.getParameters();
        Assert.assertTrue((String)"Got parameters", (boolean)paramMap.isEmpty());
    }

    @Test
    public void testFetchBeanHelperNoSet() {
        Assert.assertNull((String)"Got a BeanHelper", (Object)BasicBuilderParameters.fetchBeanHelper((Map)this.params.getParameters()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFetchBeanHelperNullMap() {
        BasicBuilderParameters.fetchBeanHelper(null);
    }

    @Test
    public void testFetchInterpolatorSpecification() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        Lookup l1 = (Lookup)EasyMock.createMock(Lookup.class);
        Lookup l2 = (Lookup)EasyMock.createMock(Lookup.class);
        Lookup l3 = (Lookup)EasyMock.createMock(Lookup.class);
        HashMap<String, Lookup> prefixLookups = new HashMap<String, Lookup>();
        prefixLookups.put("p1", l1);
        prefixLookups.put("p2", l2);
        Set<Lookup> defLookups = Collections.singleton(l3);
        this.params.setParentInterpolator(parent);
        this.params.setPrefixLookups(prefixLookups);
        this.params.setDefaultLookups(defLookups);
        Map map = this.params.getParameters();
        InterpolatorSpecification spec = BasicBuilderParameters.fetchInterpolatorSpecification((Map)map);
        Assert.assertSame((String)"Wrong parent", (Object)parent, (Object)spec.getParentInterpolator());
        Assert.assertEquals((String)"Wrong prefix lookups", prefixLookups, (Object)spec.getPrefixLookups());
        Assert.assertEquals((String)"Wrong number of default lookups", (long)1L, (long)spec.getDefaultLookups().size());
        Assert.assertTrue((String)"Wrong default lookup", (boolean)spec.getDefaultLookups().contains(l3));
    }

    @Test
    public void testFetchInterpolatorSpecificationEmpty() {
        InterpolatorSpecification spec = BasicBuilderParameters.fetchInterpolatorSpecification((Map)this.params.getParameters());
        Assert.assertNull((String)"Got an interpolator", (Object)spec.getInterpolator());
        Assert.assertTrue((String)"Got lookups", (boolean)spec.getDefaultLookups().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFetchInterpolatorSpecificationInvalidCollectionValue() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("defaultLookups", Collections.singleton("not a lookup"));
        BasicBuilderParameters.fetchInterpolatorSpecification(map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFetchInterpolatorSpecificationInvalidDataType() {
        HashMap<String, TestBasicBuilderParameters> map = new HashMap<String, TestBasicBuilderParameters>();
        map.put("interpolator", this);
        BasicBuilderParameters.fetchInterpolatorSpecification(map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFetchInterpolatorSpecificationInvalidMapKey() {
        HashMap map = new HashMap();
        HashMap<Integer, Object> prefix = new HashMap<Integer, Object>();
        prefix.put(42, EasyMock.createMock(Lookup.class));
        map.put("prefixLookups", prefix);
        BasicBuilderParameters.fetchInterpolatorSpecification(map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFetchInterpolatorSpecificationInvalidMapValue() {
        HashMap map = new HashMap();
        HashMap<String, TestBasicBuilderParameters> prefix = new HashMap<String, TestBasicBuilderParameters>();
        prefix.put("test", this);
        map.put("prefixLookups", prefix);
        BasicBuilderParameters.fetchInterpolatorSpecification(map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFetchInterpolatorSpecificationNull() {
        BasicBuilderParameters.fetchInterpolatorSpecification(null);
    }

    @Test
    public void testFetchInterpolatorSpecificationWithInterpolator() {
        ConfigurationInterpolator ci = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        this.params.setInterpolator(ci);
        InterpolatorSpecification spec = BasicBuilderParameters.fetchInterpolatorSpecification((Map)this.params.getParameters());
        Assert.assertSame((String)"Wrong interpolator", (Object)ci, (Object)spec.getInterpolator());
        Assert.assertNull((String)"Got a parent", (Object)spec.getParentInterpolator());
    }

    @Test
    public void testGetParametersDefensiveCopy() {
        Map map1 = this.params.getParameters();
        HashMap mapCopy = new HashMap(map1);
        map1.put("otherProperty", "value");
        Map map2 = this.params.getParameters();
        Assert.assertNotSame((String)"Same map returned", (Object)map1, (Object)map2);
        Assert.assertEquals((String)"Different properties", mapCopy, (Object)map2);
    }

    @Test
    public void testInheritFrom() {
        BeanHelper beanHelper = new BeanHelper();
        ConfigurationDecoder decoder = (ConfigurationDecoder)EasyMock.createMock(ConfigurationDecoder.class);
        DefaultConversionHandler conversionHandler = new DefaultConversionHandler();
        DefaultListDelimiterHandler listDelimiterHandler = new DefaultListDelimiterHandler('#');
        ConfigurationLogger logger = new ConfigurationLogger("test");
        ReadWriteSynchronizer synchronizer = new ReadWriteSynchronizer();
        this.params.setBeanHelper(beanHelper).setConfigurationDecoder(decoder).setConversionHandler((ConversionHandler)conversionHandler).setListDelimiterHandler((ListDelimiterHandler)listDelimiterHandler).setLogger(logger).setSynchronizer((Synchronizer)synchronizer).setThrowExceptionOnMissing(true);
        BasicBuilderParameters p2 = new BasicBuilderParameters();
        p2.inheritFrom(this.params.getParameters());
        Map parameters = p2.getParameters();
        Assert.assertEquals((String)"Bean helper not set", (Object)beanHelper, parameters.get("config-BeanHelper"));
        Assert.assertEquals((String)"Decoder not set", (Object)decoder, parameters.get("configurationDecoder"));
        Assert.assertEquals((String)"Conversion handler not set", (Object)conversionHandler, parameters.get("conversionHandler"));
        Assert.assertEquals((String)"Delimiter handler not set", (Object)listDelimiterHandler, parameters.get("listDelimiterHandler"));
        Assert.assertEquals((String)"Logger not set", (Object)logger, parameters.get("logger"));
        Assert.assertEquals((String)"Synchronizer not set", (Object)synchronizer, parameters.get("synchronizer"));
        Assert.assertEquals((String)"Exception flag not set", (Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInheritFromNull() {
        this.params.inheritFrom(null);
    }

    @Test
    public void testInheritFromUndefinedProperties() {
        BasicBuilderParameters p2 = new BasicBuilderParameters().setThrowExceptionOnMissing(true);
        p2.inheritFrom(Collections.emptyMap());
        Map parameters = p2.getParameters();
        Assert.assertEquals((String)"Wrong number of properties", (long)1L, (long)parameters.size());
        Assert.assertEquals((String)"Exception flag not set", (Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
    }

    @Test
    public void testMerge() {
        ListDelimiterHandler handler1 = (ListDelimiterHandler)EasyMock.createMock(ListDelimiterHandler.class);
        ListDelimiterHandler handler2 = (ListDelimiterHandler)EasyMock.createMock(ListDelimiterHandler.class);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("throwExceptionOnMissing", Boolean.TRUE);
        props.put("listDelimiterHandler", handler1);
        props.put("other", "test");
        props.put("config-test", "reserved");
        BuilderParameters p = (BuilderParameters)EasyMock.createMock(BuilderParameters.class);
        EasyMock.expect((Object)p.getParameters()).andReturn(props);
        EasyMock.replay((Object[])new Object[]{p});
        this.params.setListDelimiterHandler(handler2);
        this.params.merge(p);
        Map map = this.params.getParameters();
        Assert.assertEquals((String)"Wrong list delimiter handler", (Object)handler2, map.get("listDelimiterHandler"));
        Assert.assertEquals((String)"Wrong exception flag", (Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
        Assert.assertEquals((String)"Wrong other property", (Object)"test", map.get("other"));
        Assert.assertFalse((String)"Reserved property was copied", (boolean)map.containsKey("config-test"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergeNull() {
        this.params.merge(null);
    }

    @Test
    public void testSetBeanHelper() {
        BeanHelper helper = new BeanHelper();
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setBeanHelper(helper));
        Assert.assertSame((String)"BeanHelper not set", (Object)helper, (Object)BasicBuilderParameters.fetchBeanHelper((Map)this.params.getParameters()));
    }

    @Test
    public void testSetConfigurationDecoder() {
        ConfigurationDecoder decoder = (ConfigurationDecoder)EasyMock.createMock(ConfigurationDecoder.class);
        EasyMock.replay((Object[])new Object[]{decoder});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setConfigurationDecoder(decoder));
        Assert.assertSame((String)"Decoder not set", (Object)decoder, this.params.getParameters().get("configurationDecoder"));
    }

    @Test
    public void testSetConversionHandler() {
        ConversionHandler handler = (ConversionHandler)EasyMock.createMock(ConversionHandler.class);
        EasyMock.replay((Object[])new Object[]{handler});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setConversionHandler(handler));
        Assert.assertSame((String)"ConversionHandler not set", (Object)handler, this.params.getParameters().get("conversionHandler"));
    }

    @Test
    public void testSetDefaultLookups() {
        Lookup look = (Lookup)EasyMock.createMock(Lookup.class);
        Set<Lookup> looks = Collections.singleton(look);
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setDefaultLookups(looks));
        Collection col = (Collection)this.params.getParameters().get("defaultLookups");
        Assert.assertNotSame((String)"No copy was created", (Object)col, looks);
        Assert.assertEquals((String)"Wrong number of lookups", (long)1L, (long)col.size());
        Assert.assertSame((String)"Wrong lookup", (Object)look, col.iterator().next());
        Collection col2 = (Collection)this.params.getParameters().get("defaultLookups");
        Assert.assertNotSame((String)"No copy in parameters", (Object)col, (Object)col2);
    }

    @Test
    public void testSetDefaultLookupsNull() {
        this.params.setDefaultLookups(new ArrayList());
        this.params.setDefaultLookups(null);
        Assert.assertFalse((String)"Found key", (boolean)this.params.getParameters().containsKey("defaultLookups"));
    }

    @Test
    public void testSetInterpolator() {
        ConfigurationInterpolator ci = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        EasyMock.replay((Object[])new Object[]{ci});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setInterpolator(ci));
        Assert.assertSame((String)"Wrong interpolator", (Object)ci, this.params.getParameters().get("interpolator"));
    }

    @Test
    public void testSetListDelimiter() {
        ListDelimiterHandler handler = (ListDelimiterHandler)EasyMock.createMock(ListDelimiterHandler.class);
        EasyMock.replay((Object[])new Object[]{handler});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setListDelimiterHandler(handler));
        Assert.assertSame((String)"Wrong delimiter handler", (Object)handler, this.params.getParameters().get("listDelimiterHandler"));
    }

    @Test
    public void testSetLogger() {
        ConfigurationLogger log = (ConfigurationLogger)EasyMock.createMock(ConfigurationLogger.class);
        EasyMock.replay((Object[])new Object[]{log});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setLogger(log));
        Assert.assertSame((String)"Wrong logger parameter", (Object)log, this.params.getParameters().get("logger"));
    }

    @Test
    public void testSetLookupsAndInterpolator() {
        Lookup look1 = (Lookup)EasyMock.createMock(Lookup.class);
        Lookup look2 = (Lookup)EasyMock.createMock(Lookup.class);
        ConfigurationInterpolator parent = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        ConfigurationInterpolator ci = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        this.params.setDefaultLookups(Collections.singleton(look1));
        this.params.setPrefixLookups(Collections.singletonMap("test", look2));
        this.params.setInterpolator(ci);
        this.params.setParentInterpolator(parent);
        Map map = this.params.getParameters();
        Assert.assertFalse((String)"Got prefix lookups", (boolean)map.containsKey("prefixLookups"));
        Assert.assertFalse((String)"Got default lookups", (boolean)map.containsKey("defaultLookups"));
        Assert.assertFalse((String)"Got a parent interpolator", (boolean)map.containsKey("parentInterpolator"));
    }

    @Test
    public void testSetParentInterpolator() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        EasyMock.replay((Object[])new Object[]{parent});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setParentInterpolator(parent));
        Assert.assertSame((String)"Wrong parent", (Object)parent, this.params.getParameters().get("parentInterpolator"));
    }

    @Test
    public void testSetPrefixLookups() {
        Lookup look = (Lookup)EasyMock.createMock(Lookup.class);
        Map<String, Lookup> lookups = Collections.singletonMap("test", look);
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setPrefixLookups(lookups));
        Map map = (Map)this.params.getParameters().get("prefixLookups");
        Assert.assertNotSame((String)"No copy was created", lookups, (Object)map);
        Assert.assertEquals((String)"Wrong lookup", (Object)look, map.get("test"));
        Assert.assertEquals((String)"Wrong number of lookups", (long)1L, (long)map.size());
        Map map2 = (Map)this.params.getParameters().get("prefixLookups");
        Assert.assertNotSame((String)"No copy in parameters", (Object)map, (Object)map2);
    }

    @Test
    public void testSetPrefixLookupsNull() {
        this.params.setPrefixLookups(new HashMap());
        this.params.setPrefixLookups(null);
        Assert.assertFalse((String)"Found key", (boolean)this.params.getParameters().containsKey("prefixLookups"));
    }

    @Test
    public void testSetSynchronizer() {
        Synchronizer sync = (Synchronizer)EasyMock.createMock(Synchronizer.class);
        EasyMock.replay((Object[])new Object[]{sync});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setSynchronizer(sync));
        Assert.assertSame((String)"Synchronizer not set", (Object)sync, this.params.getParameters().get("synchronizer"));
    }

    @Test
    public void testSetThrowExceptionOnMissing() {
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setThrowExceptionOnMissing(true));
        Assert.assertEquals((String)"Wrong flag value", (Object)Boolean.TRUE, this.params.getParameters().get("throwExceptionOnMissing"));
    }
}

