/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.ConstructorArg;
import org.apache.commons.configuration2.beanutils.XMLBeanDeclaration;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.junit.Assert;
import org.junit.Test;

public class TestXMLBeanDeclaration {
    private static final String[] TEST_PROPS = new String[]{"firstName", "lastName", "department", "age", "hobby"};
    private static final String[] TEST_VALUES = new String[]{"John", "Smith", "Engineering", "42", "TV"};
    private static final String[] COMPLEX_PROPS = new String[]{"address", "car"};
    private static final String[] COMPLEX_CLASSES = new String[]{"org.apache.commons.configuration.test.AddressTest", "org.apache.commons.configuration.test.CarTest"};
    private static final String[][] COMPLEX_ATTRIBUTES = new String[][]{{"street", "zip", "city", "country"}, {"brand", "color"}};
    private static final String[][] COMPLEX_VALUES = new String[][]{{"Baker Street", "12354", "London", "UK"}, {"Bentley", "silver"}};
    private static final String[] CTOR_COMPLEX_ATTRIBUTES = new String[]{"secCode", "validTo"};
    private static final String[] CTOR_COMPLEX_VALUES = new String[]{"20121110181559", "2015-01-31"};
    private static final String CTOR_ID = "20121110182006";
    private static final String KEY = "myBean";
    private static final String VARS = "variables.";

    private static void checkProperties(BeanDeclaration beanDecl, String[] names, String[] values) {
        Map props = beanDecl.getBeanProperties();
        Assert.assertEquals((String)"Wrong number of properties", (long)names.length, (long)props.size());
        for (int i = 0; i < names.length; ++i) {
            Assert.assertTrue((String)("Property " + names[i] + " not contained"), (boolean)props.containsKey(names[i]));
            Assert.assertEquals((String)("Wrong value for property " + names[i]), (Object)values[i], props.get(names[i]));
        }
    }

    private static BaseHierarchicalConfiguration prepareNestedBeanDeclarations() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        String keyCtorArg = "myBean.config-constrarg";
        TestXMLBeanDeclaration.setupBeanDeclaration(config, "myBean.config-constrarg", CTOR_COMPLEX_ATTRIBUTES, CTOR_COMPLEX_VALUES);
        config.addProperty("myBean.config-constrarg[@config-class]", (Object)"TestClass");
        config.addProperty("myBean.config-constrarg(-1)[@config-value]", (Object)CTOR_ID);
        config.addProperty("myBean.config-constrarg[@config-type]", (Object)"long");
        for (int i = 0; i < COMPLEX_PROPS.length; ++i) {
            TestXMLBeanDeclaration.setupBeanDeclaration(config, "myBean." + COMPLEX_PROPS[i], COMPLEX_ATTRIBUTES[i], COMPLEX_VALUES[i]);
            config.addProperty("myBean." + COMPLEX_PROPS[i] + "[@config-class]", (Object)COMPLEX_CLASSES[i]);
        }
        return config;
    }

    private static void setupBeanDeclaration(HierarchicalConfiguration<?> config, String key, String[] names, String[] values) {
        for (int i = 0; i < names.length; ++i) {
            config.addProperty(key + "[@" + names[i] + "]", (Object)values[i]);
        }
    }

    @Test
    public void testGetBeanClassName() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("myBean[@config-class]", (Object)this.getClass().getName());
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        Assert.assertEquals((String)"Wrong class name", (Object)this.getClass().getName(), (Object)decl.getBeanClassName());
    }

    @Test
    public void testGetBeanClassNameFromDefault() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("myBean[@someProperty]", (Object)Boolean.TRUE);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY, false, this.getClass().getName());
        Assert.assertEquals((String)"Wrong class name", (Object)this.getClass().getName(), (Object)decl.getBeanClassName());
    }

    @Test
    public void testGetBeanClassNameUndefined() {
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)new BaseHierarchicalConfiguration());
        Assert.assertNull((Object)decl.getBeanClassName());
    }

    @Test
    public void testGetBeanClassNameUndefinedWithEx() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.setThrowExceptionOnMissing(true);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config);
        Assert.assertNull((String)"Got a bean class name", (Object)decl.getBeanClassName());
    }

    @Test
    public void testGetBeanFactoryName() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("myBean[@config-factory]", (Object)"myFactory");
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        Assert.assertEquals((String)"Wrong factory name", (Object)"myFactory", (Object)decl.getBeanFactoryName());
    }

    @Test
    public void testGetBeanFactoryNameUndefined() {
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)new BaseHierarchicalConfiguration());
        Assert.assertNull((Object)decl.getBeanFactoryName());
    }

    @Test
    public void testGetBeanFactoryNameUndefinedWithEx() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.setThrowExceptionOnMissing(true);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config);
        Assert.assertNull((String)"Got a factory name", (Object)decl.getBeanFactoryName());
    }

    @Test
    public void testGetBeanFactoryParameter() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("myBean[@config-factoryParam]", (Object)"myFactoryParameter");
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        Assert.assertEquals((String)"Wrong factory parameter", (Object)"myFactoryParameter", (Object)decl.getBeanFactoryParameter());
    }

    @Test
    public void testGetBeanFactoryParameterUndefined() {
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)new BaseHierarchicalConfiguration());
        Assert.assertNull((Object)decl.getBeanFactoryParameter());
    }

    @Test
    public void testGetBeanFactoryParameterUndefinedWithEx() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.setThrowExceptionOnMissing(true);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config);
        Assert.assertNull((String)"Got a factory parameter", (Object)decl.getBeanFactoryParameter());
    }

    @Test
    public void testGetBeanProperties() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        TestXMLBeanDeclaration.checkProperties((BeanDeclaration)decl, TEST_PROPS, TEST_VALUES);
    }

    @Test
    public void testGetBeanPropertiesEmpty() {
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)new BaseHierarchicalConfiguration());
        Map props = decl.getBeanProperties();
        Assert.assertTrue((String)"Properties found", (props == null || props.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetBeanPropertiesWithReservedAttributes() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        config.addProperty("myBean[@config-testattr]", (Object)"yes");
        config.addProperty("myBean[@config-anothertest]", (Object)"this, too");
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        TestXMLBeanDeclaration.checkProperties((BeanDeclaration)decl, TEST_PROPS, TEST_VALUES);
    }

    @Test
    public void testGetConstructorArgs() {
        BaseHierarchicalConfiguration config = TestXMLBeanDeclaration.prepareNestedBeanDeclarations();
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        Collection args = decl.getConstructorArgs();
        Assert.assertEquals((String)"Wrong number of constructor arguments", (long)2L, (long)args.size());
        Iterator it = args.iterator();
        ConstructorArg arg1 = (ConstructorArg)it.next();
        Assert.assertTrue((String)"No bean declaration", (boolean)arg1.isNestedBeanDeclaration());
        TestXMLBeanDeclaration.checkProperties(arg1.getBeanDeclaration(), CTOR_COMPLEX_ATTRIBUTES, CTOR_COMPLEX_VALUES);
        Assert.assertNull((String)"Got a type", (Object)arg1.getTypeName());
        Assert.assertEquals((String)"Wrong class name", (Object)"TestClass", (Object)arg1.getBeanDeclaration().getBeanClassName());
        ConstructorArg arg2 = (ConstructorArg)it.next();
        Assert.assertFalse((String)"A bean declaration", (boolean)arg2.isNestedBeanDeclaration());
        Assert.assertEquals((String)"Wrong value", (Object)CTOR_ID, (Object)arg2.getValue());
        Assert.assertEquals((String)"Wrong type", (Object)"long", (Object)arg2.getTypeName());
    }

    @Test
    public void testGetConstructorArgsNullArg() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        config.addProperty("myBean.config-constrarg", (Object)"");
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        Collection args = decl.getConstructorArgs();
        Assert.assertEquals((String)"Wrong number of constructor arguments", (long)1L, (long)args.size());
        ConstructorArg arg = (ConstructorArg)args.iterator().next();
        Assert.assertFalse((String)"A bean declaration", (boolean)arg.isNestedBeanDeclaration());
        Assert.assertNull((String)"Got a value", (Object)arg.getValue());
    }

    @Test
    public void testGetInterpolatedBeanProperties() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        String[] varValues = new String[TEST_PROPS.length];
        for (int i = 0; i < TEST_PROPS.length; ++i) {
            varValues[i] = "${variables." + TEST_PROPS[i] + "}";
            config.addProperty(VARS + TEST_PROPS[i], (Object)TEST_VALUES[i]);
        }
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, varValues);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        TestXMLBeanDeclaration.checkProperties((BeanDeclaration)decl, TEST_PROPS, TEST_VALUES);
    }

    @Test
    public void testGetInterpolatedConstructorArgs() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        String expectedValue = "ctorArg";
        config.addProperty("value", (Object)"ctorArg");
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        config.addProperty("myBean.config-constrarg[@config-value]", (Object)"${value}");
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        Collection args = decl.getConstructorArgs();
        ConstructorArg arg = (ConstructorArg)args.iterator().next();
        Assert.assertEquals((String)"Wrong interpolated value", (Object)"ctorArg", (Object)arg.getValue());
    }

    @Test
    public void testGetNestedBeanDeclarations() {
        BaseHierarchicalConfiguration config = TestXMLBeanDeclaration.prepareNestedBeanDeclarations();
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        TestXMLBeanDeclaration.checkProperties((BeanDeclaration)decl, TEST_PROPS, TEST_VALUES);
        Map nested = decl.getNestedBeanDeclarations();
        Assert.assertEquals((String)"Wrong number of nested declarations", (long)COMPLEX_PROPS.length, (long)nested.size());
        for (int i = 0; i < COMPLEX_PROPS.length; ++i) {
            XMLBeanDeclaration d = (XMLBeanDeclaration)nested.get(COMPLEX_PROPS[i]);
            Assert.assertNotNull((String)("No declaration found for " + COMPLEX_PROPS[i]), (Object)d);
            TestXMLBeanDeclaration.checkProperties((BeanDeclaration)d, COMPLEX_ATTRIBUTES[i], COMPLEX_VALUES[i]);
            Assert.assertEquals((String)"Wrong bean class", (Object)COMPLEX_CLASSES[i], (Object)d.getBeanClassName());
        }
    }

    @Test
    public void testGetNestedBeanDeclarationsEmpty() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        Map nested = decl.getNestedBeanDeclarations();
        Assert.assertTrue((String)"Found nested declarations", (nested == null || nested.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetNestedBeanDeclarationsFactoryMethod() {
        BaseHierarchicalConfiguration config = TestXMLBeanDeclaration.prepareNestedBeanDeclarations();
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY){

            BeanDeclaration createBeanDeclaration(XMLBeanDeclaration.NodeData<?> node) {
                return new XMLBeanDeclarationTestImpl(this.getConfiguration().configurationAt(node.nodeName()), node);
            }
        };
        Map nested = decl.getNestedBeanDeclarations();
        for (String element : COMPLEX_PROPS) {
            Object d = nested.get(element);
            Assert.assertTrue((String)("Wrong class for bean declaration: " + d), (boolean)(d instanceof XMLBeanDeclarationTestImpl));
        }
    }

    @Test
    public void testGetNestedBeanDeclarationsReservedCharacter() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        String key = "myBean.address..private";
        TestXMLBeanDeclaration.setupBeanDeclaration(config, "myBean.address..private", COMPLEX_ATTRIBUTES[0], COMPLEX_VALUES[0]);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        Map nested = decl.getNestedBeanDeclarations();
        Assert.assertTrue((String)"Key not found", (boolean)nested.containsKey("address.private"));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testInitFromMultiValueKey() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty(KEY, (Object)"myFirstKey");
        config.addProperty(KEY, (Object)"mySecondKey");
        new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromNullConfiguration() {
        new XMLBeanDeclaration(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromNullConfigurationAndKey() {
        new XMLBeanDeclaration(null, KEY);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testInitFromUndefinedKey() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        new XMLBeanDeclaration((HierarchicalConfiguration)config, "undefined_key");
    }

    @Test
    public void testInitFromUndefinedKeyOptional() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, "undefined_key", true);
        Assert.assertNull((String)"Found a bean class", (Object)decl.getBeanClassName());
    }

    @Test
    public void testInterpolateNoInterpolator() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("value", (Object)"expectedValue");
        TestXMLBeanDeclaration.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        String value = "${value}";
        config.addProperty("myBean.config-constrarg[@config-value]", (Object)"${value}");
        config.setInterpolator(null);
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY);
        Collection args = decl.getConstructorArgs();
        ConstructorArg arg = (ConstructorArg)args.iterator().next();
        Assert.assertEquals((String)"Value was changed", (Object)"${value}", (Object)arg.getValue());
    }

    @Test
    public void tetGetBeanClassNameDefaultOverride() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("myBean[@config-class]", (Object)this.getClass().getName());
        XMLBeanDeclaration decl = new XMLBeanDeclaration((HierarchicalConfiguration)config, KEY, false, "someDefaultClassName");
        Assert.assertEquals((String)"Wrong class name", (Object)this.getClass().getName(), (Object)decl.getBeanClassName());
    }

    private static class XMLBeanDeclarationTestImpl
    extends XMLBeanDeclaration {
        public XMLBeanDeclarationTestImpl(HierarchicalConfiguration<?> config, XMLBeanDeclaration.NodeData<?> node) {
            super(config, node);
        }
    }
}

