/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLDocumentHelper;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TestXMLDocumentHelper {
    private static final String ELEMENT = "testElementName";
    private static final String TEST_FILE = "testcombine1.xml";

    private static String documentToString(Document document) throws ConfigurationException {
        Transformer transformer = XMLDocumentHelper.createTransformer();
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        XMLDocumentHelper.transform((Transformer)transformer, (Source)new DOMSource(document.getDocumentElement()), (Result)result);
        return writer.toString();
    }

    private static String documentToString(XMLDocumentHelper helper) throws ConfigurationException {
        return TestXMLDocumentHelper.documentToString(helper.getDocument());
    }

    private static Collection<Node> findTextElements(Document document) {
        HashSet<Node> texts = new HashSet<Node>();
        TestXMLDocumentHelper.findTextElementsForNode(document.getDocumentElement(), texts);
        return texts;
    }

    private static void findTextElementsForNode(Node node, Collection<Node> texts) {
        if (node instanceof Text) {
            texts.add(node);
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            TestXMLDocumentHelper.findTextElementsForNode(childNodes.item(i), texts);
        }
    }

    private static Document loadDocument() throws ParserConfigurationException, IOException, SAXException {
        return TestXMLDocumentHelper.loadDocument(TEST_FILE);
    }

    private static Document loadDocument(String name) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(ConfigurationAssert.getTestFile(name));
    }

    private void checkCopyElementMapping(String file) throws Exception {
        XMLDocumentHelper helper = XMLDocumentHelper.forSourceDocument((Document)TestXMLDocumentHelper.loadDocument(file));
        XMLDocumentHelper copy = helper.createCopy();
        Collection<Node> texts = TestXMLDocumentHelper.findTextElements(helper.getDocument());
        Assert.assertFalse((String)"No texts", (boolean)texts.isEmpty());
        for (Node n : texts) {
            Text txtSrc = (Text)n;
            Text txtCopy = (Text)copy.getElementMapping().get(n);
            Assert.assertNotNull((String)("No matching element for " + n), (Object)txtCopy);
            Assert.assertEquals((String)"Wrong text", (Object)txtSrc.getData(), (Object)txtCopy.getData());
        }
    }

    @Test
    public void testCopyDocument() throws Exception {
        XMLDocumentHelper helper = XMLDocumentHelper.forSourceDocument((Document)TestXMLDocumentHelper.loadDocument());
        XMLDocumentHelper copy = helper.createCopy();
        Assert.assertNotSame((String)"Same documents", (Object)helper.getDocument(), (Object)copy.getDocument());
        String doc1 = TestXMLDocumentHelper.documentToString(helper);
        String doc2 = TestXMLDocumentHelper.documentToString(copy);
        Assert.assertEquals((String)"Different document contents", (Object)doc1, (Object)doc2);
    }

    @Test
    public void testCopyElementMapping() throws Exception {
        this.checkCopyElementMapping(TEST_FILE);
    }

    @Test
    public void testCopyElementMappingForComplexDocument() throws Exception {
        this.checkCopyElementMapping("test.xml");
    }

    @Test
    public void testCreateDocumentBuilderFromFactoryException() throws ParserConfigurationException {
        DocumentBuilderFactory factory = (DocumentBuilderFactory)EasyMock.createMock(DocumentBuilderFactory.class);
        ParserConfigurationException pcex = new ParserConfigurationException();
        EasyMock.expect((Object)factory.newDocumentBuilder()).andThrow((Throwable)pcex);
        EasyMock.replay((Object[])new Object[]{factory});
        try {
            XMLDocumentHelper.createDocumentBuilder((DocumentBuilderFactory)factory);
            Assert.fail((String)"Exception not detected!");
        }
        catch (ConfigurationException cex) {
            Assert.assertEquals((String)"Wrong cause", (Object)pcex, (Object)cex.getCause());
        }
    }

    @Test
    public void testCreateTransformerFactory() {
        Assert.assertNotNull((String)"No factory", (Object)XMLDocumentHelper.createTransformerFactory());
    }

    @Test
    public void testCreateTransformerFactoryException() throws TransformerConfigurationException {
        TransformerFactory factory = (TransformerFactory)EasyMock.createMock(TransformerFactory.class);
        TransformerConfigurationException cause = new TransformerConfigurationException();
        EasyMock.expect((Object)factory.newTransformer()).andThrow((Throwable)cause);
        EasyMock.replay((Object[])new Object[]{factory});
        try {
            XMLDocumentHelper.createTransformer((TransformerFactory)factory);
            Assert.fail((String)"Exception not detected!");
        }
        catch (ConfigurationException cex) {
            Assert.assertEquals((String)"Wrong cause", (Object)cause, (Object)cex.getCause());
        }
    }

    @Test
    public void testElementMappingForNewDocument() throws ConfigurationException {
        XMLDocumentHelper helper = XMLDocumentHelper.forNewDocument((String)ELEMENT);
        Assert.assertTrue((String)"Got an element mapping", (boolean)helper.getElementMapping().isEmpty());
    }

    @Test
    public void testElementMappingForSourceDocument() throws Exception {
        Document doc = TestXMLDocumentHelper.loadDocument();
        XMLDocumentHelper helper = XMLDocumentHelper.forSourceDocument((Document)doc);
        Assert.assertTrue((String)"Got an element mapping", (boolean)helper.getElementMapping().isEmpty());
    }

    @Test
    public void testInitForNewDocument() throws ConfigurationException {
        XMLDocumentHelper helper = XMLDocumentHelper.forNewDocument((String)ELEMENT);
        Document doc = helper.getDocument();
        Element rootElement = doc.getDocumentElement();
        Assert.assertEquals((String)"Wrong root element name", (Object)ELEMENT, (Object)rootElement.getNodeName());
        NodeList childNodes = rootElement.getChildNodes();
        Assert.assertEquals((String)"Got child nodes", (long)0L, (long)childNodes.getLength());
        Assert.assertNull((String)"Got a public ID", (Object)helper.getSourcePublicID());
        Assert.assertNull((String)"Got a system ID", (Object)helper.getSourceSystemID());
    }

    @Test
    public void testInitForSourceDocument() throws Exception {
        Document doc = TestXMLDocumentHelper.loadDocument();
        XMLDocumentHelper helper = XMLDocumentHelper.forSourceDocument((Document)doc);
        Assert.assertNotSame((String)"Same source document", (Object)doc, (Object)helper.getDocument());
        Assert.assertEquals((String)"Wrong document content", (Object)TestXMLDocumentHelper.documentToString(doc), (Object)TestXMLDocumentHelper.documentToString(helper));
    }

    @Test
    public void testTransformException() throws TransformerException {
        Transformer transformer = (Transformer)EasyMock.createMock(Transformer.class);
        Source src = (Source)EasyMock.createMock(Source.class);
        Result res = (Result)EasyMock.createMock(Result.class);
        TransformerException tex = new TransformerException("Test Exception");
        transformer.transform(src, res);
        EasyMock.expectLastCall().andThrow((Throwable)tex);
        EasyMock.replay((Object[])new Object[]{transformer, src, res});
        try {
            XMLDocumentHelper.transform((Transformer)transformer, (Source)src, (Result)res);
            Assert.fail((String)"Exception not detected!");
        }
        catch (ConfigurationException cex) {
            Assert.assertEquals((String)"Wrong cause", (Object)tex, (Object)cex.getCause());
        }
    }
}

