/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.junit.Assert;
import org.junit.Test;

public class TestXMLConfiguration_605 {
    private static void checkConfiguration(Configuration config) {
        Assert.assertTrue((String)"Configuration has key key0", (boolean)config.containsKey("key0"));
        Assert.assertTrue((String)"Configuration has key key1", (boolean)config.containsKey("key1"));
        Assert.assertTrue((String)"Configuration has key key3", (boolean)config.containsKey("key3"));
        Assert.assertTrue((String)"Configuration has key key2", (boolean)config.containsKey("key2"));
    }

    private static Configuration create(String content) throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new LegacyListDelimiterHandler(','));
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load((Reader)new StringReader(content));
        return config;
    }

    private static Configuration create(String content, ListDelimiterHandler delimiterHandler) throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        config.setListDelimiterHandler(delimiterHandler);
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load((Reader)new StringReader(content));
        return config;
    }

    @Test
    public void testWithCommaSeparatedList() throws Exception {
        String source = "<configuration><key0></key0><key1>a,b</key1><key2></key2><key3></key3></configuration>";
        TestXMLConfiguration_605.checkConfiguration(TestXMLConfiguration_605.create("<configuration><key0></key0><key1>a,b</key1><key2></key2><key3></key3></configuration>"));
    }

    @Test
    public void testWithNoComma() throws Exception {
        String source = "<configuration><key0></key0><key1></key1><key2></key2><key3></key3></configuration>";
        TestXMLConfiguration_605.checkConfiguration(TestXMLConfiguration_605.create("<configuration><key0></key0><key1></key1><key2></key2><key3></key3></configuration>"));
    }

    @Test
    public void testWithOnlyComma() throws Exception {
        String source = "<configuration><key0></key0><key1>,</key1><key2></key2><key3></key3></configuration>";
        TestXMLConfiguration_605.checkConfiguration(TestXMLConfiguration_605.create("<configuration><key0></key0><key1>,</key1><key2></key2><key3></key3></configuration>"));
    }

    @Test
    public void testWithOnlyCommaWithoutDelimiterParsing() throws Exception {
        String source = "<configuration><key0></key0><key1>,</key1><key2></key2><key3></key3></configuration>";
        TestXMLConfiguration_605.checkConfiguration(TestXMLConfiguration_605.create("<configuration><key0></key0><key1>,</key1><key2></key2><key3></key3></configuration>", DisabledListDelimiterHandler.INSTANCE));
    }

    @Test
    public void testWithOnlyCommaWithStringBuilder() throws Exception {
        StringBuilder sourceBuilder = new StringBuilder("<configuration>");
        sourceBuilder.append("<key0></key0>");
        sourceBuilder.append("<key1>,</key1>");
        sourceBuilder.append("<key2></key2>");
        sourceBuilder.append("<key3></key3>");
        sourceBuilder.append("</configuration>");
        TestXMLConfiguration_605.checkConfiguration(TestXMLConfiguration_605.create(sourceBuilder.toString()));
    }

    @Test
    public void testWithOnlyCommaWithStringBuilderWithoutDelimiterParsing() throws Exception {
        StringBuilder sourceBuilder = new StringBuilder("<configuration>");
        sourceBuilder.append("<key0></key0>");
        sourceBuilder.append("<key1>,</key1>");
        sourceBuilder.append("<key2></key2>");
        sourceBuilder.append("<key3></key3>");
        sourceBuilder.append("</configuration>");
        TestXMLConfiguration_605.checkConfiguration(TestXMLConfiguration_605.create(sourceBuilder.toString(), DisabledListDelimiterHandler.INSTANCE));
    }

    @Test
    public void testWithSeparatingNonWhitespace() throws Exception {
        String source = "<configuration><key0></key0><key1>,</key1>A<key2></key2><key3></key3></configuration>";
        TestXMLConfiguration_605.checkConfiguration(TestXMLConfiguration_605.create("<configuration><key0></key0><key1>,</key1>A<key2></key2><key3></key3></configuration>"));
    }

    @Test
    public void testWithSeparatingWhitespace() throws Exception {
        String source = "<configuration><key0></key0><key1>,</key1> <key2></key2><key3></key3></configuration>";
        TestXMLConfiguration_605.checkConfiguration(TestXMLConfiguration_605.create("<configuration><key0></key0><key1>,</key1> <key2></key2><key3></key3></configuration>"));
    }
}

